/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.control;

import java.nio.ByteBuffer;
import org.ldaptive.LdapUtils;
import org.ldaptive.ResultCode;
import org.ldaptive.asn1.AbstractParseHandler;
import org.ldaptive.asn1.DERParser;
import org.ldaptive.asn1.DERPath;
import org.ldaptive.asn1.IntegerType;
import org.ldaptive.asn1.OctetStringType;
import org.ldaptive.asn1.ParseHandler;
import org.ldaptive.control.AbstractControl;
import org.ldaptive.control.ResponseControl;

public class VirtualListViewResponseControl
extends AbstractControl
implements ResponseControl {
    public static final String OID = "2.16.840.1.113730.3.4.10";
    private static final int HASH_CODE_SEED = 773;
    private int targetPosition;
    private int contentCount;
    private ResultCode viewResult;
    private byte[] contextID;

    public VirtualListViewResponseControl() {
        super(OID);
    }

    public VirtualListViewResponseControl(boolean critical) {
        super(OID, critical);
    }

    public VirtualListViewResponseControl(int position, int count, ResultCode code, byte[] context) {
        this(position, count, code, context, false);
    }

    public VirtualListViewResponseControl(int position, int count, ResultCode code, byte[] context, boolean critical) {
        super(OID, critical);
        this.setTargetPosition(position);
        this.setContentCount(count);
        this.setViewResult(code);
        this.setContextID(context);
    }

    public int getTargetPosition() {
        return this.targetPosition;
    }

    public void setTargetPosition(int position) {
        this.targetPosition = position;
    }

    public int getContentCount() {
        return this.contentCount;
    }

    public void setContentCount(int count) {
        this.contentCount = count;
    }

    public ResultCode getViewResult() {
        return this.viewResult;
    }

    public void setViewResult(ResultCode code) {
        this.viewResult = code;
    }

    public byte[] getContextID() {
        return this.contextID;
    }

    public void setContextID(byte[] id) {
        this.contextID = id;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof VirtualListViewResponseControl && super.equals(o)) {
            VirtualListViewResponseControl v = (VirtualListViewResponseControl)o;
            return LdapUtils.areEqual(this.targetPosition, v.targetPosition) && LdapUtils.areEqual(this.contentCount, v.contentCount) && LdapUtils.areEqual((Object)this.viewResult, (Object)v.viewResult) && LdapUtils.areEqual(this.contextID, v.contextID);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return LdapUtils.computeHashCode(773, new Object[]{this.getOID(), this.getCriticality(), this.targetPosition, this.contentCount, this.viewResult, this.contextID});
    }

    public String toString() {
        return String.format("[%s@%d::criticality=%s, targetPosition=%s, contentCount=%s, viewResult=%s, contextID=%s]", new Object[]{this.getClass().getName(), this.hashCode(), this.getCriticality(), this.targetPosition, this.contentCount, this.viewResult, LdapUtils.base64Encode(this.contextID)});
    }

    @Override
    public void decode(byte[] berValue) {
        this.logger.trace("decoding control: {}", (Object)LdapUtils.base64Encode(berValue));
        DERParser parser = new DERParser();
        parser.registerHandler(TargetPositionHandler.PATH, (ParseHandler)new TargetPositionHandler(this));
        parser.registerHandler(ContentCountHandler.PATH, (ParseHandler)new ContentCountHandler(this));
        parser.registerHandler(ViewResultHandler.PATH, (ParseHandler)new ViewResultHandler(this));
        parser.registerHandler(ContextIDHandler.PATH, (ParseHandler)new ContextIDHandler(this));
        parser.parse(ByteBuffer.wrap(berValue));
    }

    private static class ContextIDHandler
    extends AbstractParseHandler<VirtualListViewResponseControl> {
        public static final DERPath PATH = new DERPath("/SEQ/OCTSTR");

        public ContextIDHandler(VirtualListViewResponseControl control) {
            super(control);
        }

        @Override
        public void handle(DERParser parser, ByteBuffer encoded) {
            byte[] cookie = OctetStringType.readBuffer(encoded);
            if (cookie != null && cookie.length > 0) {
                ((VirtualListViewResponseControl)this.getObject()).setContextID(cookie);
            }
        }
    }

    private static class ViewResultHandler
    extends AbstractParseHandler<VirtualListViewResponseControl> {
        public static final DERPath PATH = new DERPath("/SEQ/INT[2]");

        public ViewResultHandler(VirtualListViewResponseControl control) {
            super(control);
        }

        @Override
        public void handle(DERParser parser, ByteBuffer encoded) {
            int resultValue = IntegerType.decode(encoded).intValue();
            ResultCode rc = ResultCode.valueOf(resultValue);
            if (rc == null) {
                throw new IllegalArgumentException("Unknown result code " + resultValue);
            }
            ((VirtualListViewResponseControl)this.getObject()).setViewResult(rc);
        }
    }

    private static class ContentCountHandler
    extends AbstractParseHandler<VirtualListViewResponseControl> {
        public static final DERPath PATH = new DERPath("/SEQ/INT[1]");

        public ContentCountHandler(VirtualListViewResponseControl control) {
            super(control);
        }

        @Override
        public void handle(DERParser parser, ByteBuffer encoded) {
            ((VirtualListViewResponseControl)this.getObject()).setContentCount(IntegerType.decode(encoded).intValue());
        }
    }

    private static class TargetPositionHandler
    extends AbstractParseHandler<VirtualListViewResponseControl> {
        public static final DERPath PATH = new DERPath("/SEQ/INT[0]");

        public TargetPositionHandler(VirtualListViewResponseControl control) {
            super(control);
        }

        @Override
        public void handle(DERParser parser, ByteBuffer encoded) {
            ((VirtualListViewResponseControl)this.getObject()).setTargetPosition(IntegerType.decode(encoded).intValue());
        }
    }
}

