/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.wayang.api.json.parserutil

import org.apache.wayang.api.json.exception.WayangApiJsonException

import scala.reflect.runtime.universe._
import scala.tools.reflect.ToolBox

class SerializableLambda[IN, OUT](string: String) extends (IN => OUT) with Serializable {
  @transient lazy val lambdaFunction: IN => OUT = {
    val toolbox = runtimeMirror(getClass.getClassLoader).mkToolBox()
    try {
      val tree = toolbox.parse(string)
      toolbox.compile(tree)().asInstanceOf[IN => OUT]
    }
    catch {
      case e: Throwable =>
        ParsingErrors.handleException(e, string)
    }
  }

  def apply(input: IN): OUT = lambdaFunction(input)
}

object SerializableLambda {
  def createLambda[IN, OUT](string: String): SerializableLambda[IN, OUT] = {
    new SerializableLambda[IN, OUT](string)
  }
}
