/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.storage.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.ignite.internal.raft.configuration.LogStorageBudgetView;
import org.apache.ignite.internal.raft.storage.LogStorageFactory;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.raft.jraft.core.LogStorageBudgetFactory;
import org.apache.ignite.raft.jraft.core.LogStorageBudgetsModule;
import org.apache.ignite.raft.jraft.option.RaftOptions;
import org.apache.ignite.raft.jraft.storage.LogStorage;
import org.apache.ignite.raft.jraft.storage.impl.LogStorageBudget;
import org.apache.ignite.raft.jraft.storage.impl.OnHeapLogs;
import org.apache.ignite.raft.jraft.storage.impl.RocksDbSpillout;
import org.apache.ignite.raft.jraft.storage.impl.VolatileLogStorage;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;

public class VolatileLogStorageFactory
implements LogStorageFactory {
    private final LogStorageBudgetView logStorageBudgetConfig;
    private final RocksDB db;
    private final ColumnFamilyHandle columnFamily;
    private final Executor executor;
    private final Map<String, LogStorageBudgetFactory> budgetFactories;

    public VolatileLogStorageFactory(LogStorageBudgetView logStorageBudgetConfig, RocksDB db, ColumnFamilyHandle columnFamily, Executor executor) {
        this.logStorageBudgetConfig = logStorageBudgetConfig;
        this.db = db;
        this.columnFamily = columnFamily;
        this.executor = executor;
        HashMap<String, LogStorageBudgetFactory> factories = new HashMap<String, LogStorageBudgetFactory>();
        ClassLoader serviceClassLoader = Thread.currentThread().getContextClassLoader();
        for (LogStorageBudgetsModule module : ServiceLoader.load(LogStorageBudgetsModule.class, serviceClassLoader)) {
            Map<String, LogStorageBudgetFactory> factoriesFromModule = module.budgetFactories();
            this.checkForBudgetNameClashes(factories.keySet(), factoriesFromModule.keySet());
            factories.putAll(factoriesFromModule);
        }
        this.budgetFactories = Map.copyOf(factories);
    }

    private void checkForBudgetNameClashes(Set<String> names1, Set<String> names2) {
        HashSet<String> intersection = new HashSet<String>(names1);
        intersection.retainAll(names2);
        if (!intersection.isEmpty()) {
            throw new IgniteInternalException(String.format("Storage budget '%s' is provided by more than one module", intersection.iterator().next()));
        }
    }

    @Override
    public void start() {
    }

    @Override
    public LogStorage createLogStorage(String groupId, RaftOptions raftOptions) {
        RocksDbSpillout spiltOnDisk = new RocksDbSpillout(this.db, this.columnFamily, groupId, this.executor);
        return new VolatileLogStorage(this.createLogStorageBudget(), new OnHeapLogs(), spiltOnDisk);
    }

    private LogStorageBudget createLogStorageBudget() {
        return this.newBudget(this.logStorageBudgetConfig);
    }

    private LogStorageBudget newBudget(LogStorageBudgetView logStorageBudgetConfig) {
        LogStorageBudgetFactory factory = this.budgetFactories.get(logStorageBudgetConfig.name());
        if (factory == null) {
            throw new IgniteInternalException("Cannot find a log storage budget by name '" + logStorageBudgetConfig.name() + "'");
        }
        return factory.create(logStorageBudgetConfig);
    }

    @Override
    public void close() throws Exception {
    }
}

