/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.SettableApiFuture;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.cloud.storage.BidiResumableWrite;
import com.google.cloud.storage.BidiWriteCtx;
import com.google.cloud.storage.ChunkSegmenter;
import com.google.cloud.storage.Conversions;
import com.google.cloud.storage.Crc32cValue;
import com.google.cloud.storage.GrpcUtils;
import com.google.cloud.storage.Retrying;
import com.google.cloud.storage.UnbufferedWritableByteChannelSession;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import com.google.storage.v2.BidiWriteObjectRequest;
import com.google.storage.v2.BidiWriteObjectResponse;
import com.google.storage.v2.ChecksummedData;
import com.google.storage.v2.ObjectChecksums;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;

final class GapicBidiUnbufferedWritableByteChannel
implements UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel {
    private final BidiStreamingCallable<BidiWriteObjectRequest, BidiWriteObjectResponse> write;
    private final Retrying.RetryingDependencies deps;
    private final ResultRetryAlgorithm<?> alg;
    private final String bucketName;
    private final Supplier<GrpcCallContext> baseContextSupplier;
    private final SettableApiFuture<BidiWriteObjectResponse> resultFuture;
    private final ChunkSegmenter chunkSegmenter;
    private final BidiWriteCtx<BidiResumableWrite> writeCtx;
    private final BidiObserver responseObserver;
    private volatile ApiStreamObserver<BidiWriteObjectRequest> stream;
    private boolean open = true;
    private boolean first = true;
    private boolean finished = false;

    GapicBidiUnbufferedWritableByteChannel(BidiStreamingCallable<BidiWriteObjectRequest, BidiWriteObjectResponse> write, Retrying.RetryingDependencies deps, ResultRetryAlgorithm<?> alg, SettableApiFuture<BidiWriteObjectResponse> resultFuture, ChunkSegmenter chunkSegmenter, BidiResumableWrite requestFactory, Supplier<GrpcCallContext> baseContextSupplier) {
        this.write = write;
        this.deps = deps;
        this.alg = alg;
        this.baseContextSupplier = baseContextSupplier;
        this.bucketName = requestFactory.bucketName();
        this.resultFuture = resultFuture;
        this.chunkSegmenter = chunkSegmenter;
        this.writeCtx = new BidiWriteCtx<BidiResumableWrite>(requestFactory);
        this.responseObserver = new BidiObserver();
    }

    @Override
    public long write(ByteBuffer[] srcs, int srcsOffset, int srcsLength) throws IOException {
        return this.internalWrite(srcs, srcsOffset, srcsLength, false);
    }

    @Override
    public long writeAndClose(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long written = this.internalWrite(srcs, offset, length, true);
        this.close();
        return written;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        if (!this.open) {
            return;
        }
        ApiStreamObserver<BidiWriteObjectRequest> openedStream = this.openedStream();
        if (!this.finished) {
            BidiWriteObjectRequest message = this.finishMessage();
            try {
                openedStream.onNext((Object)message);
                this.finished = true;
                openedStream.onCompleted();
            }
            catch (RuntimeException e) {
                this.resultFuture.setException((Throwable)e);
                throw e;
            }
        } else {
            openedStream.onCompleted();
        }
        this.responseObserver.await();
        this.open = false;
    }

    @VisibleForTesting
    BidiWriteCtx<BidiResumableWrite> getWriteCtx() {
        return this.writeCtx;
    }

    private long internalWrite(ByteBuffer[] srcs, int srcsOffset, int srcsLength, boolean finalize) throws ClosedChannelException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        ChunkSegmenter.ChunkSegment[] data = this.chunkSegmenter.segmentBuffers(srcs, srcsOffset, srcsLength);
        ArrayList<BidiWriteObjectRequest> messages = new ArrayList<BidiWriteObjectRequest>();
        int bytesConsumed = 0;
        for (ChunkSegmenter.ChunkSegment datum : data) {
            Crc32cValue.Crc32cLengthKnown crc32c = datum.getCrc32c();
            ByteString b = datum.getB();
            int contentSize = b.size();
            long offset = this.writeCtx.getTotalSentBytes().getAndAdd(contentSize);
            Crc32cValue.Crc32cLengthKnown cumulative = this.writeCtx.getCumulativeCrc32c().accumulateAndGet(crc32c, this.chunkSegmenter.getHasher()::nullSafeConcat);
            ChecksummedData.Builder checksummedData = ChecksummedData.newBuilder().setContent(b);
            if (crc32c != null) {
                checksummedData.setCrc32C(crc32c.getValue());
            }
            BidiWriteObjectRequest.Builder builder = this.writeCtx.newRequestBuilder().setWriteOffset(offset).setChecksummedData(checksummedData.build());
            if (!datum.isOnlyFullBlocks()) {
                builder.setFinishWrite(true);
                if (cumulative != null) {
                    builder.setObjectChecksums(ObjectChecksums.newBuilder().setCrc32C(cumulative.getValue()).build());
                }
                this.finished = true;
            }
            BidiWriteObjectRequest build = GapicBidiUnbufferedWritableByteChannel.possiblyPairDownBidiRequest(builder, this.first).build();
            this.first = false;
            messages.add(build);
            bytesConsumed += contentSize;
        }
        if (finalize && !this.finished) {
            messages.add(this.finishMessage());
            this.finished = true;
        }
        try {
            this.flush(messages);
        }
        catch (RuntimeException e) {
            this.resultFuture.setException((Throwable)e);
            throw e;
        }
        return bytesConsumed;
    }

    private @NonNull BidiWriteObjectRequest finishMessage() {
        long offset = this.writeCtx.getTotalSentBytes().get();
        Crc32cValue.Crc32cLengthKnown crc32cValue = this.writeCtx.getCumulativeCrc32c().get();
        BidiWriteObjectRequest.Builder b = this.writeCtx.newRequestBuilder().setFinishWrite(true).setWriteOffset(offset);
        if (crc32cValue != null) {
            b.setObjectChecksums(ObjectChecksums.newBuilder().setCrc32C(crc32cValue.getValue()).build());
        }
        BidiWriteObjectRequest message = b.build();
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiStreamObserver<BidiWriteObjectRequest> openedStream() {
        if (this.stream == null) {
            GapicBidiUnbufferedWritableByteChannel gapicBidiUnbufferedWritableByteChannel = this;
            synchronized (gapicBidiUnbufferedWritableByteChannel) {
                if (this.stream == null) {
                    GrpcCallContext internalContext = GrpcUtils.contextWithBucketName(this.bucketName, this.baseContextSupplier.get());
                    this.stream = this.write.withDefaultCallContext((ApiCallContext)internalContext).bidiStreamingCall((ApiStreamObserver)this.responseObserver);
                    this.responseObserver.sem.drainPermits();
                }
            }
        }
        return this.stream;
    }

    private void flush(@NonNull List<BidiWriteObjectRequest> segments) {
        Retrying.run(this.deps, this.alg, () -> {
            try {
                ApiStreamObserver<BidiWriteObjectRequest> opened = this.openedStream();
                for (BidiWriteObjectRequest message : segments) {
                    opened.onNext((Object)message);
                }
                if (!this.finished) {
                    BidiWriteObjectRequest message = BidiWriteObjectRequest.newBuilder().setFlush(true).setStateLookup(true).build();
                    opened.onNext((Object)message);
                }
                this.responseObserver.await();
                return null;
            }
            catch (Exception e) {
                this.stream = null;
                this.first = true;
                throw e;
            }
        }, Conversions.Decoder.identity());
    }

    private static BidiWriteObjectRequest.Builder possiblyPairDownBidiRequest(BidiWriteObjectRequest.Builder b, boolean firstMessageOfStream) {
        if (firstMessageOfStream && b.getWriteOffset() == 0L) {
            return b;
        }
        if (!firstMessageOfStream) {
            b.clearUploadId();
        }
        if (b.getWriteOffset() > 0L) {
            b.clearWriteObjectSpec();
        }
        if (b.getWriteOffset() > 0L && !b.getFinishWrite()) {
            b.clearObjectChecksums();
        }
        return b;
    }

    private class BidiObserver
    implements ApiStreamObserver<BidiWriteObjectResponse> {
        private final Semaphore sem = new Semaphore(0);
        private volatile BidiWriteObjectResponse last;
        private volatile RuntimeException previousError;

        private BidiObserver() {
        }

        public void onNext(BidiWriteObjectResponse value) {
            if (value.hasPersistedSize()) {
                GapicBidiUnbufferedWritableByteChannel.this.writeCtx.getConfirmedBytes().set(value.getPersistedSize());
            } else if (value.hasResource()) {
                GapicBidiUnbufferedWritableByteChannel.this.writeCtx.getConfirmedBytes().set(value.getResource().getSize());
            }
            this.sem.release();
            this.last = value;
        }

        public void onError(Throwable t) {
            if (t instanceof RuntimeException) {
                this.previousError = (RuntimeException)t;
            }
            this.sem.release();
        }

        public void onCompleted() {
            if (this.last != null && this.last.hasResource()) {
                GapicBidiUnbufferedWritableByteChannel.this.resultFuture.set((Object)this.last);
            }
            this.sem.release();
        }

        void await() {
            try {
                this.sem.acquire();
            }
            catch (InterruptedException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e);
            }
            RuntimeException err = this.previousError;
            if (err != null) {
                this.previousError = null;
                throw err;
            }
        }
    }
}

