/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.apache.hc.core5.http.impl.io;

import com.clickhouse.client.internal.apache.hc.core5.http.ClassicHttpResponse;
import com.clickhouse.client.internal.apache.hc.core5.http.HttpException;
import com.clickhouse.client.internal.apache.hc.core5.http.HttpResponseFactory;
import com.clickhouse.client.internal.apache.hc.core5.http.config.Http1Config;
import com.clickhouse.client.internal.apache.hc.core5.http.impl.io.AbstractMessageParser;
import com.clickhouse.client.internal.apache.hc.core5.http.impl.io.DefaultClassicHttpResponseFactory;
import com.clickhouse.client.internal.apache.hc.core5.http.message.LineParser;
import com.clickhouse.client.internal.apache.hc.core5.http.message.StatusLine;
import com.clickhouse.client.internal.apache.hc.core5.util.CharArrayBuffer;
import java.io.IOException;

public class DefaultHttpResponseParser
extends AbstractMessageParser<ClassicHttpResponse> {
    private final HttpResponseFactory<ClassicHttpResponse> responseFactory;

    public DefaultHttpResponseParser(LineParser lineParser, HttpResponseFactory<ClassicHttpResponse> responseFactory, Http1Config http1Config) {
        super(lineParser, http1Config);
        this.responseFactory = responseFactory != null ? responseFactory : DefaultClassicHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParser(Http1Config http1Config) {
        this(null, null, http1Config);
    }

    public DefaultHttpResponseParser() {
        this(Http1Config.DEFAULT);
    }

    @Override
    protected ClassicHttpResponse createMessage(CharArrayBuffer buffer) throws IOException, HttpException {
        StatusLine statusline = this.getLineParser().parseStatusLine(buffer);
        ClassicHttpResponse response = this.responseFactory.newHttpResponse(statusline.getStatusCode(), statusline.getReasonPhrase());
        response.setVersion(statusline.getProtocolVersion());
        return response;
    }
}

