/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.projects.project;

import java.util.Objects;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.projects.project.Project;

public class ProjectConfig {
    protected String projectName;
    protected String projectHome;
    protected String configFilename;

    public ProjectConfig() {
    }

    public ProjectConfig(String projectName, String projectHome, String configFilename) {
        this.projectName = projectName;
        this.projectHome = projectHome;
        this.configFilename = configFilename;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectConfig that = (ProjectConfig)o;
        return Objects.equals(this.projectName, that.projectName);
    }

    public int hashCode() {
        return Objects.hash(this.projectName);
    }

    public String getActualProjectConfigFilename(IVariables variables) throws HopException {
        try {
            String actualHomeFolder = variables.resolve(this.getProjectHome());
            FileObject actualHome = HopVfs.getFileObject((String)actualHomeFolder);
            if (!actualHome.exists()) {
                throw new HopException("Project home folder '" + actualHomeFolder + "' does not exist");
            }
            String actualConfigFilename = variables.resolve(this.getConfigFilename());
            String fullFilename = FilenameUtils.concat((String)actualHome.toString(), (String)actualConfigFilename);
            if (fullFilename == null) {
                throw new HopException("Unable to determine full path to the configuration file '" + actualConfigFilename + "' in home folder '" + actualHomeFolder);
            }
            return fullFilename;
        }
        catch (Exception e) {
            throw new HopException("Error calculating actual project config filename", (Throwable)e);
        }
    }

    public Project loadProject(IVariables variables) throws HopException {
        String configFilename = this.getActualProjectConfigFilename(variables);
        if (configFilename == null) {
            String projHome = variables.resolve(this.getProjectHome());
            String confFile = variables.resolve(this.getConfigFilename());
            throw new HopException("Invalid project folder provided: home folder: '" + projHome + "', config file: '" + confFile + "'");
        }
        Project project = new Project(configFilename);
        try {
            if (HopVfs.getFileObject((String)configFilename).exists()) {
                project.readFromFile();
            }
        }
        catch (Exception e) {
            throw new HopException("Error checking config filename '" + configFilename + "' existence while loading project", (Throwable)e);
        }
        return project;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectHome() {
        return this.projectHome;
    }

    public void setProjectHome(String projectHome) {
        this.projectHome = projectHome;
    }

    public String getConfigFilename() {
        return this.configFilename;
    }

    public void setConfigFilename(String configFilename) {
        this.configFilename = configFilename;
    }
}

