/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import com.google.auto.service.AutoService;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reify;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.ReshuffleTrigger;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.util.IdentityWindowFn;
import org.apache.beam.sdk.util.construction.PTransformTranslation;
import org.apache.beam.sdk.util.construction.SdkComponents;
import org.apache.beam.sdk.util.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.primitives.UnsignedInteger;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

public class Redistribute {
    public static <T> @UnknownKeyFor @NonNull @Initialized RedistributeArbitrarily<T> arbitrarily() {
        return new RedistributeArbitrarily(null, false);
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized RedistributeByKey<K, V> byKey() {
        return new RedistributeByKey(false);
    }

    @Internal
    @AutoService(value={TransformPayloadTranslatorRegistrar.class})
    public static class Registrar
    implements TransformPayloadTranslatorRegistrar {
        @Override
        public @UnknownKeyFor @NonNull @Initialized Map<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PTransform>, @KeyForBottom @NonNull @Initialized ? extends  @UnknownKeyFor @NonNull @Initialized PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return ImmutableMap.builder().put(RedistributeByKey.class, (Object)new RedistributeByKeyTranslator()).put(RedistributeArbitrarily.class, (Object)new RedistributeArbitrarilyTranslator()).build();
        }
    }

    static class RedistributeArbitrarilyTranslator
    implements PTransformTranslation.TransformPayloadTranslator<RedistributeArbitrarily<?>> {
        RedistributeArbitrarilyTranslator() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getUrn() {
            return "beam:transform:redistribute_arbitrarily:v1";
        }

        @Override
        public  @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec translate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized RedistributeArbitrarily<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> transform, @UnknownKeyFor @NonNull @Initialized SdkComponents components) {
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn(transform.getTransform())).setPayload(RunnerApi.RedistributePayload.newBuilder().setAllowDuplicates(transform.getTransform().getAllowDuplicates()).build().toByteString()).build();
        }
    }

    static class RedistributeByKeyTranslator
    implements PTransformTranslation.TransformPayloadTranslator<RedistributeByKey<?, ?>> {
        RedistributeByKeyTranslator() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getUrn() {
            return "beam:transform:redistribute_by_key:v1";
        }

        @Override
        public  @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec translate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized RedistributeByKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> transform, @UnknownKeyFor @NonNull @Initialized SdkComponents components) {
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn(transform.getTransform())).setPayload(RunnerApi.RedistributePayload.newBuilder().setAllowDuplicates(transform.getTransform().getAllowDuplicates()).build().toByteString()).build();
        }
    }

    static class AssignShardFn<@UnknownKeyFor T>
    extends DoFn<T, KV<Integer, T>> {
        private @UnknownKeyFor @NonNull @Initialized int shard;
        private @Nullable @UnknownKeyFor @Initialized Integer numBuckets;

        public AssignShardFn(@Nullable @UnknownKeyFor @Initialized Integer numBuckets) {
            this.numBuckets = numBuckets;
        }

        @DoFn.Setup
        public void setup() {
            this.shard = ThreadLocalRandom.current().nextInt();
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element T element, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, T>> r) {
            ++this.shard;
            int hashOfShard = 461845907 * Integer.rotateLeft(this.shard * -862048943, 15);
            if (this.numBuckets != null) {
                UnsignedInteger unsignedNumBuckets = UnsignedInteger.fromIntBits((int)this.numBuckets);
                hashOfShard = UnsignedInteger.fromIntBits((int)hashOfShard).mod(unsignedNumBuckets).intValue();
            }
            r.output(KV.of(hashOfShard, element));
        }
    }

    private static class RestoreMetadata<@UnknownKeyFor K, @UnknownKeyFor V>
    extends PTransform<PCollection<KV<K, ValueInSingleWindow<V>>>, PCollection<KV<K, V>>> {
        private RestoreMetadata() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<V>>> input) {
            return (PCollection)input.apply(ParDo.of(new DoFn<KV<K, ValueInSingleWindow<V>>, KV<K, V>>(){

                @Override
                public @UnknownKeyFor @NonNull @Initialized Duration getAllowedTimestampSkew() {
                    return Duration.millis((long)Long.MAX_VALUE);
                }

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<V>> kv, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<K, V>> r) {
                    r.outputWindowedValue(KV.of(kv.getKey(), kv.getValue().getValue()), kv.getValue().getTimestamp(), Collections.singleton(kv.getValue().getWindow()), kv.getValue().getPane());
                }
            }));
        }
    }

    public static class RedistributeArbitrarily<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollection<T>> {
        private @Nullable @UnknownKeyFor @Initialized Integer numBuckets = null;
        private @UnknownKeyFor @NonNull @Initialized boolean allowDuplicates = false;

        private RedistributeArbitrarily(@Nullable @UnknownKeyFor @Initialized Integer numBuckets, @UnknownKeyFor @NonNull @Initialized boolean allowDuplicates) {
            this.numBuckets = numBuckets;
            this.allowDuplicates = allowDuplicates;
        }

        public @UnknownKeyFor @NonNull @Initialized RedistributeArbitrarily<T> withNumBuckets(@Nullable @UnknownKeyFor @Initialized Integer numBuckets) {
            return new RedistributeArbitrarily<T>(numBuckets, this.allowDuplicates);
        }

        public @UnknownKeyFor @NonNull @Initialized RedistributeArbitrarily<T> withAllowDuplicates(@UnknownKeyFor @NonNull @Initialized boolean allowDuplicates) {
            return new RedistributeArbitrarily<T>(this.numBuckets, allowDuplicates);
        }

        public @UnknownKeyFor @NonNull @Initialized boolean getAllowDuplicates() {
            return this.allowDuplicates;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            return (PCollection)((PCollection)((PCollection)input.apply("Pair with random key", ParDo.of(new AssignShardFn(this.numBuckets)))).apply(Redistribute.byKey().withAllowDuplicates(this.allowDuplicates))).apply(Values.create());
        }
    }

    public static class RedistributeByKey<@UnknownKeyFor K, @UnknownKeyFor V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, V>>> {
        private final @UnknownKeyFor @NonNull @Initialized boolean allowDuplicates;

        private RedistributeByKey(@UnknownKeyFor @NonNull @Initialized boolean allowDuplicates) {
            this.allowDuplicates = allowDuplicates;
        }

        public @UnknownKeyFor @NonNull @Initialized RedistributeByKey<K, V> withAllowDuplicates(@UnknownKeyFor @NonNull @Initialized boolean newAllowDuplicates) {
            return new RedistributeByKey<K, V>(newAllowDuplicates);
        }

        public @UnknownKeyFor @NonNull @Initialized boolean getAllowDuplicates() {
            return this.allowDuplicates;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
            WindowingStrategy<?, ?> originalStrategy = input.getWindowingStrategy();
            Window rewindow = Window.into(new IdentityWindowFn(originalStrategy.getWindowFn().windowCoder())).triggering(new ReshuffleTrigger()).discardingFiredPanes().withTimestampCombiner(TimestampCombiner.EARLIEST).withAllowedLateness(Duration.millis((long)BoundedWindow.TIMESTAMP_MAX_VALUE.getMillis()));
            PCollection reified = ((PCollection)input.apply("SetIdentityWindow", rewindow)).apply("ReifyOriginalMetadata", Reify.windowsInValue());
            PCollection grouped = (PCollection)reified.apply(GroupByKey.create());
            return ((PCollection)((PCollection)grouped.apply("ExpandIterable", ParDo.of(new DoFn<KV<K, Iterable<ValueInSingleWindow<V>>>, KV<K, ValueInSingleWindow<V>>>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<V>>> element, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<V>>> r) {
                    Object key = element.getKey();
                    for (ValueInSingleWindow value : element.getValue()) {
                        r.output(KV.of(key, value));
                    }
                }
            }))).apply("RestoreMetadata", new RestoreMetadata())).setWindowingStrategyInternal(originalStrategy);
        }
    }
}

