/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.gui;

import java.util.Objects;
import org.apache.hop.core.gui.Point;
import org.apache.hop.metadata.api.HopMetadataProperty;

public class DPoint {
    @HopMetadataProperty(key="x")
    public double x;
    @HopMetadataProperty(key="y")
    public double y;

    public DPoint() {
        this(0.0, 0.0);
    }

    public DPoint(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public DPoint(DPoint p) {
        this.x = p.x;
        this.y = p.y;
    }

    public DPoint(Point p) {
        this.x = p.x;
        this.y = p.y;
    }

    public void multiply(double factor) {
        this.x *= factor;
        this.y *= factor;
    }

    public Point toPoint() {
        return new Point((int)Math.round(this.x), (int)Math.round(this.y));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DPoint point = (DPoint)o;
        return this.x == point.x && this.y == point.y;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public String toString() {
        return "DPoint(" + this.x + "," + this.y + ")";
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }
}

