/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.propertyoutput;

import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.propertyoutput.PropertyOutputData;
import org.apache.hop.pipeline.transforms.propertyoutput.PropertyOutputMeta;

public class PropertyOutput
extends BaseTransform<PropertyOutputMeta, PropertyOutputData> {
    private static final Class<?> PKG = PropertyOutputMeta.class;
    public static final String CONST_PROPERTY_OUTPUT_LOG_ERROR_FINDING_FIELD = "PropertyOutput.Log.ErrorFindingField";
    public static final String CONST_PROPERTY_OUTPUT_LOG_CAN_NOT_CREATE_PARENT_FOLDER = "PropertyOutput.Log.CanNotCreateParentFolder";

    public PropertyOutput(TransformMeta transformMeta, PropertyOutputMeta meta, PropertyOutputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        block18: {
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                ((PropertyOutputData)this.data).inputRowMeta = this.getInputRowMeta();
                ((PropertyOutputData)this.data).outputRowMeta = ((PropertyOutputData)this.data).inputRowMeta.clone();
                ((PropertyOutputMeta)this.meta).getFields(((PropertyOutputData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                ((PropertyOutputData)this.data).indexOfKeyField = ((PropertyOutputData)this.data).inputRowMeta.indexOfValue(((PropertyOutputMeta)this.meta).getKeyField());
                if (((PropertyOutputData)this.data).indexOfKeyField < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)CONST_PROPERTY_OUTPUT_LOG_ERROR_FINDING_FIELD, (String[])new String[]{((PropertyOutputMeta)this.meta).getKeyField()}));
                    throw new HopException(BaseMessages.getString(PKG, (String)CONST_PROPERTY_OUTPUT_LOG_ERROR_FINDING_FIELD, (String[])new String[]{((PropertyOutputMeta)this.meta).getKeyField()}));
                }
                ((PropertyOutputData)this.data).indexOfValueField = ((PropertyOutputData)this.data).inputRowMeta.indexOfValue(((PropertyOutputMeta)this.meta).getValueField());
                if (((PropertyOutputData)this.data).indexOfValueField < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)CONST_PROPERTY_OUTPUT_LOG_ERROR_FINDING_FIELD, (String[])new String[]{((PropertyOutputMeta)this.meta).getValueField()}));
                    throw new HopException(BaseMessages.getString(PKG, (String)CONST_PROPERTY_OUTPUT_LOG_ERROR_FINDING_FIELD, (String[])new String[]{((PropertyOutputMeta)this.meta).getValueField()}));
                }
                if (((PropertyOutputMeta)this.meta).isFileNameInField()) {
                    String realFieldName = this.resolve(((PropertyOutputMeta)this.meta).getFileNameField());
                    if (Utils.isEmpty((CharSequence)realFieldName)) {
                        this.logError(BaseMessages.getString(PKG, (String)"PropertyOutput.Log.FilenameInFieldEmpty", (String[])new String[0]));
                        throw new HopException(BaseMessages.getString(PKG, (String)"PropertyOutput.Log.FilenameInFieldEmpty", (String[])new String[0]));
                    }
                    ((PropertyOutputData)this.data).indexOfFieldfilename = ((PropertyOutputData)this.data).inputRowMeta.indexOfValue(realFieldName);
                    if (((PropertyOutputData)this.data).indexOfFieldfilename < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)CONST_PROPERTY_OUTPUT_LOG_ERROR_FINDING_FIELD, (String[])new String[]{((PropertyOutputMeta)this.meta).getValueField()}));
                        throw new HopException(BaseMessages.getString(PKG, (String)CONST_PROPERTY_OUTPUT_LOG_ERROR_FINDING_FIELD, (String[])new String[]{((PropertyOutputMeta)this.meta).getValueField()}));
                    }
                } else {
                    ((PropertyOutputData)this.data).filename = this.buildFilename();
                    if (Utils.isEmpty((CharSequence)((PropertyOutputData)this.data).filename)) {
                        this.logError(BaseMessages.getString(PKG, (String)"PropertyOutput.Log.FilenameEmpty", (String[])new String[0]));
                        throw new HopException(BaseMessages.getString(PKG, (String)"PropertyOutput.Log.FilenameEmpty", (String[])new String[0]));
                    }
                    this.openNewFile();
                }
            }
            String propkey = ((PropertyOutputData)this.data).inputRowMeta.getString(r, ((PropertyOutputData)this.data).indexOfKeyField);
            String propvalue = ((PropertyOutputData)this.data).inputRowMeta.getString(r, ((PropertyOutputData)this.data).indexOfValueField);
            try {
                if (((PropertyOutputMeta)this.meta).isFileNameInField()) {
                    ((PropertyOutputData)this.data).filename = ((PropertyOutputData)this.data).inputRowMeta.getString(r, ((PropertyOutputData)this.data).indexOfFieldfilename);
                    if (Utils.isEmpty((CharSequence)((PropertyOutputData)this.data).filename)) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"PropertyOutputMeta.Log.FileNameEmty", (String[])new String[0]));
                    }
                    if (!this.checkSameFile()) {
                        this.closeFile();
                        this.openNewFile();
                    }
                }
                if (!((PropertyOutputData)this.data).KeySet.contains(propkey)) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"PropertyOutput.Log.Key", (String[])new String[]{propkey}));
                        this.logDetailed(BaseMessages.getString(PKG, (String)"PropertyOutput.Log.Value", (String[])new String[]{propvalue}));
                    }
                    ((PropertyOutputData)this.data).pro.setProperty(propkey, propvalue);
                    this.putRow(((PropertyOutputData)this.data).outputRowMeta, r);
                    this.incrementLinesOutput();
                    if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                        this.logBasic("linenr " + this.getLinesRead());
                    }
                    ((PropertyOutputData)this.data).KeySet.add(propkey);
                }
            }
            catch (HopTransformException e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"PropertyOutputMeta.Log.ErrorInTransform", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block18;
                this.putError(((PropertyOutputData)this.data).outputRowMeta, r, 1L, errorMessage, null, "PROPSOUTPUTO001");
            }
        }
        return true;
    }

    public boolean checkSameFile() {
        return ((PropertyOutputData)this.data).previousFileName.equals(((PropertyOutputData)this.data).filename);
    }

    private void openNewFile() throws HopException {
        try (FileObject newFile = HopVfs.getFileObject((String)((PropertyOutputData)this.data).filename, (IVariables)this.variables);){
            ((PropertyOutputData)this.data).pro = new Properties();
            ((PropertyOutputData)this.data).KeySet.clear();
            ((PropertyOutputData)this.data).file = newFile;
            if (((PropertyOutputMeta)this.meta).isAppend() && ((PropertyOutputData)this.data).file.exists()) {
                ((PropertyOutputData)this.data).pro.load(HopVfs.getInputStream((FileObject)((PropertyOutputData)this.data).file));
            }
            this.createParentFolder();
            ((PropertyOutputData)this.data).previousFileName = ((PropertyOutputData)this.data).filename;
        }
        catch (Exception e) {
            throw new HopException("Error opening file [" + ((PropertyOutputData)this.data).filename + "]!", (Throwable)e);
        }
    }

    private void createParentFolder() throws HopException {
        if (((PropertyOutputMeta)this.meta).isCreateParentFolder()) {
            FileObject parentfolder = null;
            try {
                parentfolder = ((PropertyOutputData)this.data).file.getParent();
                if (!parentfolder.exists()) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"PropertyOutput.Log.ParentFolderExists", (String[])new String[]{parentfolder.getName().toString()}));
                    }
                    parentfolder.createFolder();
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)CONST_PROPERTY_OUTPUT_LOG_CAN_NOT_CREATE_PARENT_FOLDER, (String[])new String[]{parentfolder.getName().toString()}));
                    }
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)CONST_PROPERTY_OUTPUT_LOG_CAN_NOT_CREATE_PARENT_FOLDER, (String[])new String[]{parentfolder.getName().toString()}));
                throw new HopException(BaseMessages.getString(PKG, (String)CONST_PROPERTY_OUTPUT_LOG_CAN_NOT_CREATE_PARENT_FOLDER, (String[])new String[]{parentfolder.getName().toString()}));
            }
            finally {
                if (parentfolder != null) {
                    try {
                        parentfolder.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean closeFile() {
        boolean retval;
        block25: {
            block23: {
                if (((PropertyOutputData)this.data).file == null) {
                    return true;
                }
                retval = false;
                try (OutputStream propsFile = HopVfs.getOutputStream((FileObject)((PropertyOutputData)this.data).file, (boolean)false);){
                    ((PropertyOutputData)this.data).pro.store(propsFile, this.resolve(((PropertyOutputMeta)this.meta).getComment()));
                    if (((PropertyOutputMeta)this.meta).isAddToResult()) {
                        ResultFile resultFile = new ResultFile(0, ((PropertyOutputData)this.data).file, this.getPipelineMeta().getName(), this.getTransformName());
                        resultFile.setComment(BaseMessages.getString(PKG, (String)"PropertyOutput.Log.FileAddedResult", (String[])new String[0]));
                        this.addResultFile(resultFile);
                    }
                    ((PropertyOutputData)this.data).KeySet.clear();
                    retval = true;
                }
                if (((PropertyOutputData)this.data).file == null) break block23;
                try {
                    ((PropertyOutputData)this.data).file.close();
                    ((PropertyOutputData)this.data).file = null;
                }
                catch (Exception e) {
                    this.logDetailed("Exception trying to close file [" + ((PropertyOutputData)this.data).file.getName() + "]! :", new Object[]{e});
                }
            }
            if (((PropertyOutputData)this.data).pro != null) {
                ((PropertyOutputData)this.data).pro = null;
            }
            break block25;
            catch (Exception e) {
                block24: {
                    try {
                        this.logError("Exception trying to close file [" + ((PropertyOutputData)this.data).file.getName() + "]! :" + e.toString());
                        this.setErrors(1L);
                        if (((PropertyOutputData)this.data).file == null) break block24;
                    }
                    catch (Throwable throwable) {
                        if (((PropertyOutputData)this.data).file != null) {
                            try {
                                ((PropertyOutputData)this.data).file.close();
                                ((PropertyOutputData)this.data).file = null;
                            }
                            catch (Exception e2) {
                                this.logDetailed("Exception trying to close file [" + ((PropertyOutputData)this.data).file.getName() + "]! :", new Object[]{e2});
                            }
                        }
                        if (((PropertyOutputData)this.data).pro != null) {
                            ((PropertyOutputData)this.data).pro = null;
                        }
                        throw throwable;
                    }
                    try {
                        ((PropertyOutputData)this.data).file.close();
                        ((PropertyOutputData)this.data).file = null;
                    }
                    catch (Exception e3) {
                        this.logDetailed("Exception trying to close file [" + ((PropertyOutputData)this.data).file.getName() + "]! :", new Object[]{e3});
                    }
                }
                if (((PropertyOutputData)this.data).pro != null) {
                    ((PropertyOutputData)this.data).pro = null;
                }
            }
        }
        return retval;
    }

    public String buildFilename() {
        return ((PropertyOutputMeta)this.meta).buildFilename((IVariables)this, this.getCopy());
    }

    public boolean init() {
        return super.init();
    }

    public void dispose() {
        this.closeFile();
        this.setOutputDone();
        super.dispose();
    }
}

