/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.vertica.bulkloader;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.vertica.bulkloader.VerticaBulkLoader;
import org.apache.hop.pipeline.transforms.vertica.bulkloader.VerticaBulkLoaderData;
import org.apache.hop.pipeline.transforms.vertica.bulkloader.VerticaBulkLoaderField;

@Transform(id="VerticaBulkLoader", image="vertica.svg", name="i18n::BaseTransform.TypeLongDesc.VerticaBulkLoaderMessage", description="i18n::BaseTransform.TypeTooltipDesc.VerticaBulkLoaderMessage", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Bulk", documentationUrl="pipeline/transforms/verticabulkloader.html", isIncludeJdbcDrivers=true, classLoaderGroup="vertica5")
public class VerticaBulkLoaderMeta
extends BaseTransformMeta<VerticaBulkLoader, VerticaBulkLoaderData> {
    private static final Class<?> PKG = VerticaBulkLoaderMeta.class;
    @HopMetadataProperty(key="connection", injectionKey="CONNECTIONNAME", injectionKeyDescription="VerticaBulkLoader.Injection.CONNECTIONNAME")
    private String connection;
    @HopMetadataProperty(key="schema", injectionKey="SCHEMANAME", injectionKeyDescription="VerticaBulkLoader.Injection.SCHEMANAME")
    private String schemaName;
    @HopMetadataProperty(key="table", injectionKey="TABLENAME", injectionKeyDescription="VerticaBulkLoader.Injection.TABLENAME")
    private String tablename;
    @HopMetadataProperty(key="truncate", injectionKey="TRUNCATE_TABLE", injectionKeyDescription="VerticaBulkLoader.Injection.TruncateTable.Field")
    private boolean truncateTable;
    @HopMetadataProperty(key="only_when_have_rows", injectionKey="ONLY_WHEN_HAVE_ROWS", injectionKeyDescription="VerticaBulkLoader.Inject.OnlyWhenHaveRows.Field")
    private boolean onlyWhenHaveRows;
    @HopMetadataProperty(key="direct", injectionKey="DIRECT", injectionKeyDescription="VerticaBulkLoader.Injection.DIRECT")
    private boolean direct = true;
    @HopMetadataProperty(key="abort_on_error", injectionKey="ABORTONERROR", injectionKeyDescription="VerticaBulkLoader.Injection.ABORTONERROR")
    private boolean abortOnError = true;
    @HopMetadataProperty(key="exceptions_filename", injectionKey="EXCEPTIONSFILENAME", injectionKeyDescription="VerticaBulkLoader.Injection.EXCEPTIONSFILENAME")
    private String exceptionsFileName;
    @HopMetadataProperty(key="rejected_data_filename", injectionKey="REJECTEDDATAFILENAME", injectionKeyDescription="VerticaBulkLoader.Injection.REJECTEDDATAFILENAME")
    private String rejectedDataFileName;
    @HopMetadataProperty(key="stream_name", injectionKey="STREAMNAME", injectionKeyDescription="VerticaBulkLoader.Injection.STREAMNAME")
    private String streamName;
    @HopMetadataProperty(key="specify_fields", injectionKeyDescription="")
    private boolean specifyFields;
    @HopMetadataProperty(groupKey="fields", key="field", injectionGroupKey="FIELDS", injectionGroupDescription="VerticaBulkLoader.Injection.FIELDS", injectionKey="FIELDSTREAM", injectionKeyDescription="VerticaBulkLoader.Injection.FIELDSTREAM")
    private List<VerticaBulkLoaderField> fields = new ArrayList<VerticaBulkLoaderField>();
    @HopMetadataProperty(groupKey="fields", key="field", injectionGroupKey="FIELDS", injectionGroupDescription="VerticaBulkLoader.Injection.FIELDS", injectionKey="FIELDDATABASE", injectionKeyDescription="VerticaBulkLoader.Injection.FIELDDATABASE")
    private String[] fieldDatabase;

    public List<VerticaBulkLoaderField> getFields() {
        return this.fields;
    }

    public void setFields(List<VerticaBulkLoaderField> fields) {
        this.fields = fields;
    }

    public Object clone() {
        return super.clone();
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public DatabaseMeta getDatabaseMeta() {
        return null;
    }

    @Deprecated(since="2.10")
    public String getTablename() {
        return this.getTableName();
    }

    public String getTableName() {
        return this.tablename;
    }

    @Deprecated(since="2.10")
    public void setTablename(String name) {
        this.setTableName(name);
    }

    public void setTableName(String name) {
        this.tablename = name;
    }

    public boolean isTruncateTable() {
        return this.truncateTable;
    }

    public void setTruncateTable(boolean truncateTable) {
        this.truncateTable = truncateTable;
    }

    public boolean isOnlyWhenHaveRows() {
        return this.onlyWhenHaveRows;
    }

    public void setOnlyWhenHaveRows(boolean onlyWhenHaveRows) {
        this.onlyWhenHaveRows = onlyWhenHaveRows;
    }

    public void setSpecifyFields(boolean specifyFields) {
        this.specifyFields = specifyFields;
    }

    public boolean specifyFields() {
        return this.specifyFields;
    }

    public boolean isDirect() {
        return this.direct;
    }

    public void setDirect(boolean direct) {
        this.direct = direct;
    }

    public boolean isAbortOnError() {
        return this.abortOnError;
    }

    public void setAbortOnError(boolean abortOnError) {
        this.abortOnError = abortOnError;
    }

    public String getExceptionsFileName() {
        return this.exceptionsFileName;
    }

    public void setExceptionsFileName(String exceptionsFileName) {
        this.exceptionsFileName = exceptionsFileName;
    }

    public String getRejectedDataFileName() {
        return this.rejectedDataFileName;
    }

    public void setRejectedDataFileName(String rejectedDataFileName) {
        this.rejectedDataFileName = rejectedDataFileName;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public boolean isSpecifyFields() {
        return this.specifyFields;
    }

    public void setDefault() {
        this.tablename = "";
        this.specifyFields = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        block34: {
            Database db = null;
            try {
                DatabaseMeta databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
                if (databaseMeta != null) {
                    CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.ConnectionExists", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                    db = new Database(loggingObject, variables, databaseMeta);
                    try {
                        db.connect();
                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.ConnectionOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                        if (!StringUtil.isEmpty((String)this.tablename)) {
                            String realTableName;
                            String schemaTable = databaseMeta.getQuotedSchemaTableCombination(variables, db.resolve(this.schemaName), db.resolve(this.tablename));
                            String realSchemaName = db.resolve(this.schemaName);
                            if (db.checkTableExists(realSchemaName, realTableName = db.resolve(this.tablename))) {
                                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.TableAccessible", (String[])new String[]{schemaTable}), (ICheckResultSource)transformMeta);
                                remarks.add((ICheckResult)cr);
                                IRowMeta r = db.getTableFields(schemaTable);
                                if (r != null) {
                                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.TableOk", (String[])new String[]{schemaTable}), (ICheckResultSource)transformMeta);
                                    remarks.add((ICheckResult)cr);
                                    Object error_message = "";
                                    boolean error_found = false;
                                    if (prev != null && prev.size() > 0) {
                                        int idx;
                                        int i;
                                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
                                        remarks.add((ICheckResult)cr);
                                        if (!this.specifyFields()) {
                                            for (i = 0; i < prev.size(); ++i) {
                                                IValueMeta pv = prev.getValueMeta(i);
                                                idx = r.indexOfValue(pv.getName());
                                                if (idx >= 0) continue;
                                                error_message = (String)error_message + "\t\t" + pv.getName() + " (" + pv.getTypeDesc() + ")" + Const.CR;
                                                error_found = true;
                                            }
                                            if (error_found) {
                                                error_message = BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.FieldsNotFoundInOutput", (String[])new String[]{error_message});
                                                cr = new CheckResult(4, (String)error_message, (ICheckResultSource)transformMeta);
                                                remarks.add((ICheckResult)cr);
                                            } else {
                                                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.AllFieldsFoundInOutput", (String[])new String[0]), (ICheckResultSource)transformMeta);
                                                remarks.add((ICheckResult)cr);
                                            }
                                        } else {
                                            for (i = 0; i < this.getFieldDatabase().length; ++i) {
                                                int idx2 = r.indexOfValue(this.getFieldDatabase()[i]);
                                                if (idx2 >= 0) continue;
                                                error_message = (String)error_message + "\t\t" + this.getFieldDatabase()[i] + Const.CR;
                                                error_found = true;
                                            }
                                            if (error_found) {
                                                error_message = BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.FieldsSpecifiedNotInTable", (String[])new String[]{error_message});
                                                cr = new CheckResult(4, (String)error_message, (ICheckResultSource)transformMeta);
                                                remarks.add((ICheckResult)cr);
                                            } else {
                                                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.AllFieldsFoundInOutput", (String[])new String[0]), (ICheckResultSource)transformMeta);
                                                remarks.add((ICheckResult)cr);
                                            }
                                        }
                                        error_message = "";
                                        if (!this.specifyFields()) {
                                            for (i = 0; i < this.getFieldDatabase().length; ++i) {
                                                IValueMeta rv = r.getValueMeta(i);
                                                idx = prev.indexOfValue(rv.getName());
                                                if (idx >= 0) continue;
                                                error_message = (String)error_message + "\t\t" + rv.getName() + " (" + rv.getTypeDesc() + ")" + Const.CR;
                                                error_found = true;
                                            }
                                            if (error_found) {
                                                error_message = BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.FieldsNotFound", (String[])new String[]{error_message});
                                                cr = new CheckResult(3, (String)error_message, (ICheckResultSource)transformMeta);
                                                remarks.add((ICheckResult)cr);
                                            } else {
                                                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                                                remarks.add((ICheckResult)cr);
                                            }
                                        } else {
                                            for (i = 0; i < this.fields.size(); ++i) {
                                                VerticaBulkLoaderField vbf = this.fields.get(i);
                                                idx = prev.indexOfValue(vbf.getFieldStream());
                                                if (idx >= 0) continue;
                                                error_message = (String)error_message + "\t\t" + vbf.getFieldStream() + Const.CR;
                                                error_found = true;
                                            }
                                            if (error_found) {
                                                error_message = BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.FieldsSpecifiedNotFound", (String[])new String[]{error_message});
                                                cr = new CheckResult(4, (String)error_message, (ICheckResultSource)transformMeta);
                                                remarks.add((ICheckResult)cr);
                                            } else {
                                                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                                                remarks.add((ICheckResult)cr);
                                            }
                                        }
                                    } else {
                                        cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.NoFields", (String[])new String[0]), (ICheckResultSource)transformMeta);
                                        remarks.add((ICheckResult)cr);
                                    }
                                } else {
                                    cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.TableNotAccessible", (String[])new String[0]), (ICheckResultSource)transformMeta);
                                    remarks.add((ICheckResult)cr);
                                }
                            } else {
                                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.TableError", (String[])new String[]{schemaTable}), (ICheckResultSource)transformMeta);
                                remarks.add((ICheckResult)cr);
                            }
                        } else {
                            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.NoTableName", (String[])new String[0]), (ICheckResultSource)transformMeta);
                            remarks.add((ICheckResult)cr);
                        }
                        break block34;
                    }
                    catch (HopException e) {
                        cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.UndefinedError", (String[])new String[]{e.getMessage()}), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                        break block34;
                    }
                    finally {
                        db.disconnect();
                    }
                }
                CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.NoConnection", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            catch (HopException e) {
                CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.UndefinedError", (String[])new String[]{e.getMessage()}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public void analyseImpact(IVariables variables, List<DatabaseImpact> impact, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IHopMetadataProvider metadataProvider) throws HopTransformException {
        try {
            DatabaseMeta databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
            if (prev != null) {
                for (int i = 0; i < prev.size(); ++i) {
                    IValueMeta v = prev.getValueMeta(i);
                    DatabaseImpact ii = new DatabaseImpact(2, pipelineMeta.getName(), transformMeta.getName(), databaseMeta.getDatabaseName(), this.tablename, v.getName(), v.getName(), v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                    impact.add(ii);
                }
            }
        }
        catch (HopException e) {
            throw new HopTransformException("Unable to get databaseMeta for connection: " + Const.CR + variables.resolve(this.connection));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlStatement getSqlStatements(IVariables variables, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, IHopMetadataProvider metadataProvider) {
        DatabaseMeta databaseMeta = pipelineMeta.findDatabase(this.connection, variables);
        SqlStatement retval = new SqlStatement(transformMeta.getName(), databaseMeta, null);
        if (databaseMeta != null) {
            if (prev != null && prev.size() > 0) {
                if (!StringUtil.isEmpty((String)this.tablename)) {
                    Database db = new Database(loggingObject, variables, databaseMeta);
                    try {
                        db.connect();
                        String schemaTable = databaseMeta.getQuotedSchemaTableCombination(variables, this.schemaName, this.tablename);
                        String cr_table = db.getDDL(schemaTable, prev);
                        if (cr_table == null || cr_table.length() == 0) {
                            cr_table = null;
                        }
                        retval.setSql(cr_table);
                    }
                    catch (HopDatabaseException dbe) {
                        retval.setError(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.Error.ErrorConnecting", (String[])new String[]{dbe.getMessage()}));
                    }
                    finally {
                        db.disconnect();
                    }
                } else {
                    retval.setError(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.Error.NoTable", (String[])new String[0]));
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.Error.NoInput", (String[])new String[0]));
            }
        } else {
            retval.setError(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.Error.NoConnection", (String[])new String[0]));
        }
        return retval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IRowMeta getRequiredFields(IVariables variables) throws HopException {
        String realTableName = variables.resolve(this.tablename);
        String realSchemaName = variables.resolve(this.schemaName);
        DatabaseMeta databaseMeta = this.getParentTransformMeta().getParentPipelineMeta().findDatabase(this.connection, variables);
        if (databaseMeta == null) throw new HopException(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.Exception.ConnectionNotDefined", (String[])new String[0]));
        Database db = new Database(loggingObject, variables, databaseMeta);
        try {
            db.connect();
            if (StringUtil.isEmpty((String)realTableName)) throw new HopException(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.Exception.TableNotSpecified", (String[])new String[0]));
            String schemaTable = databaseMeta.getQuotedSchemaTableCombination(variables, realSchemaName, realTableName);
            if (db.checkTableExists(realSchemaName, realTableName)) {
                IRowMeta iRowMeta = db.getTableFields(schemaTable);
                return iRowMeta;
            }
            try {
                throw new HopException(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.Exception.TableNotFound", (String[])new String[0]));
            }
            catch (Exception e) {
                throw new HopException(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderMeta.Exception.ErrorGettingFields", (String[])new String[0]), (Throwable)e);
            }
        }
        finally {
            db.disconnect();
        }
    }

    public String[] getFieldDatabase() {
        return this.fieldDatabase;
    }

    public void setFieldDatabase(String[] fieldDatabase) {
        this.fieldDatabase = fieldDatabase;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

