/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.construction.graph;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.util.construction.Environments;
import org.apache.beam.sdk.util.construction.NativeTransforms;
import org.apache.beam.sdk.util.construction.PTransformTranslation;
import org.apache.beam.sdk.util.construction.graph.Networks;
import org.apache.beam.sdk.util.construction.graph.PipelineNode;
import org.apache.beam.sdk.util.construction.graph.SideInputReference;
import org.apache.beam.sdk.util.construction.graph.TimerReference;
import org.apache.beam.sdk.util.construction.graph.UserStateReference;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ProtocolStringList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.graph.MutableNetwork;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.graph.Network;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.graph.NetworkBuilder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class QueryablePipeline {
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components;
    private final @UnknownKeyFor @NonNull @Initialized Network<@UnknownKeyFor @NonNull @Initialized PipelineNode, @UnknownKeyFor @NonNull @Initialized PipelineEdge> pipelineNetwork;
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> PRIMITIVE_URNS = ImmutableSet.of("beam:transform:pardo:v1", "beam:transform:flatten:v1", "beam:transform:group_by_key:v1", "beam:transform:impulse:v1", "beam:transform:window_into:v1", "beam:transform:teststream:v1", new String[]{"beam:transform:map_windows:v1", "beam:transform:read:v1", "beam:transform:create_view:v1", "beam:transform:combine_per_key_precombine:v1", "beam:transform:combine_per_key_merge_accumulators:v1", "beam:transform:combine_per_key_extract_outputs:v1", "beam:transform:sdf_pair_with_restriction:v1", "beam:transform:sdf_process_keyed_elements:v1", "beam:transform:sdf_process_elements:v1", "beam:transform:sdf_split_and_size_restrictions:v1", "beam:transform:sdf_process_sized_element_and_restrictions:v1"});

    public static @UnknownKeyFor @NonNull @Initialized QueryablePipeline forPrimitivesIn(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components) {
        return new QueryablePipeline(QueryablePipeline.getPrimitiveTransformIds(components), components);
    }

    public static @UnknownKeyFor @NonNull @Initialized QueryablePipeline forPipeline(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline p) {
        return QueryablePipeline.forTransforms((Collection<String>)p.getRootTransformIdsList(), p.getComponents());
    }

    public static @UnknownKeyFor @NonNull @Initialized QueryablePipeline forTransforms(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> transformIds, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components) {
        return new QueryablePipeline(transformIds, components);
    }

    private QueryablePipeline(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> transformIds, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components) {
        this.components = components;
        this.pipelineNetwork = this.buildNetwork(transformIds, this.components);
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> getPrimitiveTransformIds(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components) {
        LinkedHashSet<String> ids = new LinkedHashSet<String>();
        for (Map.Entry transformEntry : components.getTransformsMap().entrySet()) {
            RunnerApi.PTransform transform = (RunnerApi.PTransform)transformEntry.getValue();
            boolean isPrimitive = QueryablePipeline.isPrimitiveTransform(transform);
            if (!isPrimitive) continue;
            ArrayDeque<String> transforms = new ArrayDeque<String>();
            transforms.push((String)transformEntry.getKey());
            while (!transforms.isEmpty()) {
                String id = (String)transforms.pop();
                RunnerApi.PTransform next = (RunnerApi.PTransform)components.getTransformsMap().get(id);
                ProtocolStringList subtransforms = next.getSubtransformsList();
                if (subtransforms.isEmpty()) {
                    ids.add(id);
                    continue;
                }
                transforms.addAll((Collection<String>)subtransforms);
            }
        }
        return ids;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isPrimitiveTransform(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform transform) {
        String urn = PTransformTranslation.urnForTransformOrNull(transform);
        return PRIMITIVE_URNS.contains(urn) || NativeTransforms.isNative(transform);
    }

    private @UnknownKeyFor @NonNull @Initialized MutableNetwork<@UnknownKeyFor @NonNull @Initialized PipelineNode, @UnknownKeyFor @NonNull @Initialized PipelineEdge> buildNetwork(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> transformIds, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components) {
        MutableNetwork<PipelineNode, PipelineEdge> network = NetworkBuilder.directed().allowsParallelEdges(true).allowsSelfLoops(false).build();
        HashSet<PipelineNode.PCollectionNode> unproducedCollections = new HashSet<PipelineNode.PCollectionNode>();
        for (String transformId : transformIds) {
            RunnerApi.PTransform transform = components.getTransformsOrThrow(transformId);
            PipelineNode.PTransformNode transformNode = PipelineNode.pTransform(transformId, this.components.getTransformsOrThrow(transformId));
            network.addNode(transformNode);
            for (String string : transform.getOutputsMap().values()) {
                PipelineNode.PCollectionNode producedNode = PipelineNode.pCollection(string, components.getPcollectionsOrThrow(string));
                network.addNode(producedNode);
                network.addEdge(transformNode, producedNode, new PerElementEdge());
                Preconditions.checkArgument(network.inDegree(producedNode) == 1, "A %s should have exactly one producing %s, but found %s:\nPCollection:\n%s\nProducers:\n%s", PipelineNode.PCollectionNode.class.getSimpleName(), PipelineNode.PTransformNode.class.getSimpleName(), network.predecessors((Object)producedNode).size(), producedNode, network.predecessors((Object)producedNode));
                unproducedCollections.remove(producedNode);
            }
            for (Map.Entry entry : transform.getInputsMap().entrySet()) {
                String pcollectionId = (String)entry.getValue();
                PipelineNode.PCollectionNode consumedNode = PipelineNode.pCollection(pcollectionId, this.components.getPcollectionsOrThrow(pcollectionId));
                if (network.addNode(consumedNode)) {
                    unproducedCollections.add(consumedNode);
                }
                if (this.getLocalSideInputNames(transform).contains(entry.getKey())) {
                    network.addEdge(consumedNode, transformNode, new SingletonEdge());
                    continue;
                }
                network.addEdge(consumedNode, transformNode, new PerElementEdge());
            }
        }
        Preconditions.checkArgument(unproducedCollections.isEmpty(), "%ss %s were consumed but never produced", (Object)PipelineNode.PCollectionNode.class.getSimpleName(), unproducedCollections);
        return network;
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode> getTransforms() {
        return this.pipelineNetwork.nodes().stream().filter(PipelineNode.PTransformNode.class::isInstance).map(PipelineNode.PTransformNode.class::cast).collect(Collectors.toList());
    }

    public @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode> getTopologicallyOrderedTransforms() {
        return StreamSupport.stream(Networks.topologicalOrder(this.pipelineNetwork, Comparator.comparing(PipelineNode::getId)).spliterator(), false).filter(PipelineNode.PTransformNode.class::isInstance).map(PipelineNode.PTransformNode.class::cast).collect(Collectors.toList());
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode> getRootTransforms() {
        return this.pipelineNetwork.nodes().stream().filter(pipelineNode -> this.pipelineNetwork.inEdges((PipelineNode)pipelineNode).isEmpty()).map(pipelineNode -> (PipelineNode.PTransformNode)pipelineNode).collect(Collectors.toSet());
    }

    public @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode getProducer(@UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode pcollection) {
        return (PipelineNode.PTransformNode)Iterables.getOnlyElement(this.pipelineNetwork.predecessors((Object)pcollection));
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode> getPerElementConsumers(@UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode pCollection) {
        return this.pipelineNetwork.successors((Object)pCollection).stream().filter(consumer -> this.pipelineNetwork.edgesConnecting(pCollection, (PipelineNode)consumer).stream().anyMatch(PipelineEdge::isPerElement)).map(pipelineNode -> (PipelineNode.PTransformNode)pipelineNode).collect(Collectors.toSet());
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode> getSingletonConsumers(@UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode pCollection) {
        return this.pipelineNetwork.successors((Object)pCollection).stream().filter(consumer -> this.pipelineNetwork.edgesConnecting(pCollection, (PipelineNode)consumer).stream().anyMatch(edge -> !edge.isPerElement())).map(pipelineNode -> (PipelineNode.PTransformNode)pipelineNode).collect(Collectors.toSet());
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode> getPerElementInputPCollections(@UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode ptransform) {
        return this.pipelineNetwork.inEdges(ptransform).stream().filter(PipelineEdge::isPerElement).map(edge -> (PipelineNode.PCollectionNode)this.pipelineNetwork.incidentNodes((PipelineEdge)edge).source()).collect(Collectors.toSet());
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode> getOutputPCollections(@UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode ptransform) {
        return this.pipelineNetwork.successors((Object)ptransform).stream().map(pipelineNode -> (PipelineNode.PCollectionNode)pipelineNode).collect(Collectors.toSet());
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components getComponents() {
        return this.components;
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized SideInputReference> getSideInputs(@UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transform) {
        return this.getLocalSideInputNames(transform.getTransform()).stream().map(localName -> {
            String transformId = transform.getId();
            RunnerApi.PTransform transformProto = this.components.getTransformsOrThrow(transformId);
            String collectionId = transform.getTransform().getInputsOrThrow(localName);
            RunnerApi.PCollection collection = this.components.getPcollectionsOrThrow(collectionId);
            return SideInputReference.of(PipelineNode.pTransform(transformId, transformProto), localName, PipelineNode.pCollection(collectionId, collection));
        }).collect(Collectors.toSet());
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized UserStateReference> getUserStates(@UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transform) {
        return this.getLocalUserStateNames(transform.getTransform()).stream().map(localName -> {
            String transformId = transform.getId();
            RunnerApi.PTransform transformProto = this.components.getTransformsOrThrow(transformId);
            String collectionId = transform.getTransform().getInputsOrThrow((String)Iterables.getOnlyElement(Sets.difference(transform.getTransform().getInputsMap().keySet(), ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(this.getLocalSideInputNames(transformProto))).addAll(this.getLocalTimerNames(transformProto))).build())));
            RunnerApi.PCollection collection = this.components.getPcollectionsOrThrow(collectionId);
            return UserStateReference.of(PipelineNode.pTransform(transformId, transformProto), localName, PipelineNode.pCollection(collectionId, collection));
        }).collect(Collectors.toSet());
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized TimerReference> getTimers(@UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transform) {
        return this.getLocalTimerNames(transform.getTransform()).stream().map(localName -> {
            String transformId = transform.getId();
            RunnerApi.PTransform transformProto = this.components.getTransformsOrThrow(transformId);
            return TimerReference.of(PipelineNode.pTransform(transformId, transformProto), localName);
        }).collect(Collectors.toSet());
    }

    private @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getLocalSideInputNames(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform transform) {
        if ("beam:transform:pardo:v1".equals(transform.getSpec().getUrn()) || "beam:transform:sdf_pair_with_restriction:v1".equals(transform.getSpec().getUrn()) || "beam:transform:sdf_split_and_size_restrictions:v1".equals(transform.getSpec().getUrn()) || "beam:transform:sdf_process_sized_element_and_restrictions:v1".equals(transform.getSpec().getUrn())) {
            try {
                return RunnerApi.ParDoPayload.parseFrom((ByteString)transform.getSpec().getPayload()).getSideInputsMap().keySet();
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        }
        return Collections.emptySet();
    }

    private @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getLocalUserStateNames(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform transform) {
        if ("beam:transform:pardo:v1".equals(transform.getSpec().getUrn())) {
            try {
                return RunnerApi.ParDoPayload.parseFrom((ByteString)transform.getSpec().getPayload()).getStateSpecsMap().keySet();
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        }
        return Collections.emptySet();
    }

    private @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getLocalTimerNames(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform transform) {
        if ("beam:transform:pardo:v1".equals(transform.getSpec().getUrn())) {
            try {
                return RunnerApi.ParDoPayload.parseFrom((ByteString)transform.getSpec().getPayload()).getTimerFamilySpecsMap().keySet();
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        }
        return Collections.emptySet();
    }

    public @UnknownKeyFor @NonNull @Initialized Optional<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment> getEnvironment(@UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode parDo) {
        return Environments.getEnvironment(parDo.getId(), this.components);
    }

    private static class SingletonEdge
    implements PipelineEdge {
        private SingletonEdge() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isPerElement() {
            return false;
        }
    }

    private static class PerElementEdge
    implements PipelineEdge {
        private PerElementEdge() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isPerElement() {
            return true;
        }
    }

    private static interface PipelineEdge {
        public @UnknownKeyFor @NonNull @Initialized boolean isPerElement();
    }
}

