/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;

public class WithTimestamps<@UnknownKeyFor T>
extends PTransform<PCollection<T>, PCollection<T>> {
    private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Instant> fn;
    private final @UnknownKeyFor @NonNull @Initialized Duration allowedTimestampSkew;

    public static <T> @UnknownKeyFor @NonNull @Initialized WithTimestamps<T> of(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Instant> fn) {
        return new WithTimestamps<T>(fn, Duration.ZERO);
    }

    private WithTimestamps(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Instant> fn, @UnknownKeyFor @NonNull @Initialized Duration allowedTimestampSkew) {
        this.fn = Preconditions.checkNotNull(fn, "WithTimestamps fn cannot be null");
        this.allowedTimestampSkew = allowedTimestampSkew;
    }

    @Deprecated
    public @UnknownKeyFor @NonNull @Initialized WithTimestamps<T> withAllowedTimestampSkew(@UnknownKeyFor @NonNull @Initialized Duration allowedTimestampSkew) {
        return new WithTimestamps<T>(this.fn, allowedTimestampSkew);
    }

    @Deprecated
    public @UnknownKeyFor @NonNull @Initialized Duration getAllowedTimestampSkew() {
        return this.allowedTimestampSkew;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
        return (PCollection)input.apply("AddTimestamps", ParDo.of(new AddTimestampsDoFn<T>(this.fn, this.allowedTimestampSkew)));
    }

    private static class AddTimestampsDoFn<@UnknownKeyFor T>
    extends DoFn<T, T> {
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Instant> fn;
        private final @UnknownKeyFor @NonNull @Initialized Duration allowedTimestampSkew;

        public AddTimestampsDoFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Instant> fn, @UnknownKeyFor @NonNull @Initialized Duration allowedTimestampSkew) {
            this.fn = fn;
            this.allowedTimestampSkew = allowedTimestampSkew;
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element T element, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<T> r) {
            Instant timestamp = this.fn.apply(element);
            Preconditions.checkNotNull(timestamp, "Timestamps for WithTimestamps cannot be null. Timestamp provided by %s.", this.fn);
            r.outputWithTimestamp(element, timestamp);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Duration getAllowedTimestampSkew() {
            return this.allowedTimestampSkew;
        }
    }
}

