/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.beam.sdk.coders.BigEndianIntegerCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableComparator;
import org.apache.beam.sdk.transforms.Top;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Sample {
    public static <T> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<T, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized Iterable<T>> combineFn(@UnknownKeyFor @NonNull @Initialized int sampleSize) {
        return new FixedSizedSampleFn(sampleSize);
    }

    public static <T> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<T, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized Iterable<T>> anyCombineFn(@UnknownKeyFor @NonNull @Initialized int sampleSize) {
        return new SampleAnyCombineFn(sampleSize);
    }

    public static <T> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<T, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, T> anyValueCombineFn() {
        return new AnyValueCombineFn();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PCollection<T>> any(@UnknownKeyFor @NonNull @Initialized long limit) {
        return new Any(limit);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Iterable<T>>> fixedSizeGlobally(@UnknownKeyFor @NonNull @Initialized int sampleSize) {
        return new FixedSizeGlobally(sampleSize);
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>>> fixedSizePerKey(@UnknownKeyFor @NonNull @Initialized int sampleSize) {
        return new FixedSizePerKey(sampleSize);
    }

    public static class FixedSizedSampleFn<@UnknownKeyFor T>
    extends Combine.CombineFn<T, Top.BoundedHeap<KV<Integer, T>, SerializableComparator<KV<Integer, T>>>, Iterable<T>> {
        private final @UnknownKeyFor @NonNull @Initialized int sampleSize;
        private final @UnknownKeyFor @NonNull @Initialized Top.TopCombineFn<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, T>, @UnknownKeyFor @NonNull @Initialized SerializableComparator<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, T>>> topCombineFn;
        private final @UnknownKeyFor @NonNull @Initialized Random rand = new Random();

        private FixedSizedSampleFn(@UnknownKeyFor @NonNull @Initialized int sampleSize) {
            if (sampleSize < 0) {
                throw new IllegalArgumentException("sample size must be >= 0");
            }
            this.sampleSize = sampleSize;
            this.topCombineFn = new Top.TopCombineFn(sampleSize, new KV.OrderByKey());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Top.BoundedHeap<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, T>, @UnknownKeyFor @NonNull @Initialized SerializableComparator<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, T>>> createAccumulator() {
            return this.topCombineFn.createAccumulator();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Top.BoundedHeap<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, T>, @UnknownKeyFor @NonNull @Initialized SerializableComparator<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, T>>> addInput(@UnknownKeyFor @NonNull @Initialized Top.BoundedHeap<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, T>, @UnknownKeyFor @NonNull @Initialized SerializableComparator<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, T>>> accumulator, T input) {
            accumulator.addInput(KV.of(this.rand.nextInt(), input));
            return accumulator;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Top.BoundedHeap<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, T>, @UnknownKeyFor @NonNull @Initialized SerializableComparator<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, T>>> mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Top.BoundedHeap<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, T>, @UnknownKeyFor @NonNull @Initialized SerializableComparator<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, T>>>> accumulators) {
            return (Top.BoundedHeap)this.topCombineFn.mergeAccumulators(accumulators);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Iterable<T> extractOutput(@UnknownKeyFor @NonNull @Initialized Top.BoundedHeap<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, T>, @UnknownKeyFor @NonNull @Initialized SerializableComparator<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, T>>> accumulator) {
            ArrayList out = new ArrayList();
            Iterator iterator = accumulator.extractOutput().iterator();
            while (iterator.hasNext()) {
                KV element = (KV)iterator.next();
                out.add(element.getValue());
            }
            return out;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Top.BoundedHeap<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, T>, @UnknownKeyFor @NonNull @Initialized SerializableComparator<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, T>>>> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<T> inputCoder) {
            return this.topCombineFn.getAccumulatorCoder(registry, (Coder<KV<Integer, T>>)KvCoder.of(BigEndianIntegerCoder.of(), inputCoder));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Iterable<T>> getDefaultOutputCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<T> inputCoder) {
            return IterableCoder.of(inputCoder);
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("sampleSize", this.sampleSize).withLabel("Sample Size"));
        }
    }

    private static class AnyValueCombineFn<@UnknownKeyFor T>
    extends Combine.CombineFn<T, List<T>, T> {
        private @UnknownKeyFor @NonNull @Initialized SampleAnyCombineFn internal = new SampleAnyCombineFn(1L);

        private AnyValueCombineFn() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized List<T> createAccumulator() {
            return this.internal.createAccumulator();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized List<T> addInput(@UnknownKeyFor @NonNull @Initialized List<T> accumulator, T input) {
            return this.internal.addInput(accumulator, input);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized List<T> mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized List<T>> accumulators) {
            return this.internal.mergeAccumulators((Iterable)accumulators);
        }

        @Override
        public T extractOutput(@UnknownKeyFor @NonNull @Initialized List<T> accumulator) {
            Iterator<T> it = this.internal.extractOutput(accumulator).iterator();
            return it.hasNext() ? (T)it.next() : null;
        }
    }

    private static class SampleAnyCombineFn<@UnknownKeyFor T>
    extends Combine.CombineFn<T, List<T>, Iterable<T>> {
        private final @UnknownKeyFor @NonNull @Initialized long limit;

        private SampleAnyCombineFn(@UnknownKeyFor @NonNull @Initialized long limit) {
            this.limit = limit;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized List<T> createAccumulator() {
            return new ArrayList((int)this.limit);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized List<T> addInput(@UnknownKeyFor @NonNull @Initialized List<T> accumulator, T input) {
            if ((long)accumulator.size() < this.limit) {
                accumulator.add(input);
            }
            return accumulator;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized List<T> mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized List<T>> accumulators) {
            Iterator<List<T>> iter = accumulators.iterator();
            if (!iter.hasNext()) {
                return this.createAccumulator();
            }
            List<T> res = iter.next();
            while (iter.hasNext()) {
                for (T t : iter.next()) {
                    if ((long)res.size() >= this.limit) {
                        return res;
                    }
                    res.add(t);
                }
            }
            return res;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Iterable<T> extractOutput(@UnknownKeyFor @NonNull @Initialized List<T> accumulator) {
            return accumulator;
        }
    }

    private static class FixedSizePerKey<@UnknownKeyFor K, @UnknownKeyFor V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>> {
        private final @UnknownKeyFor @NonNull @Initialized int sampleSize;

        private FixedSizePerKey(@UnknownKeyFor @NonNull @Initialized int sampleSize) {
            this.sampleSize = sampleSize;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
            return (PCollection)input.apply(Combine.perKey(new FixedSizedSampleFn(this.sampleSize)));
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("sampleSize", this.sampleSize).withLabel("Sample Size"));
        }
    }

    private static class FixedSizeGlobally<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollection<Iterable<T>>> {
        private final @UnknownKeyFor @NonNull @Initialized int sampleSize;

        private FixedSizeGlobally(@UnknownKeyFor @NonNull @Initialized int sampleSize) {
            this.sampleSize = sampleSize;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Iterable<T>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            return (PCollection)input.apply(Combine.globally(new FixedSizedSampleFn(this.sampleSize)));
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("sampleSize", this.sampleSize).withLabel("Sample Size"));
        }
    }

    private static class Any<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollection<T>> {
        private final @UnknownKeyFor @NonNull @Initialized long limit;

        private Any(@UnknownKeyFor @NonNull @Initialized long limit) {
            Preconditions.checkArgument(limit >= 0L, "Expected non-negative limit, received %s.", limit);
            this.limit = limit;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> in) {
            return (PCollection)((PCollection)in.apply(Combine.globally(new SampleAnyCombineFn(this.limit)).withoutDefaults())).apply(Flatten.iterables());
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("sampleSize", this.limit).withLabel("Sample Size"));
        }
    }
}

