/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.monetdbbulkloader;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.DbCache;
import org.apache.hop.core.SourceToTargetMapping;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.monetdbbulkloader.MonetDbBulkLoaderMeta;
import org.apache.hop.ui.core.ConstUi;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.database.dialog.DatabaseExplorerDialog;
import org.apache.hop.ui.core.database.dialog.SqlEditor;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterMappingDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ITableItemInsertListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class MonetDbBulkLoaderDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = MonetDbBulkLoaderMeta.class;
    private CTabFolder wTabFolder;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private TextVar wSchema;
    private TextVar wTable;
    private TextVar wBufferSize;
    private TextVar wLogFile;
    private Button wTruncate;
    private Button wFullyQuoteSQL;
    private Combo wFieldSeparator;
    private Combo wFieldEnclosure;
    private Combo wNULLrepresentation;
    private Combo wEncoding;
    private TableView wReturn;
    private final MonetDbBulkLoaderMeta input;
    private ColumnInfo[] ciReturn;
    private final List<String> inputFields = new ArrayList<String>();
    private final List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();
    private static final String[] fieldSeparators = new String[]{"", "|", ","};
    private static final String[] fieldEnclosures = new String[]{"", "\""};
    private static final String[] nullRepresentations = new String[]{"", "null"};
    private static final String[] encodings = new String[]{"", "US-ASCII", "ISO-8859-1", "UTF-8", "UTF-16BE", "UTF-16LE", "UTF-16"};
    private static final String[] ALL_FILETYPES = new String[]{BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Filetype.All", (String[])new String[0])};

    public MonetDbBulkLoaderDialog(Shell parent, IVariables variables, MonetDbBulkLoaderMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        FocusAdapter lsFocusLost = new FocusAdapter(){

            public void focusLost(FocusEvent arg0) {
                MonetDbBulkLoaderDialog.this.setTableFieldCombo();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wSql = new Button((Composite)this.shell, 8);
        this.wSql.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.SQL.Button", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wSql, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Transformname.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wTransformName, this.input.getDatabaseMeta(), lsMod);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)this.wTabFolder, (int)4);
        CTabItem wGeneralSettingsTab = new CTabItem(this.wTabFolder, 0);
        wGeneralSettingsTab.setFont(GuiResource.getInstance().getFontDefault());
        wGeneralSettingsTab.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Tab.GeneralSettings.Label", (String[])new String[0]));
        Composite wGeneralSettingsComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wGeneralSettingsComp);
        FormLayout tabLayout = new FormLayout();
        tabLayout.marginWidth = 3;
        tabLayout.marginHeight = 3;
        wGeneralSettingsComp.setLayout((Layout)tabLayout);
        wGeneralSettingsComp.layout();
        wGeneralSettingsTab.setControl((Control)wGeneralSettingsComp);
        CTabItem wMonetDBmclientSettingsTab = new CTabItem(this.wTabFolder, 0);
        wMonetDBmclientSettingsTab.setFont(GuiResource.getInstance().getFontDefault());
        wMonetDBmclientSettingsTab.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Tab.MonetDBmclientSettings.Label", (String[])new String[0]));
        Composite wMonetDBmclientSettingsComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wMonetDBmclientSettingsComp);
        wMonetDBmclientSettingsComp.setLayout((Layout)tabLayout);
        wMonetDBmclientSettingsComp.layout();
        wMonetDBmclientSettingsTab.setControl((Control)wMonetDBmclientSettingsComp);
        Group wMonetDBmclientParamGroup = new Group(wMonetDBmclientSettingsComp, 4);
        wMonetDBmclientParamGroup.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Tab.MonetDBmclientSettings.ParameterGroup", (String[])new String[0]));
        PropsUi.setLook((Widget)wMonetDBmclientParamGroup);
        wMonetDBmclientParamGroup.setLayout((Layout)tabLayout);
        wMonetDBmclientParamGroup.layout();
        CTabItem wOutputFieldsTab = new CTabItem(this.wTabFolder, 0);
        wOutputFieldsTab.setFont(GuiResource.getInstance().getFontDefault());
        wOutputFieldsTab.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Tab.OutputFields", (String[])new String[0]));
        Composite wOutputFieldsComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wOutputFieldsComp);
        wOutputFieldsComp.setLayout((Layout)tabLayout);
        wOutputFieldsComp.layout();
        wOutputFieldsTab.setControl((Control)wOutputFieldsComp);
        this.wTabFolder.setSelection(0);
        this.wTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MonetDbBulkLoaderDialog.this.wTabFolder.layout(true, true);
            }
        });
        Label wlSchema = new Label(wGeneralSettingsComp, 131072);
        wlSchema.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.TargetSchema.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSchema);
        this.wSchema = new TextVar(this.variables, wGeneralSettingsComp, 18436);
        PropsUi.setLook((Widget)this.wSchema);
        this.wSchema.addModifyListener(lsMod);
        this.wSchema.addFocusListener((FocusListener)lsFocusLost);
        Label wlTable = new Label(wGeneralSettingsComp, 131072);
        wlTable.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.TargetTable.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTable);
        Button wbTable = new Button(wGeneralSettingsComp, 0x1000008);
        PropsUi.setLook((Widget)wbTable);
        wbTable.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Browse.Button", (String[])new String[0]));
        this.wTable = new TextVar(this.variables, wGeneralSettingsComp, 18436);
        PropsUi.setLook((Widget)this.wTable);
        this.wTable.addModifyListener(lsMod);
        this.wTable.addFocusListener((FocusListener)lsFocusLost);
        Label wlBufferSize = new Label(wGeneralSettingsComp, 131072);
        wlBufferSize.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.BufferSize.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlBufferSize);
        this.wBufferSize = new TextVar(this.variables, wGeneralSettingsComp, 18436);
        PropsUi.setLook((Widget)this.wBufferSize);
        this.wBufferSize.addModifyListener(lsMod);
        Label wlLogFile = new Label(wGeneralSettingsComp, 131072);
        wlLogFile.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.LogFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLogFile);
        Button wbLogFile = new Button(wGeneralSettingsComp, 0x1000008);
        PropsUi.setLook((Widget)wbLogFile);
        wbLogFile.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Browse.Button", (String[])new String[0]));
        this.wLogFile = new TextVar(this.variables, wGeneralSettingsComp, 18436);
        PropsUi.setLook((Widget)this.wLogFile);
        this.wLogFile.addModifyListener(lsMod);
        Label wlTruncate = new Label(wGeneralSettingsComp, 131072);
        wlTruncate.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Truncate.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTruncate);
        this.wTruncate = new Button(wGeneralSettingsComp, 32);
        PropsUi.setLook((Widget)this.wTruncate);
        SelectionAdapter lsSelMod = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MonetDbBulkLoaderDialog.this.input.setChanged();
                MonetDbBulkLoaderDialog.this.input.setTruncate(MonetDbBulkLoaderDialog.this.wTruncate.getSelection());
            }
        };
        this.wTruncate.addSelectionListener((SelectionListener)lsSelMod);
        Label wlFullyQuoteSQL = new Label(wGeneralSettingsComp, 131072);
        wlFullyQuoteSQL.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.FullyQuoteSQL.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFullyQuoteSQL);
        this.wFullyQuoteSQL = new Button(wGeneralSettingsComp, 32);
        PropsUi.setLook((Widget)this.wFullyQuoteSQL);
        SelectionAdapter lsFullyQuoteSQL = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MonetDbBulkLoaderDialog.this.input.setChanged();
                MonetDbBulkLoaderDialog.this.input.getDatabaseMeta().setQuoteAllFields(MonetDbBulkLoaderDialog.this.wFullyQuoteSQL.getSelection());
            }
        };
        this.wFullyQuoteSQL.addSelectionListener((SelectionListener)lsFullyQuoteSQL);
        Label wlFieldSeparator = new Label((Composite)wMonetDBmclientParamGroup, 131072);
        wlFieldSeparator.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Tab.MonetDBmclientSettings.ParameterGroup.FieldSeparator.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFieldSeparator);
        this.wFieldSeparator = new Combo((Composite)wMonetDBmclientParamGroup, 16779268);
        this.wFieldSeparator.setItems(fieldSeparators);
        PropsUi.setLook((Widget)this.wFieldSeparator);
        this.wFieldSeparator.addModifyListener(lsMod);
        Label wlFieldEnclosure = new Label((Composite)wMonetDBmclientParamGroup, 131072);
        wlFieldEnclosure.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Tab.MonetDBmclientSettings.ParameterGroup.FieldEnclosure.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFieldEnclosure);
        this.wFieldEnclosure = new Combo((Composite)wMonetDBmclientParamGroup, 16779268);
        this.wFieldEnclosure.setItems(fieldEnclosures);
        this.wFieldEnclosure.addModifyListener(lsMod);
        Label wlNULLrepresentation = new Label((Composite)wMonetDBmclientParamGroup, 131072);
        wlNULLrepresentation.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Tab.MonetDBmclientSettings.ParameterGroup.NULLrepresentation.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlNULLrepresentation);
        this.wNULLrepresentation = new Combo((Composite)wMonetDBmclientParamGroup, 16779268);
        this.wNULLrepresentation.setItems(nullRepresentations);
        this.wNULLrepresentation.addModifyListener(lsMod);
        Label wlEncoding = new Label((Composite)wMonetDBmclientParamGroup, 131072);
        wlEncoding.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Encoding.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlEncoding);
        this.wEncoding = new Combo((Composite)wMonetDBmclientParamGroup, 18436);
        this.wEncoding.setToolTipText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Encoding.Tooltip", (String[])new String[0]));
        this.wEncoding.setItems(encodings);
        PropsUi.setLook((Widget)this.wEncoding);
        this.wEncoding.addModifyListener(lsMod);
        Label wlReturn = new Label(wOutputFieldsComp, 0);
        wlReturn.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlReturn);
        int upInsCols = 3;
        int upInsRows = this.input.getFieldTable() != null ? this.input.getFieldTable().length : 1;
        this.ciReturn = new ColumnInfo[upInsCols];
        this.ciReturn[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.ColumnInfo.StreamField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.ColumnInfo.FormatOK", (String[])new String[0]), 2, new String[]{"Y", "N"}, true);
        this.tableFieldColumns.add(this.ciReturn[0]);
        this.wReturn = new TableView(this.variables, wOutputFieldsComp, 68354, this.ciReturn, upInsRows, lsMod, this.props);
        this.wReturn.optWidth(true);
        Button wGetLU = new Button(wOutputFieldsComp, 8);
        wGetLU.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.GetFields.Label", (String[])new String[0]));
        Button wDoMapping = new Button(wOutputFieldsComp, 8);
        wDoMapping.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.EditMapping.Label", (String[])new String[0]));
        wDoMapping.addListener(13, arg0 -> this.generateMappings());
        Button wClearDBCache = new Button(wOutputFieldsComp, 8);
        wClearDBCache.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Tab.ClearDbCache", (String[])new String[0]));
        wClearDBCache.addListener(13, e -> this.clearDbCache());
        this.fdlTransformName = new FormData();
        this.fdlTransformName.top = new FormAttachment(0, 15);
        this.fdlTransformName.left = new FormAttachment(0, margin);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.top = new FormAttachment((Control)this.wlTransformName, 0, 0x1000000);
        this.fdTransformName.left = new FormAttachment((Control)this.wlTransformName, margin);
        this.fdTransformName.right = new FormAttachment(100, -margin);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment(this.wConnection, margin + 20);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        FormData fdlSchema = new FormData();
        fdlSchema.top = new FormAttachment((Control)this.wTabFolder, margin);
        fdlSchema.left = new FormAttachment((Control)wGeneralSettingsComp, margin);
        fdlSchema.right = new FormAttachment(middle, -margin);
        wlSchema.setLayoutData((Object)fdlSchema);
        FormData fdSchema = new FormData();
        fdSchema.top = new FormAttachment((Control)wlSchema, 0, 0x1000000);
        fdSchema.left = new FormAttachment(middle, margin);
        fdSchema.right = new FormAttachment(100, -margin);
        this.wSchema.setLayoutData((Object)fdSchema);
        FormData fdlTable = new FormData();
        fdlTable.top = new FormAttachment((Control)this.wSchema, margin);
        fdlTable.left = new FormAttachment(0, margin);
        fdlTable.right = new FormAttachment(middle, -margin);
        wlTable.setLayoutData((Object)fdlTable);
        FormData fdbTable = new FormData();
        fdbTable.top = new FormAttachment((Control)wlTable, 0, 0x1000000);
        fdbTable.right = new FormAttachment(100, -margin);
        wbTable.setLayoutData((Object)fdbTable);
        FormData fdTable = new FormData();
        fdTable.top = new FormAttachment((Control)this.wSchema, margin);
        fdTable.left = new FormAttachment(middle, margin);
        fdTable.right = new FormAttachment((Control)wbTable, -margin);
        this.wTable.setLayoutData((Object)fdTable);
        FormData fdlBufferSize = new FormData();
        fdlBufferSize.top = new FormAttachment((Control)this.wTable, margin);
        fdlBufferSize.left = new FormAttachment(0, margin);
        fdlBufferSize.right = new FormAttachment(middle, -margin);
        wlBufferSize.setLayoutData((Object)fdlBufferSize);
        FormData fdBufferSize = new FormData();
        fdBufferSize.top = new FormAttachment((Control)this.wTable, margin);
        fdBufferSize.left = new FormAttachment(middle, margin);
        fdBufferSize.right = new FormAttachment(100, -margin);
        this.wBufferSize.setLayoutData((Object)fdBufferSize);
        FormData fdlLogFile = new FormData();
        fdlLogFile.top = new FormAttachment((Control)this.wBufferSize, margin);
        fdlLogFile.left = new FormAttachment(0, margin);
        fdlLogFile.right = new FormAttachment(middle, -margin);
        wlLogFile.setLayoutData((Object)fdlLogFile);
        FormData fdbLogFile = new FormData();
        fdbLogFile.top = new FormAttachment((Control)this.wBufferSize, 0);
        fdbLogFile.right = new FormAttachment(100, -margin);
        wbLogFile.setLayoutData((Object)fdbLogFile);
        FormData fdLogFile = new FormData();
        fdLogFile.left = new FormAttachment(middle, margin);
        fdLogFile.top = new FormAttachment((Control)this.wBufferSize, margin);
        fdLogFile.right = new FormAttachment((Control)wbLogFile, -margin);
        fdLogFile.right = new FormAttachment(middle, -margin);
        this.wLogFile.setLayoutData((Object)fdLogFile);
        FormData fdlTruncate = new FormData();
        fdlTruncate.top = new FormAttachment((Control)this.wLogFile, margin * 2);
        fdlTruncate.left = new FormAttachment(0, margin);
        fdlTruncate.right = new FormAttachment(middle, -margin);
        wlTruncate.setLayoutData((Object)fdlTruncate);
        FormData fdTruncate = new FormData();
        fdTruncate.top = new FormAttachment((Control)wlTruncate, 0, 0x1000000);
        fdTruncate.left = new FormAttachment((Control)wlTruncate, margin);
        fdTruncate.right = new FormAttachment(100, -margin);
        this.wTruncate.setLayoutData((Object)fdTruncate);
        FormData fdlFullyQuoteSQL = new FormData();
        fdlFullyQuoteSQL.top = new FormAttachment((Control)wlTruncate, margin * 2);
        fdlFullyQuoteSQL.left = new FormAttachment(0, margin);
        fdlFullyQuoteSQL.right = new FormAttachment(middle, -margin);
        wlFullyQuoteSQL.setLayoutData((Object)fdlFullyQuoteSQL);
        FormData fdFullyQuoteSQL = new FormData();
        fdFullyQuoteSQL.top = new FormAttachment((Control)wlFullyQuoteSQL, 0, 0x1000000);
        fdFullyQuoteSQL.left = new FormAttachment((Control)wlFullyQuoteSQL, margin);
        fdFullyQuoteSQL.right = new FormAttachment(100, -margin);
        this.wFullyQuoteSQL.setLayoutData((Object)fdFullyQuoteSQL);
        FormData fdgMonetDBmclientParamGroup = new FormData();
        fdgMonetDBmclientParamGroup.top = new FormAttachment((Control)wMonetDBmclientSettingsComp, margin * 3);
        fdgMonetDBmclientParamGroup.left = new FormAttachment(0, margin);
        fdgMonetDBmclientParamGroup.right = new FormAttachment(100, -margin);
        wMonetDBmclientParamGroup.setLayoutData((Object)fdgMonetDBmclientParamGroup);
        Text text = new Text((Composite)this.shell, 0);
        GC gc = new GC((Drawable)text);
        FontMetrics fm = gc.getFontMetrics();
        int charWidth = fm.getAverageCharWidth();
        int fieldWidth = text.computeSize((int)(charWidth * 20), (int)-1).x;
        gc.dispose();
        text.dispose();
        FormData fdlFieldSeparator = new FormData();
        fdlFieldSeparator.top = new FormAttachment((Control)wMonetDBmclientSettingsComp, 3 * margin);
        fdlFieldSeparator.left = new FormAttachment(0, 3 * margin);
        fdlFieldSeparator.right = new FormAttachment(middle, -margin);
        wlFieldSeparator.setLayoutData((Object)fdlFieldSeparator);
        FormData fdFieldSeparator = new FormData();
        fdFieldSeparator.top = new FormAttachment((Control)wMonetDBmclientSettingsComp, 3 * margin);
        fdFieldSeparator.left = new FormAttachment(middle, margin);
        fdFieldSeparator.width = fieldWidth;
        this.wFieldSeparator.setLayoutData((Object)fdFieldSeparator);
        FormData fdlFieldEnclosure = new FormData();
        fdlFieldEnclosure.top = new FormAttachment((Control)this.wFieldSeparator, 2 * margin);
        fdlFieldEnclosure.left = new FormAttachment(0, 3 * margin);
        fdlFieldEnclosure.right = new FormAttachment(middle, -margin);
        wlFieldEnclosure.setLayoutData((Object)fdlFieldEnclosure);
        FormData fdFieldEnclosure = new FormData();
        fdFieldEnclosure.top = new FormAttachment((Control)this.wFieldSeparator, 2 * margin);
        fdFieldEnclosure.left = new FormAttachment(middle, margin);
        fdFieldEnclosure.width = fieldWidth;
        this.wFieldEnclosure.setLayoutData((Object)fdFieldEnclosure);
        FormData fdlNULLrepresentation = new FormData();
        fdlNULLrepresentation.top = new FormAttachment((Control)this.wFieldEnclosure, 2 * margin);
        fdlNULLrepresentation.left = new FormAttachment(0, 3 * margin);
        fdlNULLrepresentation.right = new FormAttachment(middle, -margin);
        wlNULLrepresentation.setLayoutData((Object)fdlNULLrepresentation);
        FormData fdNULLrepresentation = new FormData();
        fdNULLrepresentation.top = new FormAttachment((Control)this.wFieldEnclosure, 2 * margin);
        fdNULLrepresentation.left = new FormAttachment(middle, margin);
        fdNULLrepresentation.width = fieldWidth;
        this.wNULLrepresentation.setLayoutData((Object)fdNULLrepresentation);
        FormData fdlEncoding = new FormData();
        fdlEncoding.top = new FormAttachment((Control)this.wNULLrepresentation, 2 * margin);
        fdlEncoding.left = new FormAttachment(0, 3 * margin);
        fdlEncoding.right = new FormAttachment(middle, -margin);
        wlEncoding.setLayoutData((Object)fdlEncoding);
        FormData fdEncoding = new FormData();
        fdEncoding.top = new FormAttachment((Control)this.wNULLrepresentation, 2 * margin);
        fdEncoding.left = new FormAttachment(middle, margin);
        fdEncoding.width = fieldWidth;
        this.wEncoding.setLayoutData((Object)fdEncoding);
        FormData fdlReturn = new FormData();
        fdlReturn.top = new FormAttachment((Control)wOutputFieldsComp, 5 * margin);
        fdlReturn.left = new FormAttachment(0, margin);
        wlReturn.setLayoutData((Object)fdlReturn);
        FormData fdDoMapping = new FormData();
        fdDoMapping.top = new FormAttachment((Control)wOutputFieldsComp, 2 * margin);
        fdDoMapping.right = new FormAttachment(100, -margin);
        wDoMapping.setLayoutData((Object)fdDoMapping);
        FormData fdGetLU = new FormData();
        fdGetLU.top = new FormAttachment((Control)wOutputFieldsComp, 2 * margin);
        fdGetLU.right = new FormAttachment((Control)wDoMapping, -margin);
        wGetLU.setLayoutData((Object)fdGetLU);
        FormData fdClearDBCache = new FormData();
        fdClearDBCache.top = new FormAttachment((Control)wOutputFieldsComp, 2 * margin);
        fdClearDBCache.right = new FormAttachment((Control)wGetLU, -margin);
        wClearDBCache.setLayoutData((Object)fdClearDBCache);
        FormData fdReturn = new FormData();
        fdReturn.top = new FormAttachment((Control)wGetLU, 3 * margin);
        fdReturn.left = new FormAttachment(0, margin);
        fdReturn.right = new FormAttachment(100, -margin);
        fdReturn.bottom = new FormAttachment(100, -2 * margin);
        this.wReturn.setLayoutData((Object)fdReturn);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.add(row.getValueMeta(i).getName());
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        wbLogFile.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wLogFile, (IVariables)this.variables, (String[])new String[]{"*"}, (String[])ALL_FILETYPES, (boolean)true));
        this.wOk.addListener(13, e -> this.ok());
        wGetLU.addListener(13, e -> this.getUpdate());
        this.wSql.addListener(13, e -> this.create());
        this.wCancel.addListener(13, e -> this.cancel());
        wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MonetDbBulkLoaderDialog.this.getTableName();
            }
        });
        this.getData();
        this.setTableFieldCombo();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void clearDbCache() {
        DbCache.getInstance().clear(this.input.getDbConnectionName());
        MessageBox mb = new MessageBox(this.shell, 34);
        mb.setMessage(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Tab.ClearedDbCacheMsg", (String[])new String[0]));
        mb.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Tab.ClearedDbCacheTitle", (String[])new String[0]));
        mb.open();
    }

    protected void setTableFieldCombo() {
        Runnable fieldLoader = () -> {
            block12: {
                if (!(this.wTable.isDisposed() || this.wConnection.isDisposed() || this.wSchema.isDisposed())) {
                    DatabaseMeta databaseMeta;
                    String tableName = this.wTable.getText();
                    String connectionName = this.wConnection.getText();
                    String schemaName = this.wSchema.getText();
                    for (ColumnInfo colInfo : this.tableFieldColumns) {
                        colInfo.setComboValues(new String[0]);
                    }
                    if (!Utils.isEmpty((CharSequence)tableName) && (databaseMeta = this.pipelineMeta.findDatabase(connectionName, this.variables)) != null) {
                        try (Database db = new Database(loggingObject, this.variables, databaseMeta);){
                            String[] fieldNames;
                            db.connect();
                            String schemaTable = databaseMeta.getQuotedSchemaTableCombination(this.variables, schemaName, tableName);
                            IRowMeta r = db.getTableFields(schemaTable);
                            if (null == r || null == (fieldNames = r.getFieldNames())) break block12;
                            for (ColumnInfo colInfo : this.tableFieldColumns) {
                                colInfo.setComboValues(fieldNames);
                            }
                        }
                        catch (Exception e) {
                            for (ColumnInfo colInfo : this.tableFieldColumns) {
                                colInfo.setComboValues(new String[0]);
                            }
                        }
                    }
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }

    public void getData() {
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        if (this.input.getFieldTable() != null) {
            for (int i = 0; i < this.input.getFieldTable().length; ++i) {
                TableItem item = this.wReturn.table.getItem(i);
                if (this.input.getFieldTable()[i] != null) {
                    item.setText(1, this.input.getFieldTable()[i]);
                }
                if (this.input.getFieldStream()[i] != null) {
                    item.setText(2, this.input.getFieldStream()[i]);
                }
                item.setText(3, this.input.getFieldFormatOk()[i] ? "Y" : "N");
            }
        }
        if (this.input.getDatabaseMeta() != null) {
            this.wConnection.setText(this.input.getDatabaseMeta().getName());
        }
        if (this.input.getSchemaName() != null) {
            this.wSchema.setText(this.input.getSchemaName());
        }
        if (this.input.getTableName() != null) {
            this.wTable.setText(this.input.getTableName());
        }
        this.wBufferSize.setText(this.input.getBufferSize());
        if (this.input.getLogFile() != null) {
            this.wLogFile.setText(this.input.getLogFile());
        }
        this.wTruncate.setSelection(this.input.isTruncate());
        this.wFullyQuoteSQL.setSelection(this.input.isFullyQuoteSQL());
        if (this.input.getFieldSeparator() != null) {
            this.wFieldSeparator.setText(this.input.getFieldSeparator());
        }
        if (this.input.getFieldEnclosure() != null) {
            this.wFieldEnclosure.setText(this.input.getFieldEnclosure());
        }
        if (this.input.getNullRepresentation() != null) {
            this.wNULLrepresentation.setText(this.input.getNullRepresentation());
        }
        if (this.input.getEncoding() != null) {
            this.wEncoding.setText(this.input.getEncoding());
        }
        this.wReturn.setRowNums();
        this.wReturn.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    protected void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    protected void setComboBoxes() {
        String[] fieldNames = ConstUi.sortFieldNames(this.inputFields);
        if (this.ciReturn != null) {
            this.ciReturn[1].setComboValues(fieldNames);
        }
    }

    protected void getInfo(MonetDbBulkLoaderMeta inf) {
        int nrfields = this.wReturn.nrNonEmpty();
        inf.allocate(nrfields);
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Log.FoundFields", (String[])new String[]{"" + nrfields}));
        }
        for (int i = 0; i < nrfields; ++i) {
            TableItem item = this.wReturn.getNonEmpty(i);
            inf.getFieldTable()[i] = item.getText(1);
            inf.getFieldStream()[i] = item.getText(2);
            inf.getFieldFormatOk()[i] = "Y".equalsIgnoreCase(item.getText(3));
        }
        inf.setDbConnectionName(this.wConnection.getText());
        inf.setSchemaName(this.wSchema.getText());
        inf.setTableName(this.wTable.getText());
        inf.setDatabaseMeta(this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables));
        inf.setBufferSize(this.wBufferSize.getText());
        inf.setLogFile(this.wLogFile.getText());
        inf.setTruncate(this.wTruncate.getSelection());
        inf.setFullyQuoteSQL(this.wFullyQuoteSQL.getSelection());
        inf.setFieldSeparator(this.wFieldSeparator.getText());
        inf.setFieldEnclosure(this.wFieldEnclosure.getText());
        inf.setNullRepresentation(this.wNULLrepresentation.getText());
        inf.setEncoding(this.wEncoding.getText());
        this.transformName = this.wTransformName.getText();
    }

    protected void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input);
        this.dispose();
    }

    protected void getTableName() {
        String connectionName = this.wConnection.getText();
        if (StringUtils.isEmpty((String)connectionName)) {
            return;
        }
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(connectionName, this.variables);
        if (databaseMeta != null) {
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Log.LookingAtConnection", (String[])new String[0]) + databaseMeta.toString());
            }
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, this.variables, databaseMeta, this.pipelineMeta.getDatabases());
            std.setSelectedSchemaAndTable(this.wSchema.getText(), this.wTable.getText());
            if (std.open()) {
                this.wSchema.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                this.wTable.setText(Const.NVL((String)std.getTableName(), (String)""));
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
    }

    private void generateMappings() {
        EnterMappingDialog d;
        IRowMeta targetFields;
        IRowMeta sourceFields;
        try {
            sourceFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.DoMapping.UnableToFindSourceFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.DoMapping.UnableToFindSourceFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        this.input.setDatabaseMeta(this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables));
        this.input.setTableName(this.variables.resolve(this.wTable.getText()));
        ITransformMeta transformMetaInterface = this.transformMeta.getTransform();
        try {
            targetFields = transformMetaInterface.getRequiredFields(this.variables);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.DoMapping.UnableToFindTargetFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.DoMapping.UnableToFindTargetFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        String[] inputNames = new String[sourceFields.size()];
        for (int i = 0; i < sourceFields.size(); ++i) {
            IValueMeta value = sourceFields.getValueMeta(i);
            inputNames[i] = value.getName();
        }
        List<SourceToTargetMapping> mappings = new ArrayList();
        StringBuilder missingSourceFields = new StringBuilder();
        StringBuilder missingTargetFields = new StringBuilder();
        int nrFields = this.wReturn.nrNonEmpty();
        for (int i = 0; i < nrFields; ++i) {
            int targetIndex;
            TableItem item = this.wReturn.getNonEmpty(i);
            String source = item.getText(2);
            String target = item.getText(1);
            int sourceIndex = sourceFields.indexOfValue(source);
            if (sourceIndex < 0) {
                missingSourceFields.append(Const.CR).append("   ").append(source).append(" --> ").append(target);
            }
            if ((targetIndex = targetFields.indexOfValue(target)) < 0) {
                missingTargetFields.append(Const.CR).append("   ").append(source).append(" --> ").append(target);
            }
            if (sourceIndex < 0 || targetIndex < 0) continue;
            SourceToTargetMapping mapping = new SourceToTargetMapping(sourceIndex, targetIndex);
            mappings.add(mapping);
        }
        if (missingSourceFields.length() > 0 || missingTargetFields.length() > 0) {
            boolean goOn;
            Object message = "";
            if (missingSourceFields.length() > 0) {
                message = (String)message + BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.DoMapping.SomeSourceFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            if (missingTargetFields.length() > 0) {
                message = (String)message + BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.DoMapping.SomeTargetFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            message = (String)message + Const.CR;
            message = (String)message + BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.DoMapping.SomeFieldsNotFoundContinue", (String[])new String[0]) + Const.CR;
            int answer = BaseDialog.openMessageBox((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.DoMapping.SomeFieldsNotFoundTitle", (String[])new String[0]), (String)message, (int)292);
            boolean bl = goOn = (answer & 0x20) != 0;
            if (!goOn) {
                return;
            }
        }
        if ((mappings = (d = new EnterMappingDialog(this.shell, sourceFields.getFieldNames(), targetFields.getFieldNames(), mappings)).open()) != null) {
            this.wReturn.table.removeAll();
            this.wReturn.table.setItemCount(mappings.size());
            for (int i = 0; i < mappings.size(); ++i) {
                SourceToTargetMapping mapping = (SourceToTargetMapping)mappings.get(i);
                TableItem item = this.wReturn.table.getItem(i);
                item.setText(2, sourceFields.getValueMeta(mapping.getSourcePosition()).getName());
                item.setText(1, targetFields.getValueMeta(mapping.getTargetPosition()).getName());
            }
            this.wReturn.setRowNums();
            this.wReturn.optWidth(true);
        }
    }

    private void getUpdate() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                ITableItemInsertListener listener = (tableItem, v) -> {
                    if (v.getType() == 3) {
                        tableItem.setText(3, "Y");
                    } else {
                        tableItem.setText(3, "Y");
                    }
                    return true;
                };
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wReturn, (int)1, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, (ITableItemInsertListener)listener);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void create() {
        try {
            MonetDbBulkLoaderMeta info = new MonetDbBulkLoaderMeta();
            this.getInfo(info);
            String name = this.transformName;
            SqlStatement sql = info.getTableDdl(this.variables, this.pipelineMeta, name, false, null, false);
            if (!sql.hasError()) {
                if (sql.hasSql()) {
                    SqlEditor sqledit = new SqlEditor(this.shell, 0, this.variables, info.getDatabaseMeta(), DbCache.getInstance(), sql.getSql());
                    sqledit.open();
                } else {
                    MessageBox mb = new MessageBox(this.shell, 34);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.NoSQLNeeds.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.NoSQLNeeds.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(sql.getError());
                mb.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.SQLError.DialogTitle", (String[])new String[0]));
                mb.open();
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.CouldNotBuildSQL.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.CouldNotBuildSQL.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

