/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.ldapoutput;

import java.util.ArrayList;
import org.apache.hop.core.Const;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.ldapinput.ILdapMeta;
import org.apache.hop.pipeline.transforms.ldapinput.LdapConnection;
import org.apache.hop.pipeline.transforms.ldapoutput.LdapOutputData;
import org.apache.hop.pipeline.transforms.ldapoutput.LdapOutputMeta;

public class LdapOutput
extends BaseTransform<LdapOutputMeta, LdapOutputData> {
    public static final String CONST_LDAP_OUTPUT_ERROR_CAN_NOT_FIND_FIELD = "LdapOutput.Error.CanNotFindField";
    private static Class<?> classFromResourcesPackage = LdapOutputMeta.class;

    public LdapOutput(TransformMeta transformMeta, LdapOutputMeta meta, LdapOutputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] outputRowData = this.getRow();
        if (outputRowData == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            if (((LdapOutputMeta)this.meta).getOperationType() != 4 && ((LdapOutputMeta)this.meta).getOperationType() != 5) {
                int i;
                ((LdapOutputData)this.data).nrFields = ((LdapOutputMeta)this.meta).getUpdateLookup().length;
                if (((LdapOutputData)this.data).nrFields == 0) {
                    throw new HopException(BaseMessages.getString(classFromResourcesPackage, (String)"LdapOutputUpdateDialog.FieldsMissing.DialogMessage", (String[])new String[0]));
                }
                ((LdapOutputData)this.data).fieldsAttribute = new String[((LdapOutputData)this.data).nrFields];
                ((LdapOutputData)this.data).fieldStream = new int[((LdapOutputData)this.data).nrFields];
                ArrayList<Integer> fieldsToUpdateInStreaml = new ArrayList<Integer>();
                ArrayList<String> fieldsToUpdateAttributel = new ArrayList<String>();
                for (i = 0; i < ((LdapOutputData)this.data).nrFields; ++i) {
                    ((LdapOutputData)this.data).fieldStream[i] = this.getInputRowMeta().indexOfValue(this.resolve(((LdapOutputMeta)this.meta).getUpdateStream()[i]));
                    if (((LdapOutputData)this.data).fieldStream[i] < 0) {
                        throw new HopException("Field [" + ((LdapOutputMeta)this.meta).getUpdateStream()[i] + "] couldn't be found in the input stream!");
                    }
                    ((LdapOutputData)this.data).fieldsAttribute[i] = this.resolve(((LdapOutputMeta)this.meta).getUpdateLookup()[i]);
                    if (((LdapOutputMeta)this.meta).getOperationType() != 1 || !((LdapOutputMeta)this.meta).getUpdate()[i].booleanValue()) continue;
                    fieldsToUpdateInStreaml.add(((LdapOutputData)this.data).fieldStream[i]);
                    fieldsToUpdateAttributel.add(((LdapOutputData)this.data).fieldsAttribute[i]);
                }
                ((LdapOutputData)this.data).nrFieldsToUpdate = fieldsToUpdateInStreaml.size();
                if (((LdapOutputData)this.data).nrFieldsToUpdate > 0) {
                    ((LdapOutputData)this.data).fieldStreamToUpdate = new int[((LdapOutputData)this.data).nrFieldsToUpdate];
                    ((LdapOutputData)this.data).fieldsAttributeToUpdate = new String[((LdapOutputData)this.data).nrFieldsToUpdate];
                    for (i = 0; i < fieldsToUpdateInStreaml.size(); ++i) {
                        ((LdapOutputData)this.data).fieldStreamToUpdate[i] = (Integer)fieldsToUpdateInStreaml.get(i);
                        ((LdapOutputData)this.data).fieldsAttributeToUpdate[i] = (String)fieldsToUpdateAttributel.get(i);
                    }
                }
                ((LdapOutputData)this.data).attributes = new String[((LdapOutputData)this.data).nrFields];
                if (((LdapOutputMeta)this.meta).getOperationType() == 1 && ((LdapOutputData)this.data).nrFieldsToUpdate > 0) {
                    ((LdapOutputData)this.data).attributesToUpdate = new String[((LdapOutputData)this.data).nrFieldsToUpdate];
                }
            }
            if (((LdapOutputMeta)this.meta).getOperationType() == 5) {
                String oldDnField = this.resolve(((LdapOutputMeta)this.meta).getOldDnFieldName());
                if (Utils.isEmpty((CharSequence)oldDnField)) {
                    throw new HopException(BaseMessages.getString(classFromResourcesPackage, (String)"LdapOutput.Error.OldDNFieldMissing", (String[])new String[0]));
                }
                String newDnField = this.resolve(((LdapOutputMeta)this.meta).getNewDnFieldName());
                if (Utils.isEmpty((CharSequence)newDnField)) {
                    throw new HopException(BaseMessages.getString(classFromResourcesPackage, (String)"LdapOutput.Error.NewDNFieldMissing", (String[])new String[0]));
                }
                ((LdapOutputData)this.data).indexOfOldDNField = this.getInputRowMeta().indexOfValue(oldDnField);
                if (((LdapOutputData)this.data).indexOfOldDNField < 0) {
                    throw new HopException(BaseMessages.getString(classFromResourcesPackage, (String)CONST_LDAP_OUTPUT_ERROR_CAN_NOT_FIND_FIELD, (String[])new String[]{oldDnField}));
                }
                ((LdapOutputData)this.data).indexOfNewDNField = this.getInputRowMeta().indexOfValue(newDnField);
                if (((LdapOutputData)this.data).indexOfNewDNField < 0) {
                    throw new HopException(BaseMessages.getString(classFromResourcesPackage, (String)CONST_LDAP_OUTPUT_ERROR_CAN_NOT_FIND_FIELD, (String[])new String[]{newDnField}));
                }
            } else {
                String dnField = this.resolve(((LdapOutputMeta)this.meta).getDnField());
                if (Utils.isEmpty((CharSequence)dnField)) {
                    throw new HopException(BaseMessages.getString(classFromResourcesPackage, (String)"LdapOutput.Error.DNFieldMissing", (String[])new String[0]));
                }
                ((LdapOutputData)this.data).indexOfDNField = this.getInputRowMeta().indexOfValue(dnField);
                if (((LdapOutputData)this.data).indexOfDNField < 0) {
                    throw new HopException(BaseMessages.getString(classFromResourcesPackage, (String)CONST_LDAP_OUTPUT_ERROR_CAN_NOT_FIND_FIELD, (String[])new String[]{dnField}));
                }
            }
        }
        this.incrementLinesInput();
        String dn = null;
        try {
            if (((LdapOutputMeta)this.meta).getOperationType() != 5) {
                dn = this.getInputRowMeta().getString(outputRowData, ((LdapOutputData)this.data).indexOfDNField);
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(classFromResourcesPackage, (String)"LdapOutput.ProcessDn", (String[])new String[]{dn}));
                }
                if (((LdapOutputMeta)this.meta).getOperationType() != 4) {
                    for (int i = 0; i < ((LdapOutputData)this.data).nrFields; ++i) {
                        ((LdapOutputData)this.data).attributes[i] = this.getInputRowMeta().getString(outputRowData, ((LdapOutputData)this.data).fieldStream[i]);
                    }
                }
            }
            block1 : switch (((LdapOutputMeta)this.meta).getOperationType()) {
                case 1: {
                    for (int i = 0; i < ((LdapOutputData)this.data).nrFieldsToUpdate; ++i) {
                        ((LdapOutputData)this.data).attributesToUpdate[i] = this.getInputRowMeta().getString(outputRowData, ((LdapOutputData)this.data).fieldStreamToUpdate[i]);
                    }
                    int status = ((LdapOutputData)this.data).connection.upsert(dn, ((LdapOutputData)this.data).fieldsAttribute, ((LdapOutputData)this.data).attributes, ((LdapOutputData)this.data).fieldsAttributeToUpdate, ((LdapOutputData)this.data).attributesToUpdate, ((LdapOutputData)this.data).separator);
                    switch (status) {
                        case 1: {
                            this.incrementLinesOutput();
                            break block1;
                        }
                        case 2: {
                            this.incrementLinesUpdated();
                            break block1;
                        }
                    }
                    this.incrementLinesSkipped();
                    break;
                }
                case 2: {
                    int status = ((LdapOutputData)this.data).connection.update(dn, ((LdapOutputData)this.data).fieldsAttribute, ((LdapOutputData)this.data).attributes, ((LdapOutputMeta)this.meta).isFailIfNotExist());
                    if (status == 2) {
                        this.incrementLinesUpdated();
                        break;
                    }
                    this.incrementLinesSkipped();
                    break;
                }
                case 3: {
                    int status = ((LdapOutputData)this.data).connection.add(dn, ((LdapOutputData)this.data).fieldsAttribute, ((LdapOutputData)this.data).attributes, ((LdapOutputData)this.data).separator, ((LdapOutputMeta)this.meta).isFailIfNotExist());
                    if (status == 4) {
                        this.incrementLinesUpdated();
                        break;
                    }
                    this.incrementLinesSkipped();
                    break;
                }
                case 4: {
                    int status = ((LdapOutputData)this.data).connection.delete(dn, ((LdapOutputMeta)this.meta).isFailIfNotExist());
                    if (status == 3) {
                        this.incrementLinesUpdated();
                        break;
                    }
                    this.incrementLinesSkipped();
                    break;
                }
                case 5: {
                    String oldDn = this.getInputRowMeta().getString(outputRowData, ((LdapOutputData)this.data).indexOfOldDNField);
                    String newDn = this.getInputRowMeta().getString(outputRowData, ((LdapOutputData)this.data).indexOfNewDNField);
                    ((LdapOutputData)this.data).connection.rename(oldDn, newDn, ((LdapOutputMeta)this.meta).isDeleteRDN());
                    this.incrementLinesOutput();
                    break;
                }
                default: {
                    ((LdapOutputData)this.data).connection.insert(dn, ((LdapOutputData)this.data).fieldsAttribute, ((LdapOutputData)this.data).attributes, ((LdapOutputData)this.data).separator);
                    this.incrementLinesOutput();
                }
            }
            this.putRow(this.getInputRowMeta(), outputRowData);
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(classFromResourcesPackage, (String)"LdapOutput.log.ReadRow", (String[])new String[0]), new Object[]{this.getInputRowMeta().getString(outputRowData)});
            }
            if (this.checkFeedback(this.getLinesInput()) && this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(classFromResourcesPackage, (String)"LdapOutput.log.LineRow", (String[])new String[0]) + this.getLinesInput());
            }
            return true;
        }
        catch (Exception e) {
            boolean sendToErrorRow = false;
            String errorMessage = null;
            if (!this.getTransformMeta().isDoingErrorHandling()) {
                this.logError(BaseMessages.getString(classFromResourcesPackage, (String)"LdapOutput.log.Exception", (String[])new String[]{e.getMessage()}));
                this.setErrors(1L);
                this.logError(Const.getStackTracker((Throwable)e));
                this.stopAll();
                this.setOutputDone();
                return false;
            }
            sendToErrorRow = true;
            errorMessage = e.toString();
            if (sendToErrorRow) {
                this.putError(this.getInputRowMeta(), outputRowData, 1L, errorMessage, null, "LdapOutput001");
            }
            return true;
        }
    }

    public boolean init() {
        if (super.init()) {
            try {
                ((LdapOutputData)this.data).connection = new LdapConnection(this.log, (IVariables)this, (ILdapMeta)this.meta, null);
                if (((LdapOutputMeta)this.meta).isUseAuthentication()) {
                    String username = this.resolve(((LdapOutputMeta)this.meta).getUserName());
                    String password = Encr.decryptPasswordOptionallyEncrypted((String)this.resolve(((LdapOutputMeta)this.meta).getPassword()));
                    ((LdapOutputData)this.data).connection.connect(username, password);
                } else {
                    ((LdapOutputData)this.data).connection.connect();
                }
                ((LdapOutputData)this.data).separator = this.resolve(((LdapOutputMeta)this.meta).getMultiValuedSeparator());
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(classFromResourcesPackage, (String)"LdapOutput.Error.Init", (Object[])new Object[]{e}));
                this.stopAll();
                this.setErrors(1L);
                return false;
            }
            return true;
        }
        return false;
    }

    public void dispose() {
        if (((LdapOutputData)this.data).connection != null) {
            try {
                ((LdapOutputData)this.data).connection.close();
            }
            catch (HopException e) {
                this.logError(BaseMessages.getString(classFromResourcesPackage, (String)"LdapOutput.Exception.ErrorDisconecting", (String[])new String[]{e.toString()}));
            }
        }
        super.dispose();
    }
}

