/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.rest;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.rest.Rest;
import org.apache.hop.pipeline.transforms.rest.RestData;
import org.w3c.dom.Node;

@Transform(id="Rest", image="rest.svg", name="i18n::Rest.Name", description="i18n::Rest.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Lookup", keywords={"i18n::RestMeta.keyword"}, documentationUrl="/pipeline/transforms/rest.html")
public class RestMeta
extends BaseTransformMeta<Rest, RestData> {
    private static final Class<?> PKG = RestMeta.class;
    public static final String APPLICATION_TYPE_TEXT_PLAIN = "TEXT PLAIN";
    public static final String APPLICATION_TYPE_XML = "XML";
    public static final String APPLICATION_TYPE_JSON = "JSON";
    public static final String APPLICATION_TYPE_OCTET_STREAM = "OCTET STREAM";
    public static final String APPLICATION_TYPE_XHTML = "XHTML";
    public static final String APPLICATION_TYPE_FORM_URLENCODED = "FORM URLENCODED";
    public static final String APPLICATION_TYPE_ATOM_XML = "ATOM XML";
    public static final String APPLICATION_TYPE_SVG_XML = "SVG XML";
    public static final String APPLICATION_TYPE_TEXT_XML = "TEXT XML";
    public static final String HTTP_METHOD_GET = "GET";
    public static final String HTTP_METHOD_POST = "POST";
    public static final String HTTP_METHOD_PUT = "PUT";
    public static final String HTTP_METHOD_DELETE = "DELETE";
    public static final String HTTP_METHOD_HEAD = "HEAD";
    public static final String HTTP_METHOD_OPTIONS = "OPTIONS";
    public static final String HTTP_METHOD_PATCH = "PATCH";
    public static final String[] APPLICATION_TYPES = new String[]{"TEXT PLAIN", "XML", "JSON", "OCTET STREAM", "XHTML", "FORM URLENCODED", "ATOM XML", "SVG XML", "TEXT XML"};
    public static final String CONST_RESULT = "result";
    public static final String CONST_SPACES_LONG = "        ";
    public static final String CONST_SPACES = "      ";
    public static final String CONST_FIELD = "field";
    private String applicationType;
    public static final String[] HTTP_METHODS = new String[]{"GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS", "PATCH"};
    public static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    public static final int DEFAULT_READ_TIMEOUT = 10000;
    private String url;
    private boolean urlInField;
    private String urlField;
    private String[] headerField;
    private String[] headerName;
    private String[] parameterField;
    private String[] parameterName;
    private String[] matrixParameterField;
    private String[] matrixParameterName;
    private String fieldName;
    private String resultCodeFieldName;
    private String responseTimeFieldName;
    private String responseHeaderFieldName;
    private String proxyHost;
    private String proxyPort;
    private String httpLogin;
    private String httpPassword;
    private boolean preemptive;
    private String bodyField;
    private String method;
    private boolean dynamicMethod;
    private String methodFieldName;
    private String trustStoreFile;
    private String trustStorePassword;
    private String connectionTimeout;
    private String readTimeout;
    private boolean ignoreSsl;

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String value) {
        this.method = value;
    }

    public String getBodyField() {
        return this.bodyField;
    }

    public void setBodyField(String value) {
        this.bodyField = value;
    }

    public String[] getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String[] value) {
        this.headerName = value;
    }

    public String[] getParameterField() {
        return this.parameterField;
    }

    public void setParameterField(String[] value) {
        this.parameterField = value;
    }

    public String[] getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(String[] value) {
        this.parameterName = value;
    }

    public String[] getMatrixParameterField() {
        return this.matrixParameterField;
    }

    public void setMatrixParameterField(String[] value) {
        this.matrixParameterField = value;
    }

    public String[] getMatrixParameterName() {
        return this.matrixParameterName;
    }

    public void setMatrixParameterName(String[] value) {
        this.matrixParameterName = value;
    }

    public String[] getHeaderField() {
        return this.headerField;
    }

    public void setHeaderField(String[] value) {
        this.headerField = value;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String procedure) {
        this.url = procedure;
    }

    public boolean isUrlInField() {
        return this.urlInField;
    }

    public void setUrlInField(boolean urlInField) {
        this.urlInField = urlInField;
    }

    public boolean isPreemptive() {
        return this.preemptive;
    }

    public void setPreemptive(boolean preemptive) {
        this.preemptive = preemptive;
    }

    public boolean isDynamicMethod() {
        return this.dynamicMethod;
    }

    public void setDynamicMethod(boolean dynamicMethod) {
        this.dynamicMethod = dynamicMethod;
    }

    public String getMethodFieldName() {
        return this.methodFieldName;
    }

    public void setMethodFieldName(String methodFieldName) {
        this.methodFieldName = methodFieldName;
    }

    public String getUrlField() {
        return this.urlField;
    }

    public void setUrlField(String urlField) {
        this.urlField = urlField;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String resultName) {
        this.fieldName = resultName;
    }

    public boolean isIgnoreSsl() {
        return this.ignoreSsl;
    }

    public void setIgnoreSsl(boolean ignoreSsl) {
        this.ignoreSsl = ignoreSsl;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode, metadataProvider);
    }

    public void allocate(int nrheaders, int nrparamers, int nrmatrixparameters) {
        this.headerField = new String[nrheaders];
        this.headerName = new String[nrheaders];
        this.parameterField = new String[nrparamers];
        this.parameterName = new String[nrparamers];
        this.matrixParameterField = new String[nrmatrixparameters];
        this.matrixParameterName = new String[nrmatrixparameters];
    }

    public Object clone() {
        RestMeta retval = (RestMeta)((Object)super.clone());
        int nrheaders = this.headerName.length;
        int nrparameters = this.parameterField.length;
        int nrmatrixparameters = this.matrixParameterField.length;
        retval.allocate(nrheaders, nrparameters, nrmatrixparameters);
        System.arraycopy(this.headerField, 0, retval.headerField, 0, nrheaders);
        System.arraycopy(this.headerName, 0, retval.headerName, 0, nrheaders);
        System.arraycopy(this.parameterField, 0, retval.parameterField, 0, nrparameters);
        System.arraycopy(this.parameterName, 0, retval.parameterName, 0, nrparameters);
        System.arraycopy(this.matrixParameterField, 0, retval.matrixParameterField, 0, nrmatrixparameters);
        System.arraycopy(this.matrixParameterName, 0, retval.matrixParameterName, 0, nrmatrixparameters);
        return retval;
    }

    public void setDefault() {
        this.allocate(0, 0, 0);
        this.fieldName = CONST_RESULT;
        this.resultCodeFieldName = "";
        this.responseTimeFieldName = "";
        this.responseHeaderFieldName = "";
        this.method = HTTP_METHOD_GET;
        this.dynamicMethod = false;
        this.methodFieldName = null;
        this.preemptive = false;
        this.trustStoreFile = null;
        this.trustStorePassword = null;
        this.applicationType = APPLICATION_TYPE_TEXT_PLAIN;
        this.readTimeout = String.valueOf(10000);
        this.connectionTimeout = String.valueOf(10000);
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        String headerFieldName;
        ValueMetaString v;
        if (!Utils.isEmpty((CharSequence)this.fieldName)) {
            v = new ValueMetaString(variables.resolve(this.fieldName));
            v.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)this.resultCodeFieldName)) {
            v = new ValueMetaInteger(variables.resolve(this.resultCodeFieldName));
            v.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)this.responseTimeFieldName)) {
            v = new ValueMetaInteger(variables.resolve(this.responseTimeFieldName));
            v.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)(headerFieldName = variables.resolve(this.responseHeaderFieldName)))) {
            ValueMetaString v2 = new ValueMetaString(headerFieldName);
            v2.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)v2);
        }
    }

    public String getXml() {
        int i;
        int len;
        StringBuilder retval = new StringBuilder();
        retval.append("    ").append(XmlHandler.addTagValue((String)"applicationType", (String)this.applicationType));
        retval.append("    ").append(XmlHandler.addTagValue((String)"method", (String)this.method));
        retval.append("    ").append(XmlHandler.addTagValue((String)"url", (String)this.url));
        retval.append("    ").append(XmlHandler.addTagValue((String)"urlInField", (boolean)this.urlInField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"dynamicMethod", (boolean)this.dynamicMethod));
        retval.append("    ").append(XmlHandler.addTagValue((String)"methodFieldName", (String)this.methodFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"urlField", (String)this.urlField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"bodyField", (String)this.bodyField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"httpLogin", (String)this.httpLogin));
        retval.append("    ").append(XmlHandler.addTagValue((String)"readTimeout", (String)this.readTimeout));
        retval.append("    ").append(XmlHandler.addTagValue((String)"connectionTimeout", (String)this.connectionTimeout));
        retval.append("    ").append(XmlHandler.addTagValue((String)"httpPassword", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.httpPassword)));
        retval.append("    ").append(XmlHandler.addTagValue((String)"proxyHost", (String)this.proxyHost));
        retval.append("    ").append(XmlHandler.addTagValue((String)"proxyPort", (String)this.proxyPort));
        retval.append("    ").append(XmlHandler.addTagValue((String)"preemptive", (boolean)this.preemptive));
        retval.append("    ").append(XmlHandler.addTagValue((String)"trustStoreFile", (String)this.trustStoreFile));
        retval.append("    ").append(XmlHandler.addTagValue((String)"trustStorePassword", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.trustStorePassword)));
        retval.append("    ").append(XmlHandler.addTagValue((String)"ignoreSsl", (boolean)this.ignoreSsl));
        retval.append("    <headers>").append(Const.CR);
        int n = len = this.headerName != null ? this.headerName.length : 0;
        for (i = 0; i < len; ++i) {
            retval.append("      <header>").append(Const.CR);
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)CONST_FIELD, (String)this.headerField[i]));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"name", (String)this.headerName[i]));
            retval.append("        </header>").append(Const.CR);
        }
        retval.append("      </headers>").append(Const.CR);
        retval.append("    <parameters>").append(Const.CR);
        int n2 = len = this.parameterName != null ? this.parameterName.length : 0;
        for (i = 0; i < len; ++i) {
            retval.append("      <parameter>").append(Const.CR);
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)CONST_FIELD, (String)this.parameterField[i]));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"name", (String)this.parameterName[i]));
            retval.append("        </parameter>").append(Const.CR);
        }
        retval.append("      </parameters>").append(Const.CR);
        retval.append("    <matrixParameters>").append(Const.CR);
        int n3 = len = this.matrixParameterName != null ? this.matrixParameterName.length : 0;
        for (i = 0; i < len; ++i) {
            retval.append("      <matrixParameter>").append(Const.CR);
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)CONST_FIELD, (String)this.matrixParameterField[i]));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"name", (String)this.matrixParameterName[i]));
            retval.append("        </matrixParameter>").append(Const.CR);
        }
        retval.append("      </matrixParameters>").append(Const.CR);
        retval.append("    <result>").append(Const.CR);
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"name", (String)this.fieldName));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"code", (String)this.resultCodeFieldName));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"response_time", (String)this.responseTimeFieldName));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"response_header", (String)this.responseHeaderFieldName));
        retval.append("      </result>").append(Const.CR);
        return retval.toString();
    }

    private void readData(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            Node anode;
            int i;
            this.applicationType = XmlHandler.getTagValue((Node)transformNode, (String)"applicationType");
            this.method = XmlHandler.getTagValue((Node)transformNode, (String)"method");
            this.url = XmlHandler.getTagValue((Node)transformNode, (String)"url");
            this.urlInField = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"urlInField"));
            this.methodFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"methodFieldName");
            this.dynamicMethod = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"dynamicMethod"));
            this.urlField = XmlHandler.getTagValue((Node)transformNode, (String)"urlField");
            this.bodyField = XmlHandler.getTagValue((Node)transformNode, (String)"bodyField");
            this.readTimeout = XmlHandler.getTagValue((Node)transformNode, (String)"readTimeout");
            this.connectionTimeout = XmlHandler.getTagValue((Node)transformNode, (String)"connectionTimeout");
            this.httpLogin = XmlHandler.getTagValue((Node)transformNode, (String)"httpLogin");
            this.httpPassword = Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)transformNode, (String)"httpPassword"));
            this.proxyHost = XmlHandler.getTagValue((Node)transformNode, (String)"proxyHost");
            this.proxyPort = XmlHandler.getTagValue((Node)transformNode, (String)"proxyPort");
            this.preemptive = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"preemptive"));
            this.trustStoreFile = XmlHandler.getTagValue((Node)transformNode, (String)"trustStoreFile");
            this.trustStorePassword = Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)transformNode, (String)"trustStorePassword"));
            this.ignoreSsl = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"ignoreSsl"));
            Node headernode = XmlHandler.getSubNode((Node)transformNode, (String)"headers");
            int nrheaders = XmlHandler.countNodes((Node)headernode, (String)"header");
            Node paramnode = XmlHandler.getSubNode((Node)transformNode, (String)"parameters");
            int nrparameters = XmlHandler.countNodes((Node)paramnode, (String)"parameter");
            Node matrixparamnode = XmlHandler.getSubNode((Node)transformNode, (String)"matrixParameters");
            int nrmatrixparameters = XmlHandler.countNodes((Node)matrixparamnode, (String)"matrixParameter");
            this.allocate(nrheaders, nrparameters, nrmatrixparameters);
            for (i = 0; i < nrheaders; ++i) {
                anode = XmlHandler.getSubNodeByNr((Node)headernode, (String)"header", (int)i);
                this.headerField[i] = XmlHandler.getTagValue((Node)anode, (String)CONST_FIELD);
                this.headerName[i] = XmlHandler.getTagValue((Node)anode, (String)"name");
            }
            for (i = 0; i < nrparameters; ++i) {
                anode = XmlHandler.getSubNodeByNr((Node)paramnode, (String)"parameter", (int)i);
                this.parameterField[i] = XmlHandler.getTagValue((Node)anode, (String)CONST_FIELD);
                this.parameterName[i] = XmlHandler.getTagValue((Node)anode, (String)"name");
            }
            for (i = 0; i < nrmatrixparameters; ++i) {
                anode = XmlHandler.getSubNodeByNr((Node)matrixparamnode, (String)"matrixParameter", (int)i);
                this.matrixParameterField[i] = XmlHandler.getTagValue((Node)anode, (String)CONST_FIELD);
                this.matrixParameterName[i] = XmlHandler.getTagValue((Node)anode, (String)"name");
            }
            this.fieldName = XmlHandler.getTagValue((Node)transformNode, (String)CONST_RESULT, (String)"name");
            this.resultCodeFieldName = XmlHandler.getTagValue((Node)transformNode, (String)CONST_RESULT, (String)"code");
            this.responseTimeFieldName = XmlHandler.getTagValue((Node)transformNode, (String)CONST_RESULT, (String)"response_time");
            this.responseHeaderFieldName = XmlHandler.getTagValue((Node)transformNode, (String)CONST_RESULT, (String)"response_header");
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"RestMeta.Exception.UnableToReadTransformMeta", (String[])new String[0]), (Throwable)e);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = this.urlInField ? (Utils.isEmpty((CharSequence)this.urlField) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.UrlfieldMissing", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.UrlfieldOk", (String[])new String[0]), (ICheckResultSource)transformMeta)) : (Utils.isEmpty((CharSequence)this.url) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.UrlMissing", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.UrlOk", (String[])new String[0]), (ICheckResultSource)transformMeta));
        remarks.add((ICheckResult)cr);
        cr = this.dynamicMethod ? (Utils.isEmpty((CharSequence)this.methodFieldName) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.MethodFieldMissing", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.MethodFieldOk", (String[])new String[0]), (ICheckResultSource)transformMeta)) : (Utils.isEmpty((CharSequence)this.method) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.MethodMissing", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.MethodOk", (String[])new String[0]), (ICheckResultSource)transformMeta));
        remarks.add((ICheckResult)cr);
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public String getResultCodeFieldName() {
        return this.resultCodeFieldName;
    }

    public void setResultCodeFieldName(String resultCodeFieldName) {
        this.resultCodeFieldName = resultCodeFieldName;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setApplicationType(String applicationType) {
        this.applicationType = applicationType;
    }

    public String getApplicationType() {
        return this.applicationType;
    }

    public void setHttpLogin(String httpLogin) {
        this.httpLogin = httpLogin;
    }

    public String getHttpLogin() {
        return this.httpLogin;
    }

    public void setHttpPassword(String httpPassword) {
        this.httpPassword = httpPassword;
    }

    public String getHttpPassword() {
        return this.httpPassword;
    }

    public void setTrustStoreFile(String trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
    }

    public String getTrustStoreFile() {
        return this.trustStoreFile;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public String getResponseTimeFieldName() {
        return this.responseTimeFieldName;
    }

    public void setResponseTimeFieldName(String responseTimeFieldName) {
        this.responseTimeFieldName = responseTimeFieldName;
    }

    public String getResponseHeaderFieldName() {
        return this.responseHeaderFieldName;
    }

    public void setResponseHeaderFieldName(String responseHeaderFieldName) {
        this.responseHeaderFieldName = responseHeaderFieldName;
    }

    public static boolean isActiveBody(String method) {
        if (Utils.isEmpty((CharSequence)method)) {
            return false;
        }
        return method.equals(HTTP_METHOD_POST) || method.equals(HTTP_METHOD_PUT) || method.equals(HTTP_METHOD_PATCH);
    }

    public static boolean isActiveParameters(String method) {
        if (Utils.isEmpty((CharSequence)method)) {
            return false;
        }
        return method.equals(HTTP_METHOD_GET) || method.equals(HTTP_METHOD_POST) || method.equals(HTTP_METHOD_PUT) || method.equals(HTTP_METHOD_PATCH) || method.equals(HTTP_METHOD_DELETE);
    }

    public String getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(String timeout) {
        this.connectionTimeout = timeout;
    }

    public String getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(String timeout) {
        this.readTimeout = timeout;
    }
}

