/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.salesforceinput;

import com.sforce.ws.util.Base64;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceRecordValue;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceTransform;
import org.apache.hop.pipeline.transforms.salesforceinput.SalesforceInputData;
import org.apache.hop.pipeline.transforms.salesforceinput.SalesforceInputField;
import org.apache.hop.pipeline.transforms.salesforceinput.SalesforceInputMeta;

public class SalesforceInput
extends SalesforceTransform<SalesforceInputMeta, SalesforceInputData> {
    private static final Class<?> PKG = SalesforceInputMeta.class;

    public SalesforceInput(TransformMeta transformMeta, SalesforceInputMeta meta, SalesforceInputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, meta, data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        if (this.first) {
            this.first = false;
            ((SalesforceInputData)this.data).outputRowMeta = new RowMeta();
            ((SalesforceInputMeta)this.meta).getFields(((SalesforceInputData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((SalesforceInputData)this.data).convertRowMeta = ((SalesforceInputData)this.data).outputRowMeta.cloneToType(2);
            ((SalesforceInputData)this.data).connection.query(((SalesforceInputMeta)this.meta).isSpecifyQuery());
            ((SalesforceInputData)this.data).limitReached = true;
            ((SalesforceInputData)this.data).recordcount = ((SalesforceInputData)this.data).connection.getQueryResultSize();
            if (((SalesforceInputData)this.data).recordcount > 0) {
                ((SalesforceInputData)this.data).limitReached = false;
                ((SalesforceInputData)this.data).nrRecords = ((SalesforceInputData)this.data).connection.getRecordsCount();
            }
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceInput.Log.RecordCount", (String[])new String[0]) + " : " + ((SalesforceInputData)this.data).recordcount);
            }
        }
        Object[] outputRowData = null;
        try {
            outputRowData = this.getOneRow();
            if (outputRowData == null) {
                this.setOutputDone();
                return false;
            }
            this.putRow(((SalesforceInputData)this.data).outputRowMeta, outputRowData);
            if (this.checkFeedback(this.getLinesInput()) && this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceInput.log.LineRow", (String[])new String[]{"" + this.getLinesInput()}));
            }
            ++((SalesforceInputData)this.data).rownr;
            ++((SalesforceInputData)this.data).recordIndex;
            return true;
        }
        catch (HopException e) {
            boolean sendToErrorRow = false;
            String errorMessage = null;
            if (!this.getTransformMeta().isDoingErrorHandling()) {
                this.logError(BaseMessages.getString(PKG, (String)"SalesforceInput.log.Exception", (String[])new String[]{e.getMessage()}));
                this.logError(Const.getStackTracker((Throwable)e));
                this.setErrors(1L);
                this.stopAll();
                this.setOutputDone();
                return false;
            }
            sendToErrorRow = true;
            errorMessage = e.toString();
            if (sendToErrorRow) {
                this.putError(this.getInputRowMeta(), outputRowData, 1L, errorMessage, null, "SalesforceInput001");
            }
            return true;
        }
    }

    private Object[] getOneRow() throws HopException {
        if (((SalesforceInputData)this.data).limitReached || ((SalesforceInputData)this.data).rownr >= (long)((SalesforceInputData)this.data).recordcount) {
            return null;
        }
        Object[] outputRowData = this.buildEmptyRow();
        try {
            if (((SalesforceInputData)this.data).limit > 0L && ((SalesforceInputData)this.data).rownr >= ((SalesforceInputData)this.data).limit) {
                ((SalesforceInputData)this.data).limitReached = true;
                return null;
            }
            if ((((SalesforceInputData)this.data).rownr >= (long)((SalesforceInputData)this.data).nrRecords || ((SalesforceInputData)this.data).finishedRecord) && ((SalesforceInputMeta)this.meta).getRecordsFilter() != 1) {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceInput.Log.NeedQueryMore", (String[])new String[]{"" + ((SalesforceInputData)this.data).rownr}));
                }
                if (((SalesforceInputData)this.data).connection.queryMore()) {
                    int nr = ((SalesforceInputData)this.data).connection.getRecordsCount();
                    ((SalesforceInputData)this.data).nrRecords += nr;
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceInput.Log.QueryMoreRetrieved", (String[])new String[]{"" + nr}));
                    }
                    ((SalesforceInputData)this.data).recordIndex = 0;
                    ((SalesforceInputData)this.data).finishedRecord = false;
                } else {
                    return null;
                }
            }
            SalesforceRecordValue srvalue = ((SalesforceInputData)this.data).connection.getRecord(((SalesforceInputData)this.data).recordIndex);
            ((SalesforceInputData)this.data).finishedRecord = srvalue.isAllRecordsProcessed();
            if (((SalesforceInputMeta)this.meta).getRecordsFilter() == 2) {
                if (srvalue.isRecordIndexChanges()) {
                    ((SalesforceInputData)this.data).recordIndex = srvalue.getRecordIndex();
                }
                if (((SalesforceInputData)this.data).finishedRecord && srvalue.getRecordValue() == null) {
                    return null;
                }
            }
            for (int i = 0; i < ((SalesforceInputData)this.data).nrFields; ++i) {
                String value = ((SalesforceInputData)this.data).connection.getRecordValue(srvalue.getRecordValue(), ((SalesforceInputMeta)this.meta).getInputFields()[i].getField());
                switch (((SalesforceInputMeta)this.meta).getInputFields()[i].getTrimType()) {
                    case 1: {
                        value = Const.ltrim((String)value);
                        break;
                    }
                    case 2: {
                        value = Const.rtrim((String)value);
                        break;
                    }
                    case 3: {
                        value = Const.trim((String)value);
                        break;
                    }
                }
                this.doConversions(outputRowData, i, value);
                if (!((SalesforceInputMeta)this.meta).getInputFields()[i].isRepeated() || ((SalesforceInputData)this.data).previousRow == null || !Utils.isEmpty((CharSequence)value)) continue;
                outputRowData[i] = ((SalesforceInputData)this.data).previousRow[i];
            }
            int rowIndex = ((SalesforceInputData)this.data).nrFields;
            if (((SalesforceInputMeta)this.meta).includeTargetURL() && !Utils.isEmpty((CharSequence)((SalesforceInputMeta)this.meta).getTargetURLField())) {
                outputRowData[rowIndex++] = ((SalesforceInputData)this.data).connection.getURL();
            }
            if (((SalesforceInputMeta)this.meta).includeModule() && !Utils.isEmpty((CharSequence)((SalesforceInputMeta)this.meta).getModuleField())) {
                outputRowData[rowIndex++] = ((SalesforceInputData)this.data).connection.getModule();
            }
            if (((SalesforceInputMeta)this.meta).includeSQL() && !Utils.isEmpty((CharSequence)((SalesforceInputMeta)this.meta).getSQLField())) {
                outputRowData[rowIndex++] = ((SalesforceInputData)this.data).connection.getSQL();
            }
            if (((SalesforceInputMeta)this.meta).includeTimestamp() && !Utils.isEmpty((CharSequence)((SalesforceInputMeta)this.meta).getTimestampField())) {
                outputRowData[rowIndex++] = ((SalesforceInputData)this.data).connection.getServerTimestamp();
            }
            if (((SalesforceInputMeta)this.meta).includeRowNumber() && !Utils.isEmpty((CharSequence)((SalesforceInputMeta)this.meta).getRowNumberField())) {
                outputRowData[rowIndex++] = ((SalesforceInputData)this.data).rownr;
            }
            if (((SalesforceInputMeta)this.meta).includeDeletionDate() && !Utils.isEmpty((CharSequence)((SalesforceInputMeta)this.meta).getDeletionDateField())) {
                outputRowData[rowIndex++] = srvalue.getDeletionDate();
            }
            IRowMeta irow = this.getInputRowMeta();
            ((SalesforceInputData)this.data).previousRow = irow == null ? outputRowData : irow.cloneRow(outputRowData);
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceInput.Exception.CanNotReadFromSalesforce", (String[])new String[0]), (Throwable)e);
        }
        return outputRowData;
    }

    void doConversions(Object[] outputRowData, int i, String value) throws HopValueException {
        IValueMeta targetValueMeta = ((SalesforceInputData)this.data).outputRowMeta.getValueMeta(i);
        IValueMeta sourceValueMeta = ((SalesforceInputData)this.data).convertRowMeta.getValueMeta(i);
        outputRowData[i] = 8 != targetValueMeta.getType() ? targetValueMeta.convertData(sourceValueMeta, (Object)value) : (value != null ? (Object)Base64.decode((byte[])value.getBytes()) : null);
    }

    private String BuiltSOQl() {
        Object sql = "";
        SalesforceInputField[] fields = ((SalesforceInputMeta)this.meta).getInputFields();
        switch (((SalesforceInputMeta)this.meta).getRecordsFilter()) {
            case 1: {
                for (int i = 0; i < ((SalesforceInputData)this.data).nrFields; ++i) {
                    SalesforceInputField field = fields[i];
                    sql = (String)sql + this.resolve(field.getField());
                    if (i >= ((SalesforceInputData)this.data).nrFields - 1) continue;
                    sql = (String)sql + ",";
                }
                break;
            }
            case 2: {
                sql = (String)sql + "SELECT ";
                for (int i = 0; i < ((SalesforceInputData)this.data).nrFields; ++i) {
                    SalesforceInputField field = fields[i];
                    sql = (String)sql + this.resolve(field.getField());
                    if (i >= ((SalesforceInputData)this.data).nrFields - 1) continue;
                    sql = (String)sql + ",";
                }
                sql = (String)sql + " FROM " + this.resolve(((SalesforceInputMeta)this.meta).getModule()) + " WHERE isDeleted = true";
                break;
            }
            default: {
                sql = (String)sql + "SELECT ";
                for (int i = 0; i < ((SalesforceInputData)this.data).nrFields; ++i) {
                    SalesforceInputField field = fields[i];
                    sql = (String)sql + this.resolve(field.getField());
                    if (i >= ((SalesforceInputData)this.data).nrFields - 1) continue;
                    sql = (String)sql + ",";
                }
                sql = (String)sql + " FROM " + this.resolve(((SalesforceInputMeta)this.meta).getModule());
                if (Utils.isEmpty((CharSequence)this.resolve(((SalesforceInputMeta)this.meta).getCondition()))) break;
                sql = (String)sql + " WHERE " + this.resolve(((SalesforceInputMeta)this.meta).getCondition().replace("\n\r", "").replace("\n", ""));
            }
        }
        return sql;
    }

    private Object[] buildEmptyRow() {
        return RowDataUtil.allocateRowData((int)((SalesforceInputData)this.data).outputRowMeta.size());
    }

    @Override
    public boolean init() {
        if (super.init()) {
            ((SalesforceInputData)this.data).nrFields = ((SalesforceInputMeta)this.meta).getInputFields().length;
            if (((SalesforceInputData)this.data).nrFields == 0) {
                this.log.logError(BaseMessages.getString(PKG, (String)"SalesforceInputDialog.FieldsMissing.DialogMessage", (String[])new String[0]));
                return false;
            }
            String soSQL = this.resolve(((SalesforceInputMeta)this.meta).getQuery());
            try {
                if (((SalesforceInputMeta)this.meta).isSpecifyQuery()) {
                    if (Utils.isEmpty((CharSequence)soSQL)) {
                        this.log.logError(BaseMessages.getString(PKG, (String)"SalesforceInputDialog.QueryMissing.DialogMessage", (String[])new String[0]));
                        return false;
                    }
                } else if (((SalesforceInputMeta)this.meta).getRecordsFilter() != 0) {
                    String realFromDateString = this.resolve(((SalesforceInputMeta)this.meta).getReadFrom());
                    if (Utils.isEmpty((CharSequence)realFromDateString)) {
                        this.log.logError(BaseMessages.getString(PKG, (String)"SalesforceInputDialog.FromDateMissing.DialogMessage", (String[])new String[0]));
                        return false;
                    }
                    String realToDateString = this.resolve(((SalesforceInputMeta)this.meta).getReadTo());
                    if (Utils.isEmpty((CharSequence)realToDateString)) {
                        this.log.logError(BaseMessages.getString(PKG, (String)"SalesforceInputDialog.ToDateMissing.DialogMessage", (String[])new String[0]));
                        return false;
                    }
                    try {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        ((SalesforceInputData)this.data).startCal = new GregorianCalendar();
                        ((SalesforceInputData)this.data).startCal.setTime(dateFormat.parse(realFromDateString));
                        ((SalesforceInputData)this.data).endCal = new GregorianCalendar();
                        ((SalesforceInputData)this.data).endCal.setTime(dateFormat.parse(realToDateString));
                        dateFormat = null;
                    }
                    catch (Exception e) {
                        this.log.logError(BaseMessages.getString(PKG, (String)"SalesforceInput.ErrorParsingDate", (String[])new String[0]), (Throwable)e);
                        return false;
                    }
                }
                ((SalesforceInputData)this.data).limit = Const.toLong((String)this.resolve(((SalesforceInputMeta)this.meta).getRowLimit()), (long)0L);
                ((SalesforceInputData)this.data).connection.setQueryAll(((SalesforceInputMeta)this.meta).isQueryAll());
                if (((SalesforceInputMeta)this.meta).isSpecifyQuery()) {
                    ((SalesforceInputData)this.data).connection.setSQL(soSQL.replace("\n\r", " ").replace("\n", " "));
                } else {
                    if (((SalesforceInputMeta)this.meta).getRecordsFilter() != 0) {
                        ((SalesforceInputData)this.data).connection.setCalendar(((SalesforceInputMeta)this.meta).getRecordsFilter(), ((SalesforceInputData)this.data).startCal, ((SalesforceInputData)this.data).endCal);
                    }
                    if (((SalesforceInputMeta)this.meta).getRecordsFilter() == 1) {
                        ((SalesforceInputData)this.data).connection.setFieldsList(this.BuiltSOQl());
                    } else {
                        ((SalesforceInputData)this.data).connection.setSQL(this.BuiltSOQl());
                    }
                }
                ((SalesforceInputData)this.data).connection.connect();
                return true;
            }
            catch (HopException ke) {
                this.logError(BaseMessages.getString(PKG, (String)"SalesforceInput.Log.ErrorOccurredDuringTransformInitialize", (String[])new String[0]) + ke.getMessage());
                return false;
            }
        }
        return false;
    }

    @Override
    public void dispose() {
        if (((SalesforceInputData)this.data).outputRowMeta != null) {
            ((SalesforceInputData)this.data).outputRowMeta = null;
        }
        if (((SalesforceInputData)this.data).convertRowMeta != null) {
            ((SalesforceInputData)this.data).convertRowMeta = null;
        }
        if (((SalesforceInputData)this.data).previousRow != null) {
            ((SalesforceInputData)this.data).previousRow = null;
        }
        if (((SalesforceInputData)this.data).startCal != null) {
            ((SalesforceInputData)this.data).startCal = null;
        }
        if (((SalesforceInputData)this.data).endCal != null) {
            ((SalesforceInputData)this.data).endCal = null;
        }
        super.dispose();
    }
}

