/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.construction;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.construction.PTransformTranslation;
import org.apache.beam.sdk.util.construction.SdkComponents;
import org.apache.beam.sdk.util.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.sdk.util.construction.WindowingStrategyTranslation;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class WindowIntoTranslation {
    public static  @UnknownKeyFor @NonNull @Initialized RunnerApi.WindowIntoPayload toProto(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Window.Assign<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> transform, @UnknownKeyFor @NonNull @Initialized SdkComponents components) {
        return RunnerApi.WindowIntoPayload.newBuilder().setWindowFn(WindowingStrategyTranslation.toProto(transform.getWindowFn(), components)).build();
    }

    public static  @UnknownKeyFor @NonNull @Initialized RunnerApi.WindowIntoPayload getWindowIntoPayload(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) {
        RunnerApi.PTransform transformProto;
        try {
            SdkComponents components = SdkComponents.create(application.getPipeline().getOptions());
            transformProto = PTransformTranslation.toProto(application, Collections.emptyList(), components);
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
        Preconditions.checkArgument((boolean)"beam:transform:window_into:v1".equals(transformProto.getSpec().getUrn()), (String)"Illegal attempt to extract %s from transform %s with name \"%s\" and URN \"%s\"", (Object)Window.Assign.class.getSimpleName(), application.getTransform(), (Object)application.getFullName(), (Object)transformProto.getSpec().getUrn());
        try {
            return RunnerApi.WindowIntoPayload.parseFrom(transformProto.getSpec().getPayload());
        }
        catch (InvalidProtocolBufferException exc) {
            throw new IllegalStateException(String.format("%s translated %s with URN '%s' but payload was not a %s", PTransformTranslation.class.getSimpleName(), application, "beam:transform:window_into:v1", RunnerApi.WindowIntoPayload.class.getSimpleName()), exc);
        }
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized WindowFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getWindowFn(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) {
        return WindowingStrategyTranslation.windowFnFromProto(WindowIntoTranslation.getWindowIntoPayload(application).getWindowFn());
    }

    @AutoService(value={TransformPayloadTranslatorRegistrar.class})
    public static class Registrar
    implements TransformPayloadTranslatorRegistrar {
        @Override
        public @UnknownKeyFor @NonNull @Initialized Map<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PTransform>, @KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return Collections.singletonMap(Window.Assign.class, new WindowIntoPayloadTranslator());
        }
    }

    public static class WindowIntoPayloadTranslator
    implements PTransformTranslation.TransformPayloadTranslator<Window.Assign<?>> {
        public static @UnknownKeyFor @NonNull @Initialized PTransformTranslation.TransformPayloadTranslator create() {
            return new WindowIntoPayloadTranslator();
        }

        private WindowIntoPayloadTranslator() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getUrn() {
            return "beam:transform:window_into:v1";
        }

        @Override
        public  @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec translate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized Window.Assign<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> transform, @UnknownKeyFor @NonNull @Initialized SdkComponents components) {
            RunnerApi.WindowIntoPayload payload = WindowIntoTranslation.toProto(transform.getTransform(), components);
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn(transform.getTransform())).setPayload(payload.toByteString()).build();
        }
    }

    static class WindowAssignTranslator
    implements PTransformTranslation.TransformPayloadTranslator<Window.Assign<?>> {
        WindowAssignTranslator() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getUrn() {
            return "beam:transform:window_into:v1";
        }

        @Override
        public  @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec translate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized Window.Assign<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> transform, @UnknownKeyFor @NonNull @Initialized SdkComponents components) {
            return RunnerApi.FunctionSpec.newBuilder().setUrn("beam:transform:window:v1").setPayload(WindowIntoTranslation.toProto(transform.getTransform(), components).toByteString()).build();
        }
    }
}

