/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.parquet.transforms.output;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.commons.vfs2.FileObject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hop.core.Const;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.parquet.transforms.output.ParquetField;
import org.apache.hop.parquet.transforms.output.ParquetOutputData;
import org.apache.hop.parquet.transforms.output.ParquetOutputFile;
import org.apache.hop.parquet.transforms.output.ParquetOutputMeta;
import org.apache.hop.parquet.transforms.output.ParquetWriterBuilder;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.schema.MessageType;

public class ParquetOutput
extends BaseTransform<ParquetOutputMeta, ParquetOutputData> {
    public ParquetOutput(TransformMeta transformMeta, ParquetOutputMeta meta, ParquetOutputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean init() {
        ((ParquetOutputData)this.data).pageSize = Const.toInt((String)this.resolve(((ParquetOutputMeta)this.meta).getDataPageSize()), (int)0x100000);
        ((ParquetOutputData)this.data).dictionaryPageSize = Const.toInt((String)this.resolve(((ParquetOutputMeta)this.meta).getDictionaryPageSize()), (int)0x100000);
        ((ParquetOutputData)this.data).rowGroupSize = Const.toInt((String)this.resolve(((ParquetOutputMeta)this.meta).getRowGroupSize()), (int)20000);
        ((ParquetOutputData)this.data).maxSplitSizeRows = Const.toLong((String)this.resolve(((ParquetOutputMeta)this.meta).getFileSplitSize()), (long)-1L);
        return super.init();
    }

    public boolean processRow() throws HopException {
        Object[] row = this.getRow();
        if (row == null && this.first) {
            this.logBasic("No rows found for processing, stopping transform");
            this.setOutputDone();
            return false;
        }
        if (row == null) {
            this.closeFile();
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((ParquetOutputData)this.data).sourceFieldIndexes = new ArrayList();
            for (int i = 0; i < ((ParquetOutputMeta)this.meta).getFields().size(); ++i) {
                ParquetField field = ((ParquetOutputMeta)this.meta).getFields().get(i);
                int index = this.getInputRowMeta().indexOfValue(field.getSourceFieldName());
                if (index < 0) {
                    throw new HopException("Unable to find source field '" + field.getSourceFieldName());
                }
                ((ParquetOutputData)this.data).sourceFieldIndexes.add(index);
            }
            this.openNewFile();
        }
        if (((ParquetOutputMeta)this.meta).isFilenameIncludingSplitNr() && ((ParquetOutputData)this.data).maxSplitSizeRows > 0L && ((ParquetOutputData)this.data).splitRowCount >= ((ParquetOutputData)this.data).maxSplitSizeRows) {
            this.closeFile();
            this.openNewFile();
        }
        try {
            ((ParquetOutputData)this.data).writer.write((Object)new RowMetaAndData(this.getInputRowMeta(), row));
            this.incrementLinesOutput();
            ++((ParquetOutputData)this.data).splitRowCount;
        }
        catch (Exception e) {
            throw new HopException("Error writing row to parquet file", (Throwable)e);
        }
        this.putRow(this.getInputRowMeta(), row);
        return true;
    }

    private void openNewFile() throws HopException {
        ((ParquetOutputData)this.data).splitRowCount = 0L;
        ++((ParquetOutputData)this.data).split;
        ((ParquetOutputData)this.data).conf = new Configuration();
        ParquetProperties.Builder builder = ParquetProperties.builder();
        switch (((ParquetOutputMeta)this.meta).getVersion()) {
            case Version1: {
                builder = builder.withWriterVersion(ParquetProperties.WriterVersion.PARQUET_1_0);
                break;
            }
            case Version2: {
                builder = builder.withWriterVersion(ParquetProperties.WriterVersion.PARQUET_2_0);
            }
        }
        ((ParquetOutputData)this.data).props = builder.build();
        SchemaBuilder.FieldAssembler fieldAssembler = SchemaBuilder.record((String)"ApacheHopParquetSchema").fields();
        block14: for (int i = 0; i < ((ParquetOutputMeta)this.meta).getFields().size(); ++i) {
            ParquetField field = ((ParquetOutputMeta)this.meta).getFields().get(i);
            IValueMeta valueMeta = this.getInputRowMeta().getValueMeta(((ParquetOutputData)this.data).sourceFieldIndexes.get(i).intValue());
            SchemaBuilder.BaseFieldTypeBuilder fieldBuilder = fieldAssembler.name(field.getTargetFieldName()).type().nullable();
            switch (valueMeta.getType()) {
                case 3: {
                    Schema timestampMilliType = LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
                    fieldAssembler = ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)fieldAssembler.name(field.getTargetFieldName()).type().unionOf().nullType().and().type(timestampMilliType)).endUnion()).noDefault();
                    continue block14;
                }
                case 5: {
                    fieldAssembler = fieldBuilder.longType().noDefault();
                    continue block14;
                }
                case 1: {
                    fieldAssembler = fieldBuilder.doubleType().noDefault();
                    continue block14;
                }
                case 4: {
                    fieldAssembler = fieldBuilder.booleanType().noDefault();
                    continue block14;
                }
                case 2: 
                case 6: {
                    fieldAssembler = fieldBuilder.stringType().noDefault();
                    continue block14;
                }
                case 8: {
                    fieldAssembler = fieldBuilder.bytesType().noDefault();
                    continue block14;
                }
                default: {
                    throw new HopException("Writing Hop data type '" + valueMeta.getTypeDesc() + "' to Parquet is not supported");
                }
            }
        }
        ((ParquetOutputData)this.data).avroSchema = (Schema)fieldAssembler.endRecord();
        MessageType messageType = new AvroSchemaConverter().convert(((ParquetOutputData)this.data).avroSchema);
        ((ParquetOutputData)this.data).filename = this.buildFilename(this.getPipeline().getExecutionStartDate());
        try {
            FileObject parentFolder;
            FileObject fileObject = HopVfs.getFileObject((String)((ParquetOutputData)this.data).filename, (IVariables)this.variables);
            if (((ParquetOutputMeta)this.meta).isFilenameCreatingParentFolders() && (parentFolder = fileObject.getParent()) != null && !parentFolder.exists()) {
                parentFolder.createFolder();
            }
            ((ParquetOutputData)this.data).outputStream = HopVfs.getOutputStream((String)((ParquetOutputData)this.data).filename, (boolean)false, (IVariables)this.variables);
            ((ParquetOutputData)this.data).outputFile = new ParquetOutputFile(((ParquetOutputData)this.data).outputStream);
            ((ParquetOutputData)this.data).writer = ((ParquetWriterBuilder)((ParquetWriterBuilder)((ParquetWriterBuilder)((ParquetWriterBuilder)((ParquetWriterBuilder)((ParquetWriterBuilder)((ParquetWriterBuilder)new ParquetWriterBuilder(messageType, ((ParquetOutputData)this.data).avroSchema, ((ParquetOutputData)this.data).outputFile, ((ParquetOutputData)this.data).sourceFieldIndexes, ((ParquetOutputMeta)this.meta).getFields()).withPageSize(((ParquetOutputData)this.data).pageSize)).withDictionaryPageSize(((ParquetOutputData)this.data).dictionaryPageSize)).withValidation(false)).withCompressionCodec(((ParquetOutputMeta)this.meta).getCompressionCodec())).withRowGroupSize(((ParquetOutputData)this.data).rowGroupSize)).withWriterVersion(((ParquetOutputData)this.data).props.getWriterVersion())).withWriteMode(ParquetFileWriter.Mode.CREATE)).build();
        }
        catch (Exception e) {
            throw new HopException("Unable to create output file '" + ((ParquetOutputData)this.data).filename + "'", (Throwable)e);
        }
    }

    private String buildFilename(Date date) {
        Object filename = this.resolve(((ParquetOutputMeta)this.meta).getFilenameBase());
        if (((ParquetOutputMeta)this.meta).isFilenameIncludingDate()) {
            filename = (String)filename + "-" + new SimpleDateFormat("yyyyMMdd").format(date);
        }
        if (((ParquetOutputMeta)this.meta).isFilenameIncludingTime()) {
            filename = (String)filename + "-" + new SimpleDateFormat("HHmmss").format(date);
        }
        if (((ParquetOutputMeta)this.meta).isFilenameIncludingDateTime()) {
            filename = (String)filename + "-" + new SimpleDateFormat(this.resolve(((ParquetOutputMeta)this.meta).getFilenameDateTimeFormat())).format(date);
        }
        if (((ParquetOutputMeta)this.meta).isFilenameIncludingCopyNr()) {
            filename = (String)filename + "-" + new DecimalFormat("00").format(this.getCopyNr());
        }
        if (((ParquetOutputMeta)this.meta).isFilenameIncludingSplitNr()) {
            filename = (String)filename + "-" + new DecimalFormat("0000").format(((ParquetOutputData)this.data).split);
        }
        if (((ParquetOutputData)this.data).isBeamContext()) {
            filename = (String)filename + "_" + this.log.getLogChannelId() + "_" + ((ParquetOutputData)this.data).getBeamBundleNr();
        }
        filename = (String)filename + "." + Const.NVL((String)this.resolve(((ParquetOutputMeta)this.meta).getFilenameExtension()), (String)"parquet");
        filename = (String)filename + ((ParquetOutputMeta)this.meta).getCompressionCodec().getExtension();
        return filename;
    }

    private void closeFile() throws HopException {
        try {
            ((ParquetOutputData)this.data).writer.close();
        }
        catch (Exception e) {
            throw new HopException("Error closing file " + ((ParquetOutputData)this.data).filename, (Throwable)e);
        }
    }

    public void batchComplete() throws HopException {
        if (!((ParquetOutputData)this.data).isBeamContext()) {
            this.closeFile();
        }
    }

    public void startBundle() throws HopException {
        if (!this.first) {
            this.openNewFile();
        }
    }

    public void finishBundle() throws HopException {
        this.closeFile();
    }
}

