/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.schemamapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.schemamapping.SchemaMapping;
import org.apache.hop.pipeline.transforms.schemamapping.SchemaMappingData;
import org.apache.hop.pipeline.transforms.schemamapping.SchemaMappingField;
import org.apache.hop.staticschema.metadata.SchemaDefinition;
import org.apache.hop.staticschema.util.SchemaDefinitionUtil;

@Transform(id="SchemaMapping", image="schemamapping.svg", name="i18n::SchemaMapping.Name", description="i18n::SchemaMapping.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Mapping", keywords={"i18n::SchemaMappingMeta.keyword"}, documentationUrl="/pipeline/transforms/schemamapping.html")
public class SchemaMappingMeta
extends BaseTransformMeta<SchemaMapping, SchemaMappingData> {
    @HopMetadataProperty
    private String schemaName;
    @HopMetadataProperty(groupKey="mappings", key="mapping", injectionKey="MAPPING_FIELD", injectionGroupKey="MAPPING_FIELDS", injectionGroupDescription="SchemaMappingMeta.Injection.Fields", injectionKeyDescription="SchemaMappingMeta.Injection.Field")
    private List<SchemaMappingField> mappingFieldset;

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public List<SchemaMappingField> getMappingFieldset() {
        return this.mappingFieldset;
    }

    public void setMappingFieldset(List<SchemaMappingField> mappingFieldset) {
        this.mappingFieldset = mappingFieldset;
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        SchemaDefinition sd = new SchemaDefinitionUtil().loadSchemaDefinition(metadataProvider, this.schemaName);
        HashMap<String, String> mappingsMap = new HashMap<String, String>();
        for (SchemaMappingField smf : this.mappingFieldset) {
            mappingsMap.put(smf.getFieldSchemaDefinition(), smf.getFieldStream());
        }
        try {
            RowMeta selectedSchemaRowMeta = new RowMeta();
            for (int i = 0; i < sd.getRowMeta().size(); ++i) {
                IValueMeta v = sd.getRowMeta().getValueMeta(i);
                if (mappingsMap.get(v.getName()) != null) {
                    IValueMeta vInputItem = inputRowMeta.searchValueMeta((String)mappingsMap.get(v.getName()));
                    if (vInputItem != null) {
                        v.setOrigin(vInputItem.getOrigin());
                    }
                } else {
                    v.setOrigin(name);
                }
                selectedSchemaRowMeta.addValueMeta(v);
            }
            inputRowMeta.clear();
            inputRowMeta.addRowMeta((IRowMeta)selectedSchemaRowMeta);
        }
        catch (HopPluginException e) {
            throw new HopTransformException((Throwable)e);
        }
    }

    public void setDefault() {
        this.mappingFieldset = new ArrayList<SchemaMappingField>();
    }
}

