/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.file;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.errorhandling.CompositeFileErrorHandler;
import org.apache.hop.pipeline.transform.errorhandling.FileErrorHandlerContentLineNumber;
import org.apache.hop.pipeline.transform.errorhandling.FileErrorHandlerMissingFiles;
import org.apache.hop.pipeline.transform.errorhandling.IFileErrorHandler;
import org.apache.hop.pipeline.transforms.file.BaseFileField;
import org.apache.hop.pipeline.transforms.file.BaseFileInputAdditionalField;
import org.apache.hop.pipeline.transforms.file.BaseFileInputFiles;
import org.apache.hop.pipeline.transforms.file.BaseFileInputMeta;
import org.apache.hop.pipeline.transforms.file.BaseFileInputTransformData;
import org.apache.hop.pipeline.transforms.file.BaseFileInputTransformUtils;
import org.apache.hop.pipeline.transforms.file.IBaseFileInputReader;
import org.apache.hop.pipeline.transforms.file.IBaseFileInputTransformControl;

public abstract class BaseFileInputTransform<Meta extends BaseFileInputMeta, Data extends BaseFileInputTransformData>
extends BaseTransform<Meta, Data>
implements IBaseFileInputTransformControl {
    private static final Class<?> PKG = BaseFileInputTransform.class;

    protected abstract IBaseFileInputReader createReader(Meta var1, Data var2, FileObject var3) throws Exception;

    public BaseFileInputTransform(TransformMeta transformMeta, Meta meta, Data data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, meta, data, copyNr, pipelineMeta, pipeline);
    }

    @Override
    public boolean init() {
        Map resultFiles;
        this.initErrorHandling();
        ((BaseFileInputAdditionalField)((BaseFileInputMeta)this.meta).additionalOutputFields).normalize();
        ((BaseFileInputTransformData)this.data).files = ((BaseFileInputMeta)this.meta).getFileInputList(this);
        ((BaseFileInputTransformData)this.data).currentFileIndex = 0;
        Result previousResult = this.getPipeline().getPreviousResult();
        Map map = resultFiles = previousResult != null ? previousResult.getResultFiles() : null;
        if (!(previousResult != null && resultFiles != null && resultFiles.size() != 0 || ((BaseFileInputTransformData)this.data).files.nrOfMissingFiles() <= 0 || ((BaseFileInputFiles)((BaseFileInputMeta)this.meta).inputFiles).acceptingFilenames || ((BaseFileInputMeta)this.meta).errorHandling.errorIgnored)) {
            this.logError(BaseMessages.getString(PKG, (String)"BaseFileInputTransform.Log.Error.NoFilesSpecified", (String[])new String[0]));
            return false;
        }
        return super.init();
    }

    protected boolean openNextFile() {
        try {
            if (((BaseFileInputTransformData)this.data).currentFileIndex >= ((BaseFileInputTransformData)this.data).files.nrOfFiles()) {
                return false;
            }
            ((BaseFileInputTransformData)this.data).file = ((BaseFileInputTransformData)this.data).files.getFile(((BaseFileInputTransformData)this.data).currentFileIndex);
            ((BaseFileInputTransformData)this.data).filename = HopVfs.getFilename((FileObject)((BaseFileInputTransformData)this.data).file);
            this.fillFileAdditionalFields((BaseFileInputTransformData)this.data, ((BaseFileInputTransformData)this.data).file);
            if (((BaseFileInputFiles)((BaseFileInputMeta)this.meta).inputFiles).passingThruFields) {
                StringBuilder sb = new StringBuilder();
                sb.append(((BaseFileInputTransformData)this.data).currentFileIndex).append("_").append(((BaseFileInputTransformData)this.data).file);
                ((BaseFileInputTransformData)this.data).currentPassThruFieldsRow = ((BaseFileInputTransformData)this.data).passThruFields.get(sb.toString());
            }
            if (((BaseFileInputFiles)((BaseFileInputMeta)this.meta).inputFiles).isaddresult) {
                ResultFile resultFile = new ResultFile(0, ((BaseFileInputTransformData)this.data).file, this.getPipelineMeta().getName(), this.toString());
                resultFile.setComment("File was read by an Text File input transform");
                this.addResultFile(resultFile);
            }
            if (this.log.isBasic()) {
                this.logBasic("Opening file: " + ((BaseFileInputTransformData)this.data).file.getName().getFriendlyURI());
            }
            ((BaseFileInputTransformData)this.data).dataErrorLineHandler.handleFile(((BaseFileInputTransformData)this.data).file);
            ((BaseFileInputTransformData)this.data).reader = this.createReader((BaseFileInputMeta)this.meta, (BaseFileInputTransformData)this.data, ((BaseFileInputTransformData)this.data).file);
        }
        catch (Exception e) {
            if (!this.handleOpenFileException(e)) {
                return false;
            }
            ((BaseFileInputTransformData)this.data).reader = null;
        }
        ++((BaseFileInputTransformData)this.data).currentFileIndex;
        return true;
    }

    protected boolean handleOpenFileException(Exception e) {
        String errorMsg = "Couldn't open file #" + ((BaseFileInputTransformData)this.data).currentFileIndex + " : " + ((BaseFileInputTransformData)this.data).file.getName().getFriendlyURI();
        if (!this.failAfterBadFile(errorMsg)) {
            return true;
        }
        this.stopAll();
        this.setErrors(this.getErrors() + 1L);
        this.logError(errorMsg, e);
        return false;
    }

    @Override
    public boolean processRow() throws HopException {
        if (this.first) {
            this.first = false;
            this.prepareToRowProcessing();
            if (!this.openNextFile()) {
                this.setOutputDone();
                this.closeLastFile();
                return false;
            }
        }
        do {
            if (((BaseFileInputTransformData)this.data).reader != null && ((BaseFileInputTransformData)this.data).reader.readRow()) {
                return true;
            }
            this.closeLastFile();
        } while (this.openNextFile());
        this.setOutputDone();
        this.closeLastFile();
        return false;
    }

    protected void prepareToRowProcessing() throws HopException {
        ((BaseFileInputTransformData)this.data).outputRowMeta = new RowMeta();
        IRowMeta[] infoTransform = null;
        if (((BaseFileInputFiles)((BaseFileInputMeta)this.meta).inputFiles).acceptingFilenames) {
            infoTransform = this.filesFromPreviousTransform();
        }
        ((BaseFileInputMeta)this.meta).getFields(((BaseFileInputTransformData)this.data).outputRowMeta, this.getTransformName(), infoTransform, null, this, this.metadataProvider);
        ((BaseFileInputTransformData)this.data).convertRowMeta = ((BaseFileInputTransformData)this.data).outputRowMeta.cloneToType(2);
        BaseFileInputTransformUtils.handleMissingFiles(((BaseFileInputTransformData)this.data).files, this.log, ((BaseFileInputMeta)this.meta).errorHandling.errorIgnored, ((BaseFileInputTransformData)this.data).dataErrorLineHandler);
        for (int i = 0; i < ((BaseFileInputMeta)this.meta).inputFields.length; ++i) {
            if (!((BaseFileField)((BaseFileInputMeta)this.meta).inputFields[i]).isRepeated()) continue;
            ++((BaseFileInputTransformData)this.data).nr_repeats;
        }
    }

    @Override
    public boolean checkFeedback(long lines) {
        return super.checkFeedback(lines);
    }

    private void initErrorHandling() {
        ArrayList<IFileErrorHandler> dataErrorLineHandlers = new ArrayList<IFileErrorHandler>(2);
        if (((BaseFileInputMeta)this.meta).errorHandling.lineNumberFilesDestinationDirectory != null) {
            dataErrorLineHandlers.add(new FileErrorHandlerContentLineNumber(this.getPipeline().getExecutionStartDate(), this.resolve(((BaseFileInputMeta)this.meta).errorHandling.lineNumberFilesDestinationDirectory), ((BaseFileInputMeta)this.meta).errorHandling.lineNumberFilesExtension, ((BaseFileInputMeta)this.meta).getEncoding(), this));
        }
        if (((BaseFileInputMeta)this.meta).errorHandling.errorFilesDestinationDirectory != null) {
            dataErrorLineHandlers.add(new FileErrorHandlerMissingFiles(this.getPipeline().getExecutionStartDate(), this.resolve(((BaseFileInputMeta)this.meta).errorHandling.errorFilesDestinationDirectory), ((BaseFileInputMeta)this.meta).errorHandling.errorFilesExtension, ((BaseFileInputMeta)this.meta).getEncoding(), this));
        }
        ((BaseFileInputTransformData)this.data).dataErrorLineHandler = new CompositeFileErrorHandler(dataErrorLineHandlers);
    }

    private IRowMeta[] filesFromPreviousTransform() throws HopException {
        IRowMeta[] infoTransform = null;
        ((BaseFileInputTransformData)this.data).files.getFiles().clear();
        int idx = -1;
        IRowSet rowSet = this.findInputRowSet(((BaseFileInputFiles)((BaseFileInputMeta)this.meta).inputFiles).acceptingTransformName);
        Object[] fileRow = this.getRowFrom(rowSet);
        while (fileRow != null) {
            IRowMeta prevInfoFields = rowSet.getRowMeta();
            if (idx < 0) {
                if (((BaseFileInputFiles)((BaseFileInputMeta)this.meta).inputFiles).passingThruFields) {
                    ((BaseFileInputTransformData)this.data).passThruFields = new HashMap();
                    infoTransform = new IRowMeta[]{prevInfoFields};
                    ((BaseFileInputTransformData)this.data).nrPassThruFields = prevInfoFields.size();
                }
                if ((idx = prevInfoFields.indexOfValue(((BaseFileInputFiles)((BaseFileInputMeta)this.meta).inputFiles).acceptingField)) < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"BaseFileInputTransform.Log.Error.UnableToFindFilenameField", (String[])new String[]{((BaseFileInputFiles)((BaseFileInputMeta)this.meta).inputFiles).acceptingField}));
                    this.setErrors(this.getErrors() + 1L);
                    this.stopAll();
                    return null;
                }
            }
            String fileValue = prevInfoFields.getString(fileRow, idx);
            try {
                FileObject fileObject = HopVfs.getFileObject((String)fileValue, (IVariables)this.variables);
                ((BaseFileInputTransformData)this.data).files.addFile(fileObject);
                if (((BaseFileInputFiles)((BaseFileInputMeta)this.meta).inputFiles).passingThruFields) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(((BaseFileInputTransformData)this.data).files.nrOfFiles() > 0 ? ((BaseFileInputTransformData)this.data).files.nrOfFiles() - 1 : 0).append("_").append(fileObject.toString());
                    ((BaseFileInputTransformData)this.data).passThruFields.put(sb.toString(), fileRow);
                }
            }
            catch (HopFileException e) {
                this.logError(BaseMessages.getString(PKG, (String)"BaseFileInputTransform.Log.Error.UnableToCreateFileObject", (String[])new String[]{fileValue}), e);
            }
            fileRow = this.getRowFrom(rowSet);
        }
        if (((BaseFileInputTransformData)this.data).files.nrOfFiles() == 0) {
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"BaseFileInputTransform.Log.Error.NoFilesSpecified", (String[])new String[0]));
            }
            return null;
        }
        return infoTransform;
    }

    protected void closeLastFile() {
        if (((BaseFileInputTransformData)this.data).reader != null) {
            try {
                ((BaseFileInputTransformData)this.data).reader.close();
            }
            catch (Exception ex) {
                this.failAfterBadFile("Error close reader");
            }
            ((BaseFileInputTransformData)this.data).reader = null;
        }
        if (((BaseFileInputTransformData)this.data).file != null) {
            try {
                ((BaseFileInputTransformData)this.data).file.close();
            }
            catch (Exception ex) {
                this.failAfterBadFile("Error close file");
            }
            ((BaseFileInputTransformData)this.data).file = null;
        }
    }

    @Override
    public void dispose() {
        this.closeLastFile();
        super.dispose();
    }

    @Override
    public boolean failAfterBadFile(String errorMsg) {
        if (this.getTransformMeta().isDoingErrorHandling() && ((BaseFileInputTransformData)this.data).filename != null && !((BaseFileInputTransformData)this.data).rejectedFiles.containsKey(((BaseFileInputTransformData)this.data).filename)) {
            ((BaseFileInputTransformData)this.data).rejectedFiles.put(((BaseFileInputTransformData)this.data).filename, true);
            this.rejectCurrentFile(errorMsg);
        }
        return !((BaseFileInputMeta)this.meta).errorHandling.errorIgnored || !((BaseFileInputMeta)this.meta).errorHandling.skipBadFiles;
    }

    private void rejectCurrentFile(String errorMsg) {
        if (StringUtils.isNotBlank((String)((BaseFileInputMeta)this.meta).errorHandling.fileErrorField) || StringUtils.isNotBlank((String)((BaseFileInputMeta)this.meta).errorHandling.fileErrorMessageField)) {
            IRowMeta rowMeta = this.getInputRowMeta();
            if (rowMeta == null) {
                rowMeta = new RowMeta();
            }
            int errorFileIndex = StringUtils.isBlank((String)((BaseFileInputMeta)this.meta).errorHandling.fileErrorField) ? -1 : BaseFileInputTransformUtils.addValueMeta(this.getTransformName(), rowMeta, this.resolve(((BaseFileInputMeta)this.meta).errorHandling.fileErrorField));
            int errorMessageIndex = StringUtils.isBlank((String)((BaseFileInputMeta)this.meta).errorHandling.fileErrorMessageField) ? -1 : BaseFileInputTransformUtils.addValueMeta(this.getTransformName(), rowMeta, this.resolve(((BaseFileInputMeta)this.meta).errorHandling.fileErrorMessageField));
            try {
                Object[] rowData = this.getRow();
                if (rowData == null) {
                    rowData = RowDataUtil.allocateRowData((int)rowMeta.size());
                }
                if (errorFileIndex >= 0) {
                    rowData[errorFileIndex] = ((BaseFileInputTransformData)this.data).filename;
                }
                if (errorMessageIndex >= 0) {
                    rowData[errorMessageIndex] = errorMsg;
                }
                this.putError(rowMeta, rowData, this.getErrors(), ((BaseFileInputTransformData)this.data).filename, null, "ERROR_CODE");
            }
            catch (Exception e) {
                this.logError("Error sending error row", e);
            }
        }
    }

    protected void fillFileAdditionalFields(Data data, FileObject file) throws FileSystemException {
        ((BaseFileInputTransformData)data).shortFilename = file.getName().getBaseName();
        ((BaseFileInputTransformData)data).path = HopVfs.getFilename((FileObject)file.getParent());
        ((BaseFileInputTransformData)data).hidden = file.isHidden();
        ((BaseFileInputTransformData)data).extension = file.getName().getExtension();
        ((BaseFileInputTransformData)data).uriName = file.getName().getURI();
        ((BaseFileInputTransformData)data).rootUriName = file.getName().getRootURI();
        if (file.getType().hasContent()) {
            ((BaseFileInputTransformData)data).lastModificationDateTime = new Date(file.getContent().getLastModifiedTime());
            ((BaseFileInputTransformData)data).size = file.getContent().getSize();
        } else {
            ((BaseFileInputTransformData)data).lastModificationDateTime = null;
            ((BaseFileInputTransformData)data).size = null;
        }
    }
}

