/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.metadata;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.json.JsonMetadataParser;
import org.apache.hop.metadata.serializer.memory.MemoryMetadataProvider;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class SerializableMetadataProvider
extends MemoryMetadataProvider
implements IHopMetadataProvider {
    public SerializableMetadataProvider() {
    }

    public SerializableMetadataProvider(IHopMetadataProvider source) throws HopException {
        this.description = "Serializable metadata provider (source is " + source.getDescription() + ")";
        for (Class metadataClass : source.getMetadataClasses()) {
            IHopMetadataSerializer sourceSerializer = source.getSerializer(metadataClass);
            IHopMetadataSerializer targetSerializer = this.getSerializer(metadataClass);
            for (String name : sourceSerializer.listObjectNames()) {
                targetSerializer.save(sourceSerializer.load(name));
            }
        }
    }

    public String toJson() throws HopException {
        JSONObject jStore = new JSONObject();
        for (Class metadataClass : this.getMetadataClasses()) {
            IHopMetadataSerializer serializer = this.getSerializer(metadataClass);
            HopMetadata hopMetadata = metadataClass.getAnnotation(HopMetadata.class);
            if (hopMetadata == null) {
                throw new HopException("Error: class " + metadataClass + " is not annotated with " + HopMetadata.class.getName());
            }
            String classKey = hopMetadata.key();
            JSONArray jClass = new JSONArray();
            JsonMetadataParser parser = new JsonMetadataParser(metadataClass, (IHopMetadataProvider)this);
            for (String name : serializer.listObjectNames()) {
                IHopMetadata object = serializer.load(name);
                JSONObject jObject = parser.getJsonObject(object);
                jClass.add((Object)jObject);
            }
            jStore.put((Object)classKey, (Object)jClass);
        }
        return jStore.toJSONString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerializableMetadataProvider(String storeJson) throws HopException {
        this();
        this.description = "Serializable metadata provider (source is JSON)";
        try (ByteArrayInputStream inputStream = null;){
            inputStream = new ByteArrayInputStream(storeJson.getBytes("UTF-8"));
            JsonFactory jsonFactory = new JsonFactory();
            JsonParser jsonParser = jsonFactory.createParser((InputStream)inputStream);
            jsonParser.nextToken();
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                String classKey = jsonParser.getText();
                Class managedClass = this.getMetadataClassForKey(classKey);
                JsonMetadataParser metadataParser = new JsonMetadataParser(managedClass, (IHopMetadataProvider)this);
                IHopMetadataSerializer serializer = this.getSerializer(managedClass);
                jsonParser.nextToken();
                while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    IHopMetadata object = metadataParser.loadJsonObject(managedClass, jsonParser);
                    serializer.save(object);
                }
            }
        }
        catch (Exception e) {
            throw new HopException("Error reading metadata from JSON", (Throwable)e);
        }
    }
}

