/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core;

import com.google.common.util.concurrent.SettableFuture;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.ConcurrentMapProperties;
import org.apache.hop.core.Const;
import org.apache.hop.core.HopClientEnvironment;
import org.apache.hop.core.IExecutor;
import org.apache.hop.core.auth.AuthenticationConsumerPluginType;
import org.apache.hop.core.auth.AuthenticationProviderPluginType;
import org.apache.hop.core.compress.CompressionPluginType;
import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.config.plugin.ConfigPluginType;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.plugins.ActionPluginType;
import org.apache.hop.core.plugins.HopServerPluginType;
import org.apache.hop.core.plugins.IPluginType;
import org.apache.hop.core.plugins.PartitionerPluginType;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.plugins.TransformPluginType;
import org.apache.hop.core.variables.DescribedVariable;
import org.apache.hop.core.variables.VariableRegistry;
import org.apache.hop.core.variables.VariableScope;
import org.apache.hop.execution.plugin.ExecutionInfoLocationPluginType;
import org.apache.hop.execution.sampler.ExecutionDataSamplerPluginType;
import org.apache.hop.imp.ImportPluginType;
import org.apache.hop.metadata.plugin.MetadataPluginType;
import org.apache.hop.pipeline.engine.PipelineEnginePluginType;
import org.apache.hop.pipeline.transform.RowDistributionPluginType;
import org.apache.hop.workflow.engine.WorkflowEnginePluginType;

public class HopEnvironment {
    private static final Class<?> PKG = Const.class;
    private static AtomicReference<SettableFuture<Boolean>> initialized = new AtomicReference<Object>(null);

    public static void init() throws HopException {
        HopEnvironment.init(HopEnvironment.getStandardPluginTypes());
    }

    public static List<IPluginType> getStandardPluginTypes() {
        return Arrays.asList(new IPluginType[]{RowDistributionPluginType.getInstance(), TransformPluginType.getInstance(), PartitionerPluginType.getInstance(), ActionPluginType.getInstance(), HopServerPluginType.getInstance(), CompressionPluginType.getInstance(), AuthenticationProviderPluginType.getInstance(), AuthenticationConsumerPluginType.getInstance(), PipelineEnginePluginType.getInstance(), WorkflowEnginePluginType.getInstance(), ConfigPluginType.getInstance(), MetadataPluginType.getInstance(), ImportPluginType.getInstance(), ExecutionDataSamplerPluginType.getInstance(), ExecutionInfoLocationPluginType.getInstance()});
    }

    public static void init(List<IPluginType> pluginTypes) throws HopException {
        SettableFuture<Boolean> ready = SettableFuture.create();
        if (initialized.compareAndSet(null, ready)) {
            System.setProperties(ConcurrentMapProperties.convertProperties(System.getProperties()));
            try {
                if (!HopClientEnvironment.isInitialized()) {
                    HopClientEnvironment.init();
                }
                pluginTypes.forEach(PluginRegistry::addPluginType);
                PluginRegistry.init();
                VariableRegistry.init();
                HopConfig hopConfig = HopConfig.getInstance();
                for (DescribedVariable describedVariable : VariableRegistry.getInstance().getDescribedVariables(new VariableScope[]{VariableScope.APPLICATION, VariableScope.ENGINE})) {
                    DescribedVariable variable = hopConfig.findDescribedVariable(describedVariable.getName());
                    if (variable == null) {
                        hopConfig.setDescribedVariable(new DescribedVariable(describedVariable));
                        continue;
                    }
                    variable.setDescription(describedVariable.getDescription());
                }
                for (DescribedVariable describedVariable : hopConfig.getDescribedVariables()) {
                    if (!StringUtils.isNotEmpty((String)describedVariable.getName())) continue;
                    System.setProperty(describedVariable.getName(), Const.NVL((String)describedVariable.getValue(), (String)""));
                }
                ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.GENERAL, null, (String)HopExtensionPoint.HopEnvironmentAfterInit.name(), (Object)PluginRegistry.getInstance());
                ready.set((Object)true);
            }
            catch (Throwable t) {
                ready.setException(t);
                throw t instanceof HopException ? (HopException)t : new HopException(t);
            }
        }
        ready = initialized.get();
        try {
            ready.get();
        }
        catch (Throwable t) {
            throw new HopException(t);
        }
    }

    private static void initLifecycleListeners() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                HopEnvironment.shutdown();
            }
        });
    }

    public static void shutdown() {
    }

    public static boolean isInitialized() {
        Future future = (Future)initialized.get();
        try {
            return future != null && (Boolean)future.get() != false;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public void loadPluginRegistry() {
    }

    public static void setExecutionInformation(IExecutor executor) {
        executor.setExecutingUser(System.getProperty("user.name"));
    }

    public static void reset() {
        HopClientEnvironment.reset();
        initialized.set(null);
    }
}

