/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import org.apache.commons.numbers.core.Sum;
import org.apache.commons.statistics.descriptive.FirstMoment;

class SumOfSquaredDeviations
extends FirstMoment {
    protected double sumSquaredDev;

    SumOfSquaredDeviations() {
    }

    SumOfSquaredDeviations(SumOfSquaredDeviations source) {
        super(source);
        this.sumSquaredDev = source.sumSquaredDev;
    }

    private SumOfSquaredDeviations(double sumSquaredDev, FirstMoment m1) {
        super(m1);
        this.sumSquaredDev = sumSquaredDev;
    }

    SumOfSquaredDeviations(double sumSquaredDev, double m1, long n) {
        super(m1, n);
        this.sumSquaredDev = sumSquaredDev;
    }

    static SumOfSquaredDeviations of(double ... values) {
        if (values.length == 0) {
            return new SumOfSquaredDeviations();
        }
        return SumOfSquaredDeviations.create(FirstMoment.of(values), values, 0, values.length);
    }

    static SumOfSquaredDeviations ofRange(double[] values, int from, int to) {
        if (from == to) {
            return new SumOfSquaredDeviations();
        }
        return SumOfSquaredDeviations.create(FirstMoment.ofRange(values, from, to), values, from, to);
    }

    static SumOfSquaredDeviations createFromRange(Sum sum, double[] values, int from, int to) {
        if (from == to) {
            return new SumOfSquaredDeviations();
        }
        return SumOfSquaredDeviations.create(FirstMoment.createFromRange(sum, values, from, to), values, from, to);
    }

    private static SumOfSquaredDeviations create(FirstMoment m1, double[] values, int from, int to) {
        double xbar = m1.getFirstMoment();
        if (!Double.isFinite(xbar)) {
            return new SumOfSquaredDeviations(Double.NaN, m1);
        }
        double s = 0.0;
        double ss = 0.0;
        for (int i = from; i < to; ++i) {
            double dx = values[i] - xbar;
            s += dx;
            ss += dx * dx;
        }
        double sumSquaredDev = ss == Double.POSITIVE_INFINITY ? Double.POSITIVE_INFINITY : ss - s * s / (double)(to - from);
        return new SumOfSquaredDeviations(sumSquaredDev, m1);
    }

    @Override
    public void accept(double value) {
        super.accept(value);
        this.sumSquaredDev += (double)(this.n - 1L) * this.dev * this.nDev * 4.0;
    }

    double getSumOfSquaredDeviations() {
        return Double.isFinite(this.getFirstMoment()) ? this.sumSquaredDev : Double.NaN;
    }

    SumOfSquaredDeviations combine(SumOfSquaredDeviations other) {
        long m = other.n;
        if (this.n == 0L) {
            this.sumSquaredDev = other.sumSquaredDev;
        } else if (m != 0L) {
            double diffOfMean = this.getFirstMomentDifference(other);
            double sqDiffOfMean = diffOfMean * diffOfMean;
            this.sumSquaredDev = this.sumSquaredDev + other.sumSquaredDev + sqDiffOfMean * ((double)this.n * (double)m / ((double)this.n + (double)m));
        }
        super.combine(other);
        return this;
    }
}

