/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.request;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.action.search.CreatePitRequest;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.InnerHitBuilder;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.collapse.CollapseBuilder;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.opensearch.client.OpenSearchClient;
import org.opensearch.sql.opensearch.data.type.OpenSearchDataType;
import org.opensearch.sql.opensearch.data.value.OpenSearchExprValueFactory;
import org.opensearch.sql.opensearch.request.OpenSearchQueryRequest;
import org.opensearch.sql.opensearch.request.OpenSearchRequest;
import org.opensearch.sql.opensearch.response.agg.CountAsTotalHitsParser;
import org.opensearch.sql.opensearch.response.agg.OpenSearchAggregationResponseParser;

public class OpenSearchRequestBuilder {
    private final SearchSourceBuilder sourceBuilder;
    private int requestedTotalSize = Integer.MAX_VALUE;
    private Integer pageSize = null;
    private final OpenSearchExprValueFactory exprValueFactory;
    private final int maxResultWindow;
    private int startFrom = 0;
    private final Settings settings;

    public OpenSearchRequestBuilder(OpenSearchExprValueFactory exprValueFactory, int maxResultWindow, Settings settings) {
        this.settings = settings;
        this.maxResultWindow = maxResultWindow;
        this.sourceBuilder = new SearchSourceBuilder().from(this.startFrom).timeout(OpenSearchRequest.DEFAULT_QUERY_TIMEOUT).trackScores(false);
        this.exprValueFactory = exprValueFactory;
    }

    public OpenSearchRequest build(OpenSearchRequest.IndexName indexName, TimeValue cursorKeepAlive, OpenSearchClient client) {
        return this.build(indexName, cursorKeepAlive, client, false);
    }

    public OpenSearchRequest build(OpenSearchRequest.IndexName indexName, TimeValue cursorKeepAlive, OpenSearchClient client, boolean isMappingEmpty) {
        if (this.sourceBuilder.size() == 0 || isMappingEmpty) {
            return new OpenSearchQueryRequest(indexName, this.sourceBuilder, this.exprValueFactory, List.of());
        }
        return this.buildRequestWithPit(indexName, cursorKeepAlive, client);
    }

    private OpenSearchRequest buildRequestWithPit(OpenSearchRequest.IndexName indexName, TimeValue cursorKeepAlive, OpenSearchClient client) {
        List<String> includes;
        int size = this.requestedTotalSize;
        FetchSourceContext fetchSource = this.sourceBuilder.fetchSource();
        List<String> list = includes = fetchSource != null ? Arrays.asList(fetchSource.includes()) : List.of();
        if (this.pageSize == null) {
            if (this.startFrom + size > this.maxResultWindow) {
                this.sourceBuilder.size(this.maxResultWindow - this.startFrom);
                String pitId = this.createPit(indexName, cursorKeepAlive, client);
                return new OpenSearchQueryRequest(indexName, this.sourceBuilder, this.exprValueFactory, includes, cursorKeepAlive, pitId);
            }
            this.sourceBuilder.from(this.startFrom);
            this.sourceBuilder.size(size);
            return new OpenSearchQueryRequest(indexName, this.sourceBuilder, this.exprValueFactory, includes);
        }
        if (this.startFrom != 0) {
            throw new UnsupportedOperationException("Non-zero offset is not supported with pagination");
        }
        this.sourceBuilder.size(this.pageSize.intValue());
        String pitId = this.createPit(indexName, cursorKeepAlive, client);
        return new OpenSearchQueryRequest(indexName, this.sourceBuilder, this.exprValueFactory, includes, cursorKeepAlive, pitId);
    }

    private String createPit(OpenSearchRequest.IndexName indexName, TimeValue cursorKeepAlive, OpenSearchClient client) {
        CreatePitRequest createPitRequest = new CreatePitRequest(cursorKeepAlive, Boolean.valueOf(false), indexName.getIndexNames());
        return client.createPit(createPitRequest);
    }

    boolean isBoolFilterQuery(QueryBuilder current) {
        return current instanceof BoolQueryBuilder;
    }

    public void pushDownFilter(QueryBuilder query) {
        QueryBuilder current = this.sourceBuilder.query();
        if (current == null) {
            this.sourceBuilder.query(query);
        } else if (this.isBoolFilterQuery(current)) {
            ((BoolQueryBuilder)current).filter(query);
        } else {
            this.sourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().filter(current).filter(query));
        }
    }

    public void pushDownAggregation(Pair<List<AggregationBuilder>, OpenSearchAggregationResponseParser> aggregationBuilder) {
        aggregationBuilder.getLeft().forEach(arg_0 -> ((SearchSourceBuilder)this.sourceBuilder).aggregation(arg_0));
        this.sourceBuilder.size(0);
        this.exprValueFactory.setParser(aggregationBuilder.getRight());
        if (this.sourceBuilder.sorts() != null) {
            this.sourceBuilder.sorts().clear();
        }
        if (aggregationBuilder.getRight() instanceof CountAsTotalHitsParser) {
            this.sourceBuilder.trackTotalHits(true);
        }
    }

    public void pushDownSort(List<SortBuilder<?>> sortBuilders) {
        for (SortBuilder<?> sortBuilder : sortBuilders) {
            this.sourceBuilder.sort(sortBuilder);
        }
    }

    public void pushDownLimit(Integer limit, Integer offset) {
        int newRequestedTotalSize = Math.min(limit, this.requestedTotalSize - offset);
        int newStartFrom = this.startFrom + offset;
        if (newStartFrom >= this.maxResultWindow) {
            throw new PushDownUnSupportedException(String.format("Requested offset %d should be less than the max result window %d", newStartFrom, this.maxResultWindow));
        }
        this.requestedTotalSize = newRequestedTotalSize;
        this.startFrom = newStartFrom;
        this.sourceBuilder.from(this.startFrom).size(this.requestedTotalSize);
    }

    public void pushDownTrackedScore(boolean trackScores) {
        this.sourceBuilder.trackScores(trackScores);
    }

    public void pushDownPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void pushDownHighlight(String field, Map<String, Literal> arguments2) {
        String unquotedField = StringUtils.unquoteText(field);
        if (this.sourceBuilder.highlighter() != null) {
            if (this.sourceBuilder.highlighter().fields().stream().anyMatch(f -> f.name().equals(unquotedField))) {
                throw new SemanticCheckException(String.format("Duplicate field %s in highlight", field));
            }
            this.sourceBuilder.highlighter().field(unquotedField);
        } else {
            HighlightBuilder highlightBuilder = new HighlightBuilder().field(unquotedField);
            this.sourceBuilder.highlighter(highlightBuilder);
        }
        int lastFieldIndex = this.sourceBuilder.highlighter().fields().size() - 1;
        if (arguments2.containsKey("pre_tags")) {
            ((HighlightBuilder.Field)this.sourceBuilder.highlighter().fields().get(lastFieldIndex)).preTags(new String[]{arguments2.get("pre_tags").toString()});
        }
        if (arguments2.containsKey("post_tags")) {
            ((HighlightBuilder.Field)this.sourceBuilder.highlighter().fields().get(lastFieldIndex)).postTags(new String[]{arguments2.get("post_tags").toString()});
        }
    }

    public void pushDownProjects(Set<ReferenceExpression> projects) {
        this.pushDownProjectStream(projects.stream().map(ReferenceExpression::getRawPath));
    }

    public void pushDownProjectStream(Stream<String> projects) {
        this.sourceBuilder.fetchSource((String[])projects.distinct().toArray(String[]::new), new String[0]);
    }

    public void pushTypeMapping(Map<String, OpenSearchDataType> typeMapping) {
        this.exprValueFactory.extendTypeMapping(typeMapping);
    }

    public void pushDownCollapse(String field) {
        this.sourceBuilder.collapse(new CollapseBuilder(field));
    }

    public void pushDownNested(List<Map<String, ReferenceExpression>> nestedArgs) {
        this.initBoolQueryFilter();
        List<NestedQueryBuilder> nestedQueries = this.extractNestedQueries((QueryBuilder)this.query());
        this.groupFieldNamesByPath(nestedArgs).forEach((path, fieldNames) -> this.buildInnerHit((List<String>)fieldNames, this.findNestedQueryWithSamePath(nestedQueries, (String)path)));
    }

    private List<NestedQueryBuilder> extractNestedQueries(QueryBuilder query) {
        ArrayList<NestedQueryBuilder> result2 = new ArrayList<NestedQueryBuilder>();
        if (query instanceof NestedQueryBuilder) {
            result2.add((NestedQueryBuilder)query);
        } else if (query instanceof BoolQueryBuilder) {
            BoolQueryBuilder boolQ = (BoolQueryBuilder)query;
            Stream.of(boolQ.filter(), boolQ.must(), boolQ.should()).flatMap(Collection::stream).forEach(q -> result2.addAll(this.extractNestedQueries((QueryBuilder)q)));
        }
        return result2;
    }

    public int getMaxResponseSize() {
        return this.pageSize == null ? this.requestedTotalSize : this.pageSize;
    }

    private void initBoolQueryFilter() {
        if (this.sourceBuilder.query() == null) {
            this.sourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery());
        } else {
            this.sourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must(this.sourceBuilder.query()));
        }
        this.sourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().filter(this.sourceBuilder.query()));
    }

    private Map<String, List<String>> groupFieldNamesByPath(List<Map<String, ReferenceExpression>> fields2) {
        return fields2.stream().collect(Collectors.groupingBy(m4 -> ((ReferenceExpression)m4.get("path")).toString(), Collectors.mapping(m4 -> ((ReferenceExpression)m4.get("field")).toString(), Collectors.toList())));
    }

    private void buildInnerHit(List<String> paths, NestedQueryBuilder query) {
        query.innerHit(new InnerHitBuilder().setFetchSourceContext(new FetchSourceContext(true, paths.toArray(new String[0]), null)));
    }

    private NestedQueryBuilder findNestedQueryWithSamePath(List<NestedQueryBuilder> nestedQueries, String path) {
        return nestedQueries.stream().filter(query -> this.isSamePath(path, (NestedQueryBuilder)query)).findAny().orElseGet(this.createEmptyNestedQuery(path));
    }

    private boolean isSamePath(String path, NestedQueryBuilder query) {
        return QueryBuilders.nestedQuery((String)path, (QueryBuilder)query.query(), (ScoreMode)query.scoreMode()).equals((Object)query);
    }

    private Supplier<NestedQueryBuilder> createEmptyNestedQuery(String path) {
        return () -> {
            NestedQueryBuilder nestedQuery = QueryBuilders.nestedQuery((String)path, (QueryBuilder)QueryBuilders.matchAllQuery(), (ScoreMode)ScoreMode.None);
            ((BoolQueryBuilder)this.query().filter().get(0)).must((QueryBuilder)nestedQuery);
            return nestedQuery;
        };
    }

    private BoolQueryBuilder query() {
        return (BoolQueryBuilder)this.sourceBuilder.query();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenSearchRequestBuilder)) {
            return false;
        }
        OpenSearchRequestBuilder other = (OpenSearchRequestBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRequestedTotalSize() != other.getRequestedTotalSize()) {
            return false;
        }
        if (this.getStartFrom() != other.getStartFrom()) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        SearchSourceBuilder this$sourceBuilder = this.getSourceBuilder();
        SearchSourceBuilder other$sourceBuilder = other.getSourceBuilder();
        if (this$sourceBuilder == null ? other$sourceBuilder != null : !this$sourceBuilder.equals(other$sourceBuilder)) {
            return false;
        }
        Settings this$settings = this.getSettings();
        Settings other$settings = other.getSettings();
        return !(this$settings == null ? other$settings != null : !this$settings.equals(other$settings));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OpenSearchRequestBuilder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        result2 = result2 * 59 + this.getRequestedTotalSize();
        result2 = result2 * 59 + this.getStartFrom();
        Integer $pageSize = this.getPageSize();
        result2 = result2 * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        SearchSourceBuilder $sourceBuilder = this.getSourceBuilder();
        result2 = result2 * 59 + ($sourceBuilder == null ? 43 : $sourceBuilder.hashCode());
        Settings $settings = this.getSettings();
        result2 = result2 * 59 + ($settings == null ? 43 : $settings.hashCode());
        return result2;
    }

    @Generated
    public SearchSourceBuilder getSourceBuilder() {
        return this.sourceBuilder;
    }

    @Generated
    public int getRequestedTotalSize() {
        return this.requestedTotalSize;
    }

    @Generated
    public Integer getPageSize() {
        return this.pageSize;
    }

    @Generated
    public OpenSearchExprValueFactory getExprValueFactory() {
        return this.exprValueFactory;
    }

    @Generated
    public int getMaxResultWindow() {
        return this.maxResultWindow;
    }

    @Generated
    public int getStartFrom() {
        return this.startFrom;
    }

    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    @Generated
    public String toString() {
        return "OpenSearchRequestBuilder(sourceBuilder=" + String.valueOf(this.getSourceBuilder()) + ", requestedTotalSize=" + this.getRequestedTotalSize() + ", pageSize=" + this.getPageSize() + ", startFrom=" + this.getStartFrom() + ")";
    }

    public static class PushDownUnSupportedException
    extends RuntimeException {
        public PushDownUnSupportedException(String message) {
            super(message);
        }
    }
}

