/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.executor.format;

import org.json.JSONObject;
import org.opensearch.core.rest.RestStatus;

public class ErrorMessage<E extends Exception> {
    protected final E exception;
    private final int status;
    private final String type;
    private final String reason;
    private final String details;

    public ErrorMessage(E exception, int status) {
        this.exception = exception;
        this.status = status;
        this.type = this.fetchType();
        this.reason = this.fetchReason();
        this.details = this.fetchDetails();
    }

    private String fetchType() {
        return this.exception.getClass().getSimpleName();
    }

    protected String fetchReason() {
        return this.status == RestStatus.BAD_REQUEST.getStatus() ? "Invalid SQL query" : "There was internal problem at backend";
    }

    protected String fetchDetails() {
        return this.emptyStringIfNull(((Throwable)this.exception).getLocalizedMessage());
    }

    private String emptyStringIfNull(String str) {
        return str != null ? str : "";
    }

    public String toString() {
        JSONObject output = new JSONObject();
        output.put("status", this.status);
        output.put("error", this.getErrorAsJson());
        return output.toString(2);
    }

    private JSONObject getErrorAsJson() {
        JSONObject errorJson = new JSONObject();
        errorJson.put("type", this.type);
        errorJson.put("reason", this.reason);
        errorJson.put("details", this.details);
        return errorJson;
    }
}

