/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.executor.csv;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import shaded.com.google.common.collect.ImmutableSet;

public class CSVResult {
    private static final Set<String> SENSITIVE_CHAR = ImmutableSet.of("=", "+", "-", "@");
    private final List<String> headers;
    private final List<String> lines;

    public CSVResult(List<String> headers, List<String> lines) {
        this.headers = headers;
        this.lines = lines;
    }

    public CSVResult(String separator, List<String> headers, List<List<String>> lines) {
        this.headers = this.sanitizeHeaders(separator, headers);
        this.lines = this.sanitizeLines(separator, lines);
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public List<String> getLines() {
        return this.lines;
    }

    private List<String> sanitizeHeaders(String separator, List<String> headers) {
        return headers.stream().map(this::sanitizeCell).map(cell -> this.quoteIfRequired(separator, (String)cell)).collect(Collectors.toList());
    }

    private List<String> sanitizeLines(String separator, List<List<String>> lines) {
        ArrayList<String> result2 = new ArrayList<String>();
        for (List<String> line : lines) {
            result2.add(line.stream().map(this::sanitizeCell).map(cell -> this.quoteIfRequired(separator, (String)cell)).collect(Collectors.joining(separator)));
        }
        return result2;
    }

    private String sanitizeCell(String cell) {
        if (this.isStartWithSensitiveChar(cell)) {
            return "'" + cell;
        }
        return cell;
    }

    private String quoteIfRequired(String separator, String cell) {
        String quote = "\"";
        return cell.contains(separator) ? "\"" + cell.replaceAll("\"", "\"\"") + "\"" : cell;
    }

    private boolean isStartWithSensitiveChar(String cell) {
        return SENSITIVE_CHAR.stream().anyMatch(cell::startsWith);
    }
}

