/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.conditional.cases;

import lombok.Generated;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.ExpressionNodeVisitor;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.env.Environment;
import org.opensearch.sql.expression.function.FunctionName;
import shaded.com.google.common.collect.ImmutableList;

public class WhenClause
extends FunctionExpression {
    private final Expression condition;
    private final Expression result;

    public WhenClause(Expression condition, Expression result2) {
        super(FunctionName.of("when"), ImmutableList.of(condition, result2));
        this.condition = condition;
        this.result = result2;
    }

    public boolean isTrue(Environment<Expression, ExprValue> valueEnv) {
        ExprValue result2 = this.condition.valueOf(valueEnv);
        if (result2.isMissing() || result2.isNull()) {
            return false;
        }
        return result2.booleanValue();
    }

    @Override
    public ExprValue valueOf(Environment<Expression, ExprValue> valueEnv) {
        return this.result.valueOf(valueEnv);
    }

    @Override
    public ExprType type() {
        return this.result.type();
    }

    @Override
    public <T, C> T accept(ExpressionNodeVisitor<T, C> visitor2, C context) {
        return visitor2.visitWhen(this, context);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WhenClause)) {
            return false;
        }
        WhenClause other = (WhenClause)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Expression this$condition = this.getCondition();
        Expression other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
            return false;
        }
        Expression this$result = this.getResult();
        Expression other$result = other.getResult();
        return !(this$result == null ? other$result != null : !this$result.equals(other$result));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WhenClause;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        Expression $condition = this.getCondition();
        result2 = result2 * 59 + ($condition == null ? 43 : $condition.hashCode());
        Expression $result = this.getResult();
        result2 = result2 * 59 + ($result == null ? 43 : $result.hashCode());
        return result2;
    }

    @Generated
    public Expression getCondition() {
        return this.condition;
    }

    @Generated
    public Expression getResult() {
        return this.result;
    }

    @Override
    @Generated
    public String toString() {
        return "WhenClause(condition=" + String.valueOf(this.getCondition()) + ", result=" + String.valueOf(this.getResult()) + ")";
    }
}

