/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.common.utils;

import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.ThreadContext;

public class QueryContext {
    private static final String REQUEST_ID_KEY = "request_id";

    public static String addRequestId() {
        String id = UUID.randomUUID().toString();
        ThreadContext.put((String)REQUEST_ID_KEY, (String)id);
        return id;
    }

    public static String getRequestId() {
        String id = ThreadContext.get((String)REQUEST_ID_KEY);
        if (null == id) {
            id = QueryContext.addRequestId();
        }
        return id;
    }

    public static Runnable withCurrentContext(Runnable task) {
        Map currentContext = ThreadContext.getImmutableContext();
        return () -> {
            ThreadContext.putAll((Map)currentContext);
            task.run();
        };
    }

    private QueryContext() {
        throw new AssertionError((Object)(this.getClass().getCanonicalName() + " is a utility class and must not be initialized"));
    }
}

