/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils.binning.time;

import org.apache.calcite.rex.RexNode;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.utils.binning.time.AlignmentHandler;
import org.opensearch.sql.calcite.utils.binning.time.DaySpanHandler;
import org.opensearch.sql.calcite.utils.binning.time.MonthSpanHandler;
import org.opensearch.sql.calcite.utils.binning.time.StandardTimeSpanHandler;
import org.opensearch.sql.calcite.utils.binning.time.TimeUnitConfig;
import org.opensearch.sql.calcite.utils.binning.time.TimeUnitRegistry;

public class TimeSpanExpressionFactory {
    private final StandardTimeSpanHandler standardHandler = new StandardTimeSpanHandler();
    private final DaySpanHandler dayHandler = new DaySpanHandler();
    private final MonthSpanHandler monthHandler = new MonthSpanHandler();

    public RexNode createTimeSpanExpression(RexNode fieldExpr, int intervalValue, String unit, long alignmentOffsetMillis, CalcitePlanContext context) {
        TimeUnitConfig config = TimeUnitRegistry.getConfig(unit);
        if (config == null) {
            throw new IllegalArgumentException("Unsupported time unit for bin span: " + unit);
        }
        TimeUnitRegistry.validateSubSecondSpan(config, intervalValue);
        return switch (config) {
            default -> throw new MatchException(null, null);
            case TimeUnitConfig.MICROSECONDS, TimeUnitConfig.MILLISECONDS, TimeUnitConfig.CENTISECONDS, TimeUnitConfig.DECISECONDS, TimeUnitConfig.SECONDS, TimeUnitConfig.MINUTES, TimeUnitConfig.HOURS -> this.standardHandler.createExpression(fieldExpr, intervalValue, config, alignmentOffsetMillis, context);
            case TimeUnitConfig.DAYS -> this.dayHandler.createExpression(fieldExpr, intervalValue, context);
            case TimeUnitConfig.MONTHS -> this.monthHandler.createExpression(fieldExpr, intervalValue, context);
        };
    }

    public RexNode createTimeSpanExpressionWithTimeModifier(RexNode fieldExpr, int intervalValue, String unit, String timeModifier, CalcitePlanContext context) {
        TimeUnitConfig config = TimeUnitRegistry.getConfig(unit);
        if (config == null) {
            throw new IllegalArgumentException("Unsupported time unit for bin span: " + unit);
        }
        TimeUnitRegistry.validateSubSecondSpan(config, intervalValue);
        try {
            long epochTimestamp = Long.parseLong(timeModifier);
            return AlignmentHandler.createEpochAlignedSpan(fieldExpr, intervalValue, config, epochTimestamp, context);
        }
        catch (NumberFormatException e) {
            return AlignmentHandler.createTimeModifierAlignedSpan(fieldExpr, intervalValue, config, timeModifier, context);
        }
    }
}

