/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.memorycontainer;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.transport.memorycontainer.memory.MemoryEvent;

public class MemoryDecision
implements ToXContentObject,
Writeable {
    private String id;
    private String text;
    private MemoryEvent event;
    private String oldMemory;

    public MemoryDecision(String id, String text, MemoryEvent event, String oldMemory) {
        this.id = id;
        this.text = text;
        this.event = event;
        this.oldMemory = oldMemory;
    }

    public MemoryDecision(StreamInput in) throws IOException {
        this.id = in.readString();
        this.text = in.readString();
        this.event = MemoryEvent.valueOf(in.readString());
        this.oldMemory = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeString(this.text);
        out.writeString(this.event.toString());
        out.writeOptionalString(this.oldMemory);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("memory_id", this.id);
        builder.field("text", this.text);
        builder.field("event", this.event.toString());
        if (this.oldMemory != null) {
            builder.field("old_memory", this.oldMemory);
        }
        builder.endObject();
        return builder;
    }

    public static MemoryDecision parse(XContentParser parser) throws IOException {
        String id = null;
        String text = null;
        MemoryEvent event = null;
        String oldMemory = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block13: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "memory_id": 
                case "id": {
                    id = parser.text();
                    continue block13;
                }
                case "text": {
                    text = parser.text();
                    continue block13;
                }
                case "event": {
                    event = MemoryEvent.fromString(parser.text());
                    continue block13;
                }
                case "old_memory": {
                    oldMemory = parser.text();
                    continue block13;
                }
            }
            parser.skipChildren();
        }
        return MemoryDecision.builder().id(id).text(text).event(event).oldMemory(oldMemory).build();
    }

    @Generated
    public static MemoryDecisionBuilder builder() {
        return new MemoryDecisionBuilder();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public MemoryEvent getEvent() {
        return this.event;
    }

    @Generated
    public String getOldMemory() {
        return this.oldMemory;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setText(String text) {
        this.text = text;
    }

    @Generated
    public void setEvent(MemoryEvent event) {
        this.event = event;
    }

    @Generated
    public void setOldMemory(String oldMemory) {
        this.oldMemory = oldMemory;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MemoryDecision)) {
            return false;
        }
        MemoryDecision other = (MemoryDecision)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        MemoryEvent this$event = this.getEvent();
        MemoryEvent other$event = other.getEvent();
        if (this$event == null ? other$event != null : !((Object)((Object)this$event)).equals((Object)other$event)) {
            return false;
        }
        String this$oldMemory = this.getOldMemory();
        String other$oldMemory = other.getOldMemory();
        return !(this$oldMemory == null ? other$oldMemory != null : !this$oldMemory.equals(other$oldMemory));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MemoryDecision;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        String $id = this.getId();
        result2 = result2 * 59 + ($id == null ? 43 : $id.hashCode());
        String $text = this.getText();
        result2 = result2 * 59 + ($text == null ? 43 : $text.hashCode());
        MemoryEvent $event = this.getEvent();
        result2 = result2 * 59 + ($event == null ? 43 : ((Object)((Object)$event)).hashCode());
        String $oldMemory = this.getOldMemory();
        result2 = result2 * 59 + ($oldMemory == null ? 43 : $oldMemory.hashCode());
        return result2;
    }

    @Generated
    public String toString() {
        return "MemoryDecision(id=" + this.getId() + ", text=" + this.getText() + ", event=" + String.valueOf((Object)this.getEvent()) + ", oldMemory=" + this.getOldMemory() + ")";
    }

    @Generated
    public static class MemoryDecisionBuilder {
        @Generated
        private String id;
        @Generated
        private String text;
        @Generated
        private MemoryEvent event;
        @Generated
        private String oldMemory;

        @Generated
        MemoryDecisionBuilder() {
        }

        @Generated
        public MemoryDecisionBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public MemoryDecisionBuilder text(String text) {
            this.text = text;
            return this;
        }

        @Generated
        public MemoryDecisionBuilder event(MemoryEvent event) {
            this.event = event;
            return this;
        }

        @Generated
        public MemoryDecisionBuilder oldMemory(String oldMemory) {
            this.oldMemory = oldMemory;
            return this;
        }

        @Generated
        public MemoryDecision build() {
            return new MemoryDecision(this.id, this.text, this.event, this.oldMemory);
        }

        @Generated
        public String toString() {
            return "MemoryDecision.MemoryDecisionBuilder(id=" + this.id + ", text=" + this.text + ", event=" + String.valueOf((Object)this.event) + ", oldMemory=" + this.oldMemory + ")";
        }
    }
}

