/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.collect.ImmutableList;

public class SameOperandTypeChecker
implements SqlSingleOperandTypeChecker {
    protected final int nOperands;

    public SameOperandTypeChecker(int nOperands) {
        this.nOperands = nOperands;
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        return this.checkOperandTypesImpl(callBinding, throwOnFailure, callBinding);
    }

    protected List<Integer> getOperandList(int operandCount) {
        return this.nOperands == -1 ? Util.range(0, operandCount) : Util.range(0, this.nOperands);
    }

    protected boolean checkOperandTypesImpl(SqlOperatorBinding operatorBinding, boolean throwOnFailure, @Nullable SqlCallBinding callBinding) {
        if (throwOnFailure && callBinding == null) {
            throw new IllegalArgumentException("callBinding must be non-null in case throwOnFailure=true");
        }
        int nOperandsActual = this.nOperands;
        if (nOperandsActual == -1) {
            nOperandsActual = operatorBinding.getOperandCount();
        }
        RelDataType[] types = new RelDataType[nOperandsActual];
        List<Integer> operandList = this.getOperandList(operatorBinding.getOperandCount());
        for (int i : operandList) {
            types[i] = operatorBinding.getOperandType(i);
        }
        int prev = -1;
        for (int i : operandList) {
            if (prev >= 0 && !SqlTypeUtil.isComparable(types[i], types[prev])) {
                if (!throwOnFailure) {
                    return false;
                }
                throw Objects.requireNonNull(callBinding, "callBinding").newValidationError(Static.RESOURCE.needSameTypeParameter());
            }
            prev = i;
        }
        return true;
    }

    public boolean checkOperandTypes(SqlOperatorBinding operatorBinding, SqlCallBinding callBinding) {
        return this.checkOperandTypesImpl(operatorBinding, false, null);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        if (this.nOperands == -1) {
            return SqlOperandCountRanges.any();
        }
        return SqlOperandCountRanges.of(this.nOperands);
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        String typeName = this.getTypeName();
        return SqlUtil.getAliasedSignature(op, opName, this.nOperands == -1 ? ImmutableList.of(typeName, typeName, "...") : Collections.nCopies(this.nOperands, typeName));
    }

    protected String getTypeName() {
        return "EQUIVALENT_TYPE";
    }

    @Override
    public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode operand, int iFormalOperand, boolean throwOnFailure) {
        throw new UnsupportedOperationException();
    }
}

