/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.IntPredicate;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rel.metadata.NullSentinel;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLambda;
import org.apache.calcite.rex.RexLambdaRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.RangeSets;
import org.apache.calcite.util.Sarg;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.collect.ImmutableMap;
import shaded.com.google.common.collect.RangeSet;

public class RexInterpreter
implements RexVisitor<Comparable> {
    private static final NullSentinel N = NullSentinel.INSTANCE;
    public static final EnumSet<SqlKind> SUPPORTED_SQL_KIND = EnumSet.of(SqlKind.IS_NOT_DISTINCT_FROM, new SqlKind[]{SqlKind.EQUALS, SqlKind.IS_DISTINCT_FROM, SqlKind.NOT_EQUALS, SqlKind.GREATER_THAN, SqlKind.GREATER_THAN_OR_EQUAL, SqlKind.LESS_THAN, SqlKind.LESS_THAN_OR_EQUAL, SqlKind.AND, SqlKind.OR, SqlKind.NOT, SqlKind.CASE, SqlKind.IS_TRUE, SqlKind.IS_NOT_TRUE, SqlKind.IS_FALSE, SqlKind.IS_NOT_FALSE, SqlKind.PLUS_PREFIX, SqlKind.MINUS_PREFIX, SqlKind.PLUS, SqlKind.MINUS, SqlKind.TIMES, SqlKind.DIVIDE, SqlKind.COALESCE, SqlKind.CEIL, SqlKind.FLOOR, SqlKind.EXTRACT});
    private final SqlFunctions.LikeFunction likeFunction = new SqlFunctions.LikeFunction();
    private final SqlFunctions.SimilarFunction similarFunction = new SqlFunctions.SimilarFunction();
    private final SqlFunctions.SimilarEscapeFunction similarEscapeFunction = new SqlFunctions.SimilarEscapeFunction();
    private final Map<RexNode, Comparable> environment;

    private RexInterpreter(Map<RexNode, Comparable> environment) {
        this.environment = ImmutableMap.copyOf(environment);
    }

    public static @Nullable Comparable evaluate(RexNode e, Map<RexNode, Comparable> map) {
        Comparable v = e.accept(new RexInterpreter(map));
        return v;
    }

    private static IllegalArgumentException unbound(RexNode e) {
        return new IllegalArgumentException("unbound: " + e);
    }

    private Comparable getOrUnbound(RexNode e) {
        Comparable comparable = this.environment.get(e);
        if (comparable != null) {
            return comparable;
        }
        throw RexInterpreter.unbound(e);
    }

    @Override
    public Comparable visitInputRef(RexInputRef inputRef) {
        return this.getOrUnbound(inputRef);
    }

    @Override
    public Comparable visitLocalRef(RexLocalRef localRef) {
        throw RexInterpreter.unbound(localRef);
    }

    @Override
    public Comparable visitLiteral(RexLiteral literal) {
        return (Comparable)((Object)Util.first(literal.getValue4(), N));
    }

    @Override
    public Comparable visitOver(RexOver over) {
        throw RexInterpreter.unbound(over);
    }

    @Override
    public Comparable visitCorrelVariable(RexCorrelVariable correlVariable) {
        return this.getOrUnbound(correlVariable);
    }

    @Override
    public Comparable visitDynamicParam(RexDynamicParam dynamicParam) {
        return this.getOrUnbound(dynamicParam);
    }

    @Override
    public Comparable visitRangeRef(RexRangeRef rangeRef) {
        throw RexInterpreter.unbound(rangeRef);
    }

    @Override
    public Comparable visitFieldAccess(RexFieldAccess fieldAccess) {
        return this.getOrUnbound(fieldAccess);
    }

    @Override
    public Comparable visitSubQuery(RexSubQuery subQuery) {
        throw RexInterpreter.unbound(subQuery);
    }

    @Override
    public Comparable visitTableInputRef(RexTableInputRef fieldRef) {
        throw RexInterpreter.unbound(fieldRef);
    }

    @Override
    public Comparable visitPatternFieldRef(RexPatternFieldRef fieldRef) {
        throw RexInterpreter.unbound(fieldRef);
    }

    @Override
    public Comparable visitLambda(RexLambda lambda2) {
        throw RexInterpreter.unbound(lambda2);
    }

    @Override
    public Comparable visitLambdaRef(RexLambdaRef lambdaRef) {
        throw RexInterpreter.unbound(lambdaRef);
    }

    @Override
    public Comparable visitCall(RexCall call) {
        List<Comparable> values2 = this.visitList(call.operands);
        switch (call.getKind()) {
            case IS_NOT_DISTINCT_FROM: {
                if (RexInterpreter.containsNull(values2)) {
                    return Boolean.valueOf(values2.get(0).equals(values2.get(1)));
                }
            }
            case EQUALS: {
                return RexInterpreter.compare(values2, c -> c == 0);
            }
            case IS_DISTINCT_FROM: {
                if (RexInterpreter.containsNull(values2)) {
                    return Boolean.valueOf(!values2.get(0).equals(values2.get(1)));
                }
            }
            case NOT_EQUALS: {
                return RexInterpreter.compare(values2, c -> c != 0);
            }
            case GREATER_THAN: {
                return RexInterpreter.compare(values2, c -> c > 0);
            }
            case GREATER_THAN_OR_EQUAL: {
                return RexInterpreter.compare(values2, c -> c >= 0);
            }
            case LESS_THAN: {
                return RexInterpreter.compare(values2, c -> c < 0);
            }
            case LESS_THAN_OR_EQUAL: {
                return RexInterpreter.compare(values2, c -> c <= 0);
            }
            case AND: {
                return values2.stream().map(Truthy::of).min(Comparator.naturalOrder()).get().toComparable();
            }
            case OR: {
                return values2.stream().map(Truthy::of).max(Comparator.naturalOrder()).get().toComparable();
            }
            case NOT: {
                return RexInterpreter.not(values2.get(0));
            }
            case CASE: {
                return RexInterpreter.case_(values2);
            }
            case IS_TRUE: {
                return Boolean.valueOf(values2.get(0).equals(true));
            }
            case IS_NOT_TRUE: {
                return Boolean.valueOf(!values2.get(0).equals(true));
            }
            case IS_NULL: {
                return Boolean.valueOf(values2.get(0).equals((Object)N));
            }
            case IS_NOT_NULL: {
                return Boolean.valueOf(!values2.get(0).equals((Object)N));
            }
            case IS_FALSE: {
                return Boolean.valueOf(values2.get(0).equals(false));
            }
            case IS_NOT_FALSE: {
                return Boolean.valueOf(!values2.get(0).equals(false));
            }
            case PLUS_PREFIX: {
                return values2.get(0);
            }
            case MINUS_PREFIX: {
                return RexInterpreter.containsNull(values2) ? N : RexInterpreter.number(values2.get(0)).negate();
            }
            case PLUS: {
                return RexInterpreter.containsNull(values2) ? N : RexInterpreter.number(values2.get(0)).add(RexInterpreter.number(values2.get(1)));
            }
            case MINUS: {
                return RexInterpreter.containsNull(values2) ? N : RexInterpreter.number(values2.get(0)).subtract(RexInterpreter.number(values2.get(1)));
            }
            case TIMES: {
                return RexInterpreter.containsNull(values2) ? N : RexInterpreter.number(values2.get(0)).multiply(RexInterpreter.number(values2.get(1)));
            }
            case DIVIDE: {
                return RexInterpreter.containsNull(values2) ? N : RexInterpreter.number(values2.get(0)).divide(RexInterpreter.number(values2.get(1)));
            }
            case CAST: {
                return RexInterpreter.cast(values2);
            }
            case COALESCE: {
                return RexInterpreter.coalesce(values2);
            }
            case CEIL: 
            case FLOOR: {
                return RexInterpreter.ceil(call, values2);
            }
            case EXTRACT: {
                return RexInterpreter.extract(values2);
            }
            case LIKE: {
                return this.like(values2);
            }
            case SIMILAR: {
                return this.similar(values2);
            }
            case SEARCH: {
                return RexInterpreter.search(((RexNode)call.operands.get(1)).getType().getSqlTypeName(), values2);
            }
        }
        throw RexInterpreter.unbound(call);
    }

    private static Comparable extract(List<Comparable> values2) {
        Comparable v = values2.get(1);
        if (v == N) {
            return N;
        }
        TimeUnitRange timeUnitRange = (TimeUnitRange)((Object)values2.get(0));
        int v2 = v instanceof Long ? (int)((Long)v / TimeUnit.DAY.multiplier.longValue()) : (Integer)v;
        return Long.valueOf(DateTimeUtils.unixDateExtract(timeUnitRange, v2));
    }

    private Comparable like(List<Comparable> values2) {
        if (RexInterpreter.containsNull(values2)) {
            return N;
        }
        NlsString value = (NlsString)values2.get(0);
        NlsString pattern = (NlsString)values2.get(1);
        switch (values2.size()) {
            case 2: {
                return Boolean.valueOf(this.likeFunction.like(value.getValue(), pattern.getValue()));
            }
            case 3: {
                NlsString escape = (NlsString)values2.get(2);
                return Boolean.valueOf(this.likeFunction.like(value.getValue(), pattern.getValue(), escape.getValue()));
            }
        }
        throw new AssertionError();
    }

    private Comparable similar(List<Comparable> values2) {
        if (RexInterpreter.containsNull(values2)) {
            return N;
        }
        NlsString value = (NlsString)values2.get(0);
        NlsString pattern = (NlsString)values2.get(1);
        switch (values2.size()) {
            case 2: {
                return Boolean.valueOf(this.similarFunction.similar(value.getValue(), pattern.getValue()));
            }
            case 3: {
                NlsString escape = (NlsString)values2.get(2);
                return Boolean.valueOf(this.similarEscapeFunction.similar(value.getValue(), pattern.getValue(), escape.getValue()));
            }
        }
        throw new AssertionError();
    }

    private static Comparable search(SqlTypeName typeName, List<Comparable> values2) {
        Comparable value = values2.get(0);
        Sarg sarg = (Sarg)values2.get(1);
        if (value == N) {
            switch (sarg.nullAs) {
                case FALSE: {
                    return Boolean.valueOf(false);
                }
                case TRUE: {
                    return Boolean.valueOf(true);
                }
            }
            return N;
        }
        return Boolean.valueOf(RexInterpreter.translate(sarg.rangeSet, typeName).contains(value));
    }

    private static RangeSet translate(RangeSet rangeSet, SqlTypeName typeName) {
        switch (typeName) {
            case DATE: {
                return RangeSets.copy(rangeSet, DateString::getDaysSinceEpoch);
            }
            case TIME: {
                return RangeSets.copy(rangeSet, TimeString::getMillisOfDay);
            }
            case TIMESTAMP: {
                return RangeSets.copy(rangeSet, TimestampString::getMillisSinceEpoch);
            }
        }
        return rangeSet;
    }

    private static Comparable coalesce(List<Comparable> values2) {
        for (Comparable value : values2) {
            if (value == N) continue;
            return value;
        }
        return N;
    }

    private static Comparable ceil(RexCall call, List<Comparable> values2) {
        if (values2.get(0) == N) {
            return N;
        }
        Long v = (Long)values2.get(0);
        TimeUnitRange unit = (TimeUnitRange)((Object)values2.get(1));
        switch (unit) {
            case YEAR: 
            case MONTH: {
                switch (call.getKind()) {
                    case FLOOR: {
                        return Long.valueOf(DateTimeUtils.unixTimestampFloor(unit, v));
                    }
                }
                return Long.valueOf(DateTimeUtils.unixTimestampCeil(unit, v));
            }
        }
        TimeUnitRange subUnit = RexInterpreter.subUnit(unit);
        long v2 = v;
        int e;
        while ((e = DateTimeUtils.unixTimestampExtract(subUnit, v2)) != 0) {
            v2 -= unit.startUnit.multiplier.longValue();
        }
        return Long.valueOf(v2);
    }

    private static TimeUnitRange subUnit(TimeUnitRange unit) {
        switch (unit) {
            case QUARTER: {
                return TimeUnitRange.MONTH;
            }
        }
        return TimeUnitRange.DAY;
    }

    private static Comparable cast(List<Comparable> values2) {
        if (values2.get(0) == N) {
            return N;
        }
        return values2.get(0);
    }

    private static Comparable not(Comparable value) {
        if (value.equals(true)) {
            return Boolean.valueOf(false);
        }
        if (value.equals(false)) {
            return Boolean.valueOf(true);
        }
        return N;
    }

    private static Comparable case_(List<Comparable> values2) {
        Object elseValue;
        int size;
        if (values2.size() % 2 == 0) {
            size = values2.size();
            elseValue = N;
        } else {
            size = values2.size() - 1;
            elseValue = Util.last(values2);
        }
        for (int i = 0; i < size; i += 2) {
            if (!values2.get(i).equals(true)) continue;
            return values2.get(i + 1);
        }
        return elseValue;
    }

    private static BigDecimal number(Comparable comparable) {
        return comparable instanceof BigDecimal ? (BigDecimal)comparable : (comparable instanceof BigInteger ? new BigDecimal((BigInteger)comparable) : (comparable instanceof Long || comparable instanceof Integer || comparable instanceof Short ? new BigDecimal(((Number)((Object)comparable)).longValue()) : new BigDecimal(((Number)((Object)comparable)).doubleValue())));
    }

    private static Comparable compare(List<Comparable> values2, IntPredicate p) {
        if (RexInterpreter.containsNull(values2)) {
            return N;
        }
        Comparable v0 = values2.get(0);
        Comparable v1 = values2.get(1);
        if (v0 instanceof Number && v1 instanceof NlsString) {
            try {
                v1 = new BigDecimal(((NlsString)v1).getValue());
            }
            catch (NumberFormatException e) {
                return Boolean.valueOf(false);
            }
        }
        if (v1 instanceof Number && v0 instanceof NlsString) {
            try {
                v0 = new BigDecimal(((NlsString)v0).getValue());
            }
            catch (NumberFormatException e) {
                return Boolean.valueOf(false);
            }
        }
        if (v0 instanceof Number) {
            v0 = RexInterpreter.number(v0);
        }
        if (v1 instanceof Number) {
            v1 = RexInterpreter.number(v1);
        }
        int c = v0.compareTo(v1);
        return Boolean.valueOf(p.test(c));
    }

    private static boolean containsNull(List<Comparable> values2) {
        for (Comparable value : values2) {
            if (value != N) continue;
            return true;
        }
        return false;
    }

    static enum Truthy {
        FALSE,
        UNKNOWN,
        TRUE;


        static Truthy of(Comparable c) {
            return c.equals(true) ? TRUE : (c.equals(false) ? FALSE : UNKNOWN);
        }

        Comparable toComparable() {
            switch (this) {
                case TRUE: {
                    return Boolean.valueOf(true);
                }
                case FALSE: {
                    return Boolean.valueOf(false);
                }
                case UNKNOWN: {
                    return N;
                }
            }
            throw new AssertionError();
        }
    }
}

