/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import javax.sql.DataSource;
import org.apache.calcite.adapter.jdbc.JdbcConvention;
import org.apache.calcite.adapter.jdbc.JdbcTable;
import org.apache.calcite.adapter.jdbc.JdbcUtils;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.avatica.MetaImpl;
import org.apache.calcite.avatica.SqlType;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.SchemaVersion;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.Wrapper;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlDialectFactory;
import org.apache.calcite.sql.SqlDialectFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.ImmutableMap;
import shaded.com.google.common.collect.ImmutableMultimap;
import shaded.com.google.common.collect.ImmutableSet;
import shaded.com.google.common.collect.Multimap;
import shaded.com.google.common.collect.Ordering;

public class JdbcSchema
implements Schema,
Wrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcSchema.class);
    final DataSource dataSource;
    final @Nullable String catalog;
    final @Nullable String schema;
    public final SqlDialect dialect;
    final JdbcConvention convention;
    private @Nullable ImmutableMap<String, JdbcTable> tableMap;
    private final boolean snapshot;
    public static final ThreadLocal<@Nullable Foo> THREAD_METADATA = new ThreadLocal();
    private static final Ordering<Iterable<Integer>> VERSION_ORDERING = Ordering.natural().lexicographical();

    public JdbcSchema(DataSource dataSource, SqlDialect dialect, JdbcConvention convention, @Nullable String catalog, @Nullable String schema) {
        this(dataSource, dialect, convention, catalog, schema, null);
    }

    private JdbcSchema(DataSource dataSource, SqlDialect dialect, JdbcConvention convention, @Nullable String catalog, @Nullable String schema, @Nullable ImmutableMap<String, JdbcTable> tableMap) {
        this.dataSource = Objects.requireNonNull(dataSource, "dataSource");
        this.dialect = Objects.requireNonNull(dialect, "dialect");
        this.convention = convention;
        this.catalog = catalog;
        this.schema = schema;
        this.tableMap = tableMap;
        this.snapshot = tableMap != null;
    }

    public static JdbcSchema create(SchemaPlus parentSchema, String name, DataSource dataSource, @Nullable String catalog, @Nullable String schema) {
        return JdbcSchema.create(parentSchema, name, dataSource, SqlDialectFactoryImpl.INSTANCE, catalog, schema);
    }

    public static JdbcSchema create(SchemaPlus parentSchema, String name, DataSource dataSource, SqlDialectFactory dialectFactory, @Nullable String catalog, @Nullable String schema) {
        Expression expression = Schemas.subSchemaExpression(parentSchema, name, JdbcSchema.class);
        SqlDialect dialect = JdbcSchema.createDialect(dialectFactory, dataSource);
        JdbcConvention convention = JdbcConvention.of(dialect, expression, name);
        return new JdbcSchema(dataSource, dialect, convention, catalog, schema);
    }

    public static JdbcSchema create(SchemaPlus parentSchema, String name, Map<String, Object> operand) {
        DataSource dataSource;
        try {
            String dataSourceName = (String)operand.get("dataSource");
            if (dataSourceName != null) {
                dataSource = AvaticaUtils.instantiatePlugin(DataSource.class, dataSourceName);
            } else {
                String jdbcUrl = (String)Objects.requireNonNull(operand.get("jdbcUrl"), "jdbcUrl");
                String jdbcDriver = (String)operand.get("jdbcDriver");
                String jdbcUser = (String)operand.get("jdbcUser");
                String jdbcPassword = (String)operand.get("jdbcPassword");
                dataSource = JdbcSchema.dataSource(jdbcUrl, jdbcDriver, jdbcUser, jdbcPassword);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while reading dataSource", e);
        }
        String jdbcCatalog = (String)operand.get("jdbcCatalog");
        String jdbcSchema = (String)operand.get("jdbcSchema");
        String sqlDialectFactory = (String)operand.get("sqlDialectFactory");
        if (sqlDialectFactory == null || sqlDialectFactory.isEmpty()) {
            return JdbcSchema.create(parentSchema, name, dataSource, jdbcCatalog, jdbcSchema);
        }
        SqlDialectFactory factory2 = AvaticaUtils.instantiatePlugin(SqlDialectFactory.class, sqlDialectFactory);
        return JdbcSchema.create(parentSchema, name, dataSource, factory2, jdbcCatalog, jdbcSchema);
    }

    @Deprecated
    public static SqlDialect createDialect(DataSource dataSource) {
        return JdbcSchema.createDialect(SqlDialectFactoryImpl.INSTANCE, dataSource);
    }

    public static SqlDialect createDialect(SqlDialectFactory dialectFactory, DataSource dataSource) {
        return JdbcUtils.DialectPool.INSTANCE.get(dialectFactory, dataSource);
    }

    public static DataSource dataSource(String url, @Nullable String driverClassName, @Nullable String username, @Nullable String password) {
        if (url.startsWith("jdbc:hsqldb:")) {
            System.setProperty("hsqldb.reconfig_logging", "false");
        }
        return JdbcUtils.DataSourcePool.INSTANCE.get(url, driverClassName, username, password);
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public Schema snapshot(SchemaVersion version) {
        return new JdbcSchema(this.dataSource, this.dialect, this.convention, this.catalog, this.schema, this.tableMap);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public Expression getExpression(@Nullable SchemaPlus parentSchema, String name) {
        Objects.requireNonNull(parentSchema, "parentSchema must not be null for JdbcSchema");
        return Schemas.subSchemaExpression(parentSchema, name, JdbcSchema.class);
    }

    protected Multimap<String, Function> getFunctions() {
        return ImmutableMultimap.of();
    }

    @Override
    public final Collection<Function> getFunctions(String name) {
        return this.getFunctions().get(name);
    }

    @Override
    public final Set<String> getFunctionNames() {
        return this.getFunctions().keySet();
    }

    private ImmutableMap<String, JdbcTable> computeTables() {
        ImmutableMap immutableMap;
        Connection connection = null;
        ResultSet resultSet = null;
        try {
            ArrayList<MetaImpl.MetaTable> tableDefs;
            connection = this.dataSource.getConnection();
            Pair<@Nullable String, @Nullable String> catalogSchema = this.getCatalogSchema(connection);
            String catalog = (String)catalogSchema.left;
            String schema = (String)catalogSchema.right;
            Foo threadMetadata = THREAD_METADATA.get();
            if (threadMetadata != null) {
                tableDefs = (ArrayList<MetaImpl.MetaTable>)threadMetadata.apply(catalog, schema);
            } else {
                ArrayList<MetaImpl.MetaTable> tableDefList = new ArrayList<MetaImpl.MetaTable>();
                DatabaseMetaData metaData = connection.getMetaData();
                resultSet = metaData.getTables(catalog, schema, null, null);
                while (resultSet.next()) {
                    String catalogName = resultSet.getString(1);
                    String schemaName = resultSet.getString(2);
                    String tableName = resultSet.getString(3);
                    String tableTypeName = resultSet.getString(4);
                    tableDefList.add(new MetaImpl.MetaTable(catalogName, schemaName, tableName, tableTypeName));
                }
                tableDefs = tableDefList;
            }
            ImmutableMap.Builder<String, JdbcTable> builder = ImmutableMap.builder();
            for (MetaImpl.MetaTable tableDef : tableDefs) {
                String tableTypeName2 = tableDef.tableType == null ? null : tableDef.tableType.toUpperCase(Locale.ROOT).replace(' ', '_');
                Schema.TableType tableType = Util.enumVal(Schema.TableType.OTHER, tableTypeName2);
                if (tableType == Schema.TableType.OTHER && tableTypeName2 != null) {
                    LOGGER.info("Unknown table type: {}", (Object)tableTypeName2);
                }
                JdbcTable table = new JdbcTable(this, tableDef.tableCat, tableDef.tableSchem, tableDef.tableName, tableType);
                builder.put(tableDef.tableName, table);
            }
            immutableMap = builder.build();
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException("Exception while reading tables", e);
            }
            catch (Throwable throwable) {
                JdbcSchema.close(connection, null, resultSet);
                throw throwable;
            }
        }
        JdbcSchema.close(connection, null, resultSet);
        return immutableMap;
    }

    private static List<Integer> version(DatabaseMetaData metaData) throws SQLException {
        return ImmutableList.of(Integer.valueOf(metaData.getJDBCMajorVersion()), Integer.valueOf(metaData.getJDBCMinorVersion()));
    }

    private Pair<@Nullable String, @Nullable String> getCatalogSchema(Connection connection) throws SQLException {
        boolean jdbc41OrAbove;
        DatabaseMetaData metaData = connection.getMetaData();
        ImmutableList<Integer> version41 = ImmutableList.of(Integer.valueOf(4), Integer.valueOf(1));
        String catalog = this.catalog;
        String schema = this.schema;
        boolean bl = jdbc41OrAbove = VERSION_ORDERING.compare(JdbcSchema.version(metaData), version41) >= 0;
        if (catalog == null && jdbc41OrAbove) {
            catalog = connection.getCatalog();
        }
        if (schema == null && jdbc41OrAbove && "".equals(schema = connection.getSchema())) {
            schema = null;
        }
        if ((catalog == null || schema == null) && metaData.getDatabaseProductName().equals("PostgreSQL")) {
            String sql = "select current_database(), current_schema()";
            try (Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery("select current_database(), current_schema()");){
                if (resultSet.next()) {
                    catalog = resultSet.getString(1);
                    schema = resultSet.getString(2);
                }
            }
        }
        return Pair.of(catalog, schema);
    }

    @Override
    public @Nullable Table getTable(String name) {
        return this.getTableMap(false).get(name);
    }

    private synchronized ImmutableMap<String, JdbcTable> getTableMap(boolean force) {
        if (force || this.tableMap == null) {
            this.tableMap = this.computeTables();
        }
        return this.tableMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RelProtoDataType getRelDataType(String catalogName, String schemaName, String tableName) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            DatabaseMetaData metaData = connection.getMetaData();
            RelProtoDataType relProtoDataType = this.getRelDataType(metaData, catalogName, schemaName, tableName);
            return relProtoDataType;
        }
        finally {
            JdbcSchema.close(connection, null, null);
        }
    }

    RelProtoDataType getRelDataType(DatabaseMetaData metaData, String catalogName, String schemaName, String tableName) throws SQLException {
        ResultSet resultSet = metaData.getColumns(catalogName, schemaName, tableName, null);
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RelDataTypeFactory.FieldInfoBuilder fieldInfo = typeFactory.builder();
        while (resultSet.next()) {
            int scale;
            int precision;
            String columnName = Objects.requireNonNull(resultSet.getString(4), "columnName");
            int dataType = resultSet.getInt(5);
            String typeString = resultSet.getString(6);
            switch (SqlType.valueOf(dataType)) {
                case TIMESTAMP: 
                case TIME: {
                    precision = resultSet.getInt(9);
                    scale = 0;
                    break;
                }
                default: {
                    precision = resultSet.getInt(7);
                    scale = resultSet.getInt(9);
                }
            }
            RelDataType sqlType = JdbcSchema.sqlType(typeFactory, dataType, precision, scale, typeString);
            boolean nullable = resultSet.getInt(11) != 0;
            ((RelDataTypeFactory.Builder)fieldInfo).add(columnName, sqlType).nullable(nullable);
        }
        resultSet.close();
        return RelDataTypeImpl.proto(fieldInfo.build());
    }

    private static RelDataType sqlType(RelDataTypeFactory typeFactory, int dataType, int precision, int scale, @Nullable String typeString) {
        SqlTypeName sqlTypeName = Util.first(SqlTypeName.getNameForJdbcType(dataType), SqlTypeName.ANY);
        switch (sqlTypeName) {
            case ARRAY: {
                RelDataType component = null;
                if (typeString != null && typeString.endsWith(" ARRAY")) {
                    String remaining = typeString.substring(0, typeString.length() - " ARRAY".length());
                    component = JdbcSchema.parseTypeString(typeFactory, remaining);
                }
                if (component == null) {
                    component = typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.ANY), true);
                }
                return typeFactory.createArrayType(component, -1L);
            }
        }
        if (precision >= 0 && scale >= 0 && sqlTypeName.allowsPrecScale(true, true)) {
            return typeFactory.createSqlType(sqlTypeName, precision, scale);
        }
        if (precision >= 0 && sqlTypeName.allowsPrecNoScale()) {
            return typeFactory.createSqlType(sqlTypeName, precision);
        }
        assert (sqlTypeName.allowsNoPrecNoScale());
        return typeFactory.createSqlType(sqlTypeName);
    }

    private static RelDataType parseTypeString(RelDataTypeFactory typeFactory, String typeString) {
        int close;
        int precision = -1;
        int scale = -1;
        int open = typeString.indexOf("(");
        if (open >= 0 && (close = typeString.indexOf(")", open)) >= 0) {
            String rest = typeString.substring(open + 1, close);
            typeString = typeString.substring(0, open);
            int comma = rest.indexOf(",");
            if (comma >= 0) {
                precision = Integer.parseInt(rest.substring(0, comma));
                scale = Integer.parseInt(rest.substring(comma));
            } else {
                precision = Integer.parseInt(rest);
            }
        }
        try {
            SqlTypeName typeName = SqlTypeName.valueOf(typeString);
            return typeName.allowsPrecScale(true, true) ? typeFactory.createSqlType(typeName, precision, scale) : (typeName.allowsPrecScale(true, false) ? typeFactory.createSqlType(typeName, precision) : typeFactory.createSqlType(typeName));
        }
        catch (IllegalArgumentException e) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.ANY), true);
        }
    }

    @Override
    public Set<String> getTableNames() {
        return this.getTableMap(!this.snapshot).keySet();
    }

    protected Map<String, RelProtoDataType> getTypes() {
        return ImmutableMap.of();
    }

    @Override
    public @Nullable RelProtoDataType getType(String name) {
        return this.getTypes().get(name);
    }

    @Override
    public Set<String> getTypeNames() {
        return this.getTypes().keySet();
    }

    @Override
    public @Nullable Schema getSubSchema(String name) {
        return null;
    }

    @Override
    public Set<String> getSubSchemaNames() {
        return ImmutableSet.of();
    }

    public <T> @Nullable T unwrap(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        if (clazz == DataSource.class) {
            return clazz.cast(this.getDataSource());
        }
        return null;
    }

    private static void close(@Nullable Connection connection, @Nullable Statement statement, @Nullable ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static interface Foo
    extends BiFunction<String, String, Iterable<MetaImpl.MetaTable>> {
    }

    public static class Factory
    implements SchemaFactory {
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @Override
        public Schema create(SchemaPlus parentSchema, String name, Map<String, Object> operand) {
            return JdbcSchema.create(parentSchema, name, operand);
        }
    }
}

