/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.jce;

import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.DataKey;
import com.amazonaws.encryptionsdk.EncryptedDataKey;
import com.amazonaws.encryptionsdk.MasterKeyProvider;
import com.amazonaws.encryptionsdk.MasterKeyRequest;
import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.exception.NoSuchMasterKeyException;
import com.amazonaws.encryptionsdk.exception.UnsupportedProviderException;
import com.amazonaws.encryptionsdk.jce.JceMasterKey;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class KeyStoreProvider
extends MasterKeyProvider<JceMasterKey> {
    private final String providerName_;
    private final KeyStore keystore_;
    private final KeyStore.ProtectionParameter protection_;
    private final String wrappingAlgorithm_;
    private final String keyAlgorithm_;
    private final List<String> aliasNames_;

    public KeyStoreProvider(KeyStore keystore, KeyStore.ProtectionParameter protection, String providerName, String wrappingAlgorithm) {
        this(keystore, protection, providerName, wrappingAlgorithm, new String[0]);
    }

    public KeyStoreProvider(KeyStore keystore, KeyStore.ProtectionParameter protection, String providerName, String wrappingAlgorithm, String ... aliasNames) {
        this.keystore_ = keystore;
        this.protection_ = protection;
        this.wrappingAlgorithm_ = wrappingAlgorithm;
        this.aliasNames_ = Arrays.asList(aliasNames);
        this.providerName_ = providerName;
        this.keyAlgorithm_ = wrappingAlgorithm.split("/", 2)[0].toUpperCase();
    }

    @Override
    public JceMasterKey getMasterKey(String provider, String keyId) throws UnsupportedProviderException, NoSuchMasterKeyException {
        if (!this.canProvide(provider)) {
            throw new UnsupportedProviderException();
        }
        JceMasterKey result2 = this.internalGetMasterKey(provider, keyId);
        if (result2 == null) {
            throw new NoSuchMasterKeyException();
        }
        return result2;
    }

    private JceMasterKey internalGetMasterKey(String provider, String keyId) {
        KeyStore.Entry entry;
        try {
            entry = this.keystore_.getEntry(keyId, this.keystore_.isKeyEntry(keyId) ? this.protection_ : null);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException e) {
            throw new UnsupportedProviderException(e);
        }
        if (entry == null) {
            throw new NoSuchMasterKeyException();
        }
        if (entry instanceof KeyStore.SecretKeyEntry) {
            KeyStore.SecretKeyEntry skEntry = (KeyStore.SecretKeyEntry)entry;
            if (!skEntry.getSecretKey().getAlgorithm().equals(this.keyAlgorithm_)) {
                return null;
            }
            return JceMasterKey.getInstance(skEntry.getSecretKey(), provider, keyId, this.wrappingAlgorithm_);
        }
        if (entry instanceof KeyStore.PrivateKeyEntry) {
            KeyStore.PrivateKeyEntry pkEntry = (KeyStore.PrivateKeyEntry)entry;
            if (!pkEntry.getPrivateKey().getAlgorithm().equals(this.keyAlgorithm_)) {
                return null;
            }
            return JceMasterKey.getInstance(pkEntry.getCertificate().getPublicKey(), pkEntry.getPrivateKey(), provider, keyId, this.wrappingAlgorithm_);
        }
        if (entry instanceof KeyStore.TrustedCertificateEntry) {
            KeyStore.TrustedCertificateEntry certEntry = (KeyStore.TrustedCertificateEntry)entry;
            if (!certEntry.getTrustedCertificate().getPublicKey().getAlgorithm().equals(this.keyAlgorithm_)) {
                return null;
            }
            return JceMasterKey.getInstance(certEntry.getTrustedCertificate().getPublicKey(), null, provider, keyId, this.wrappingAlgorithm_);
        }
        throw new NoSuchMasterKeyException();
    }

    @Override
    public String getDefaultProviderId() {
        return this.providerName_;
    }

    @Override
    public List<JceMasterKey> getMasterKeysForEncryption(MasterKeyRequest request) {
        if (this.aliasNames_ != null) {
            ArrayList<JceMasterKey> result2 = new ArrayList<JceMasterKey>();
            for (String alias : this.aliasNames_) {
                result2.add((JceMasterKey)this.getMasterKey(alias));
            }
            return result2;
        }
        return Collections.emptyList();
    }

    @Override
    public DataKey<JceMasterKey> decryptDataKey(CryptoAlgorithm algorithm, Collection<? extends EncryptedDataKey> encryptedDataKeys, Map<String, String> encryptionContext) throws UnsupportedProviderException, AwsCryptoException {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (EncryptedDataKey encryptedDataKey : encryptedDataKeys) {
            try {
                DataKey<JceMasterKey> result2;
                String alias;
                if (!this.canProvide(encryptedDataKey.getProviderId()) || !this.keystore_.isKeyEntry(alias = new String(encryptedDataKey.getProviderInformation(), StandardCharsets.UTF_8)) || (result2 = ((JceMasterKey)this.getMasterKey(alias)).decryptDataKey(algorithm, Collections.singletonList(encryptedDataKey), encryptionContext)) == null) continue;
                return result2;
            }
            catch (Exception ex) {
                exceptions.add(ex);
            }
        }
        throw this.buildCannotDecryptDksException(exceptions);
    }
}

