/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.remote.monitors;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchException;
import org.opensearch.Version;
import org.opensearch.alerting.MonitorRunner;
import org.opensearch.alerting.MonitorRunnerExecutionContext;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.commons.alerting.action.DocLevelMonitorFanOutResponse;
import org.opensearch.commons.alerting.model.DocumentLevelTriggerRunResult;
import org.opensearch.commons.alerting.model.Input;
import org.opensearch.commons.alerting.model.InputRunResults;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.commons.alerting.model.MonitorRunResult;
import org.opensearch.commons.alerting.model.WorkflowRunContext;
import org.opensearch.commons.alerting.model.remote.monitors.RemoteDocLevelMonitorInput;
import org.opensearch.commons.alerting.util.AlertingException;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.transport.TransportService;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\"\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J>\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\r0\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\r0\u001fH\u0002J\u001c\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\"0\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\rH\u0002JT\u0010(\u001a\u0006\u0012\u0002\b\u00030)2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u00102\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020/H\u0096@\u00a2\u0006\u0002\u00100J6\u00101\u001a\u0002022\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u001e\u00103\u001a\u001a\u0012\u0004\u0012\u00020\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u0002040\f0\fH\u0002J\u0010\u00105\u001a\u0002022\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/opensearch/alerting/remote/monitors/RemoteDocumentLevelMonitorRunner;", "Lorg/opensearch/alerting/MonitorRunner;", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "buildInputRunResults", "Lorg/opensearch/commons/alerting/model/InputRunResults;", "docLevelMonitorFanOutResponses", "", "Lorg/opensearch/commons/alerting/action/DocLevelMonitorFanOutResponse;", "buildTriggerResults", "", "", "Lorg/opensearch/commons/alerting/model/DocumentLevelTriggerRunResult;", "createdRecently", "", "monitor", "Lorg/opensearch/commons/alerting/model/Monitor;", "periodStart", "Ljava/time/Instant;", "periodEnd", "indexMetadata", "Lorg/opensearch/cluster/metadata/IndexMetadata;", "distributeShards", "", "", "Lorg/opensearch/core/index/shard/ShardId;", "monitorCtx", "Lorg/opensearch/alerting/MonitorRunnerExecutionContext;", "allNodes", "", "shards", "getNodes", "Lorg/opensearch/cluster/node/DiscoveryNode;", "getShardsCount", "", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "index", "runMonitor", "Lorg/opensearch/commons/alerting/model/MonitorRunResult;", "dryRun", "workflowRunContext", "Lorg/opensearch/commons/alerting/model/WorkflowRunContext;", "executionId", "transportService", "Lorg/opensearch/transport/TransportService;", "(Lorg/opensearch/commons/alerting/model/Monitor;Lorg/opensearch/alerting/MonitorRunnerExecutionContext;Ljava/time/Instant;Ljava/time/Instant;ZLorg/opensearch/commons/alerting/model/WorkflowRunContext;Ljava/lang/String;Lorg/opensearch/transport/TransportService;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateLastRunContextFromFanOutResponses", "", "updatedLastRunContext", "", "validate", "opensearch-alerting"})
@SourceDebugExtension(value={"SMAP\nRemoteDocumentLevelMonitorRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteDocumentLevelMonitorRunner.kt\norg/opensearch/alerting/remote/monitors/RemoteDocumentLevelMonitorRunner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,374:1\n1855#2:375\n1855#2:377\n1856#2:385\n1855#2,2:386\n1856#2:388\n1549#2:396\n1620#2,3:397\n766#2:400\n857#2,2:401\n1#3:376\n372#4,7:378\n526#4:389\n511#4,6:390\n372#4,7:405\n215#5,2:403\n37#6,2:412\n*S KotlinDebug\n*F\n+ 1 RemoteDocumentLevelMonitorRunner.kt\norg/opensearch/alerting/remote/monitors/RemoteDocumentLevelMonitorRunner\n*L\n91#1:375\n113#1:377\n113#1:385\n146#1:386,2\n91#1:388\n225#1:396\n225#1:397,3\n254#1:400\n254#1:401,2\n115#1:378,7\n211#1:389\n211#1:390,6\n355#1:405,7\n270#1:403,2\n360#1:412,2\n*E\n"})
public final class RemoteDocumentLevelMonitorRunner
extends MonitorRunner {
    private final Logger logger = LogManager.getLogger(this.getClass());

    /*
     * Exception decompiling
     */
    @Override
    @Nullable
    public Object runMonitor(@NotNull Monitor var1_1, @NotNull MonitorRunnerExecutionContext var2_2, @NotNull Instant var3_3, @NotNull Instant var4_4, boolean var5_5, @Nullable WorkflowRunContext var6_6, @NotNull String var7_7, @NotNull TransportService var8_8, @NotNull Continuation<? super MonitorRunResult<?>> var9_9) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void validate(Monitor monitor) {
        if (monitor.getInputs().size() > 1) {
            throw new IOException("Only one input is supported with remote document-level-monitor.");
        }
        if (!Intrinsics.areEqual((Object)((Input)monitor.getInputs().get(0)).name(), (Object)"remote_doc_level_monitor_input")) {
            throw new IOException("Invalid input with remote document-level-monitor.");
        }
        Object e = monitor.getInputs().get(0);
        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.opensearch.commons.alerting.model.remote.monitors.RemoteDocLevelMonitorInput");
        if (((RemoteDocLevelMonitorInput)e).getDocLevelMonitorInput().getIndices().isEmpty()) {
            throw new IllegalArgumentException("DocLevelMonitorInput has no indices");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, DiscoveryNode> getNodes(MonitorRunnerExecutionContext monitorCtx) {
        void $this$filterTo$iv$iv;
        ClusterService clusterService = monitorCtx.getClusterService();
        Intrinsics.checkNotNull((Object)clusterService);
        Map map = clusterService.state().getNodes().getDataNodes();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getDataNodes(...)");
        Map $this$filter$iv = map;
        boolean $i$f$filter = false;
        Map map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(((DiscoveryNode)it.getValue()).getVersion().compareTo(Version.CURRENT) >= 0)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Set<ShardId>> distributeShards(MonitorRunnerExecutionContext monitorCtx, List<String> allNodes, List<String> shards) {
        void $this$mapTo$iv$iv;
        int totalShards = shards.size();
        int numFanOutNodes = RangesKt.coerceAtMost((int)allNodes.size(), (int)((totalShards + 1) / 2));
        int totalNodes = RangesKt.coerceAtMost((int)monitorCtx.getTotalNodesFanOut(), (int)numFanOutNodes);
        int shardsPerNode = totalShards / totalNodes;
        int shardsRemaining = totalShards % totalNodes;
        Iterable $this$map$iv = shards;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{":"};
            String index = (String)StringsKt.split$default((CharSequence)((CharSequence)it), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0);
            String[] stringArray2 = new String[]{":"};
            String shardId = (String)StringsKt.split$default((CharSequence)((CharSequence)it), (String[])stringArray2, (boolean)false, (int)0, (int)6, null).get(1);
            ClusterService clusterService = monitorCtx.getClusterService();
            Intrinsics.checkNotNull((Object)clusterService);
            collection.add(new ShardId(clusterService.state().getMetadata().index(index).getIndex(), Integer.parseInt(shardId)));
        }
        List shardIdList = (List)destination$iv$iv;
        List<String> nodes = allNodes.subList(0, totalNodes);
        Map nodeShardAssignments = new LinkedHashMap();
        int idx = 0;
        for (String node : nodes) {
            Set nodeShardAssignment = new LinkedHashSet();
            int i = 1;
            if (i <= shardsPerNode) {
                while (true) {
                    nodeShardAssignment.add(shardIdList.get(idx++));
                    if (i == shardsPerNode) break;
                    ++i;
                }
            }
            nodeShardAssignments.put(node, nodeShardAssignment);
        }
        for (String node : nodes) {
            if (shardsRemaining == 0) break;
            Object v = nodeShardAssignments.get(node);
            Intrinsics.checkNotNull(v);
            ((Set)v).add(shardIdList.get(idx++));
            --shardsRemaining;
        }
        return nodeShardAssignments;
    }

    /*
     * WARNING - void declaration
     */
    private final int getShardsCount(ClusterService clusterService, String index) {
        void $this$filterTo$iv$iv;
        ClusterService clusterService2 = clusterService;
        Intrinsics.checkNotNull((Object)clusterService2);
        List list = clusterService2.state().routingTable().allShards(index);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"allShards(...)");
        List allShards = list;
        Iterable $this$filter$iv = allShards;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ShardRouting it = (ShardRouting)element$iv$iv;
            boolean bl = false;
            if (!it.primary()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return ((List)destination$iv$iv).size();
    }

    private final void updateLastRunContextFromFanOutResponses(List<DocLevelMonitorFanOutResponse> docLevelMonitorFanOutResponses, Map<String, Map<String, Object>> updatedLastRunContext) {
        for (String indexName : updatedLastRunContext.keySet()) {
            for (DocLevelMonitorFanOutResponse fanOutResponse : docLevelMonitorFanOutResponses) {
                if (fanOutResponse.getException() != null) continue;
                Map<String, Object> map = updatedLastRunContext.get(indexName);
                Intrinsics.checkNotNull(map, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
                Map indexLastRunContext = TypeIntrinsics.asMutableMap(map);
                if (!fanOutResponse.getLastRunContexts().containsKey(indexName)) continue;
                Object v = fanOutResponse.getLastRunContexts().get(indexName);
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                Map $this$forEach$iv = (Map)v;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator.next();
                    boolean bl = false;
                    Long seq_no = StringsKt.toLongOrNull((String)it.getValue().toString());
                    if (Intrinsics.areEqual(it.getKey(), (Object)"shards_count") || Intrinsics.areEqual(it.getKey(), (Object)"index") || seq_no == null || seq_no < 0L) continue;
                    indexLastRunContext.put(it.getKey(), seq_no);
                }
            }
        }
    }

    private final Map<String, DocumentLevelTriggerRunResult> buildTriggerResults(List<DocLevelMonitorFanOutResponse> docLevelMonitorFanOutResponses) {
        Map triggerResults = new LinkedHashMap();
        Map triggerErrorMap = new LinkedHashMap();
        for (DocLevelMonitorFanOutResponse res2 : docLevelMonitorFanOutResponses) {
            if (res2.getException() != null) continue;
            for (String triggerId : res2.getTriggerResults().keySet()) {
                DocumentLevelTriggerRunResult documentLevelTriggerRunResult = (DocumentLevelTriggerRunResult)res2.getTriggerResults().get(triggerId);
                if (documentLevelTriggerRunResult == null) continue;
                if (!triggerResults.containsKey(triggerId)) {
                    List list;
                    List error;
                    triggerResults.put(triggerId, documentLevelTriggerRunResult);
                    Map map = triggerErrorMap;
                    if (documentLevelTriggerRunResult.getError() != null) {
                        AlertingException alertingException;
                        if (documentLevelTriggerRunResult.getError() instanceof AlertingException) {
                            Exception exception = documentLevelTriggerRunResult.getError();
                            Intrinsics.checkNotNull((Object)exception, (String)"null cannot be cast to non-null type org.opensearch.commons.alerting.util.AlertingException");
                            alertingException = (AlertingException)exception;
                        } else {
                            Exception exception = documentLevelTriggerRunResult.getError();
                            Intrinsics.checkNotNull((Object)exception);
                            OpenSearchException openSearchException = AlertingException.Companion.wrap(exception);
                            Intrinsics.checkNotNull((Object)openSearchException, (String)"null cannot be cast to non-null type org.opensearch.commons.alerting.util.AlertingException");
                            alertingException = (AlertingException)openSearchException;
                        }
                        error = alertingException;
                        Object[] objectArray = new AlertingException[]{error};
                        list = CollectionsKt.mutableListOf((Object[])objectArray);
                    } else {
                        list = new ArrayList();
                    }
                    error = list;
                    map.put(triggerId, error);
                    continue;
                }
                DocumentLevelTriggerRunResult currVal = (DocumentLevelTriggerRunResult)triggerResults.get(triggerId);
                List newTriggeredDocs = new ArrayList();
                DocumentLevelTriggerRunResult documentLevelTriggerRunResult2 = currVal;
                Intrinsics.checkNotNull((Object)documentLevelTriggerRunResult2);
                newTriggeredDocs.addAll(documentLevelTriggerRunResult2.getTriggeredDocs());
                newTriggeredDocs.addAll(documentLevelTriggerRunResult.getTriggeredDocs());
                Map newActionResults = new LinkedHashMap();
                newActionResults.putAll(currVal.getActionResultsMap());
                newActionResults.putAll(documentLevelTriggerRunResult.getActionResultsMap());
                triggerResults.put(triggerId, DocumentLevelTriggerRunResult.copy$default((DocumentLevelTriggerRunResult)currVal, null, (List)newTriggeredDocs, null, (Map)newActionResults, (int)5, null));
                if (documentLevelTriggerRunResult.getError() == null) continue;
                Object v = triggerErrorMap.get(triggerId);
                Intrinsics.checkNotNull(v);
                List list = (List)v;
                Exception exception = documentLevelTriggerRunResult.getError();
                Intrinsics.checkNotNull((Object)exception, (String)"null cannot be cast to non-null type org.opensearch.commons.alerting.util.AlertingException");
                list.add((AlertingException)exception);
            }
        }
        triggerErrorMap.forEach((arg_0, arg_1) -> RemoteDocumentLevelMonitorRunner.buildTriggerResults$lambda$9((Function2)new Function2<String, List<AlertingException>, Unit>((Map<String, DocumentLevelTriggerRunResult>)triggerResults){
            final /* synthetic */ Map<String, DocumentLevelTriggerRunResult> $triggerResults;
            {
                this.$triggerResults = $triggerResults;
                super(2);
            }

            public final void invoke(@NotNull String triggerId, @NotNull List<AlertingException> errorList) {
                Intrinsics.checkNotNullParameter((Object)triggerId, (String)"triggerId");
                Intrinsics.checkNotNullParameter(errorList, (String)"errorList");
                if (!((Collection)errorList).isEmpty()) {
                    DocumentLevelTriggerRunResult documentLevelTriggerRunResult = this.$triggerResults.get(triggerId);
                    Intrinsics.checkNotNull((Object)documentLevelTriggerRunResult);
                    Collection $this$toTypedArray$iv = errorList;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    AlertingException[] alertingExceptionArray = thisCollection$iv.toArray(new AlertingException[0]);
                    documentLevelTriggerRunResult.setError((Exception)AlertingException.Companion.merge(Arrays.copyOf(alertingExceptionArray, alertingExceptionArray.length)));
                }
            }
        }, arg_0, arg_1));
        return triggerResults;
    }

    private final InputRunResults buildInputRunResults(List<DocLevelMonitorFanOutResponse> docLevelMonitorFanOutResponses) {
        AlertingException alertingException;
        Map inputRunResults = new LinkedHashMap();
        List errors = new ArrayList();
        for (DocLevelMonitorFanOutResponse response2 : docLevelMonitorFanOutResponses) {
            if (response2.getException() != null) continue;
            if (response2.getInputResults().getError() != null) {
                if (response2.getInputResults().getError() instanceof AlertingException) {
                    Exception exception = response2.getInputResults().getError();
                    Intrinsics.checkNotNull((Object)exception, (String)"null cannot be cast to non-null type org.opensearch.commons.alerting.util.AlertingException");
                    errors.add((AlertingException)exception);
                } else {
                    Exception exception = response2.getInputResults().getError();
                    Intrinsics.checkNotNull((Object)exception, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                    OpenSearchException openSearchException = AlertingException.Companion.wrap(exception);
                    Intrinsics.checkNotNull((Object)openSearchException, (String)"null cannot be cast to non-null type org.opensearch.commons.alerting.util.AlertingException");
                    errors.add((AlertingException)openSearchException);
                }
            }
            List partialResult = response2.getInputResults().getResults();
            for (Map result : partialResult) {
                for (String id : result.keySet()) {
                    Object object;
                    Map $this$getOrPut$iv = inputRunResults;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(id);
                    if (value$iv == null) {
                        boolean bl = false;
                        Set answer$iv = new LinkedHashSet();
                        $this$getOrPut$iv.put(id, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    Set set = (Set)object;
                    Object v = result.get(id);
                    Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.Collection<kotlin.String>");
                    set.addAll((Collection)v);
                }
            }
        }
        List list = CollectionsKt.listOf((Object)inputRunResults);
        if (!errors.isEmpty()) {
            Collection $this$toTypedArray$iv = errors;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            AlertingException[] alertingExceptionArray = thisCollection$iv.toArray(new AlertingException[0]);
            alertingException = AlertingException.Companion.merge(Arrays.copyOf(alertingExceptionArray, alertingExceptionArray.length));
        } else {
            alertingException = null;
        }
        return new InputRunResults(list, (Exception)alertingException, null, 4, null);
    }

    private final boolean createdRecently(Monitor monitor, Instant periodStart, Instant periodEnd, IndexMetadata indexMetadata) {
        Instant lastExecutionTime = Intrinsics.areEqual((Object)periodStart, (Object)periodEnd) ? monitor.getLastUpdateTime() : periodStart;
        String string = indexMetadata.getSettings().get("index.creation_date");
        long indexCreationDate = string != null ? Long.parseLong(string) : 0L;
        return indexCreationDate > lastExecutionTime.toEpochMilli();
    }

    private static final void buildTriggerResults$lambda$9(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }
}

