/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet.mmd2;

import java.io.IOException;
import java.math.BigInteger;
import org.musicbrainz.mmd2.Cdstub;
import org.musicbrainz.mmd2.CdstubList;
import org.musicbrainz.mmd2.Metadata;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.index.CDStubIndexField;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.servlet.Result;
import org.musicbrainz.search.servlet.Results;
import org.musicbrainz.search.servlet.mmd2.ResultsWriter;

public class CDStubWriter
extends ResultsWriter {
    public void write(Metadata metadata, Results results) throws IOException {
        ObjectFactory of = new ObjectFactory();
        CdstubList cdstubList = of.createCdstubList();
        for (Result result : results.results) {
            String numTracks;
            String barcode;
            MbDocument doc = result.getDoc();
            Cdstub cdstub = of.createCdstub();
            String artist = doc.get((IndexField)CDStubIndexField.ARTIST);
            if (artist != null) {
                cdstub.setArtist(artist);
            } else {
                cdstub.setArtist("");
            }
            String title = doc.get((IndexField)CDStubIndexField.TITLE);
            if (title != null) {
                cdstub.setTitle(title);
            } else {
                cdstub.setTitle("");
            }
            String discid = doc.get((IndexField)CDStubIndexField.DISCID);
            if (discid != null) {
                cdstub.setId(discid);
            } else {
                cdstub.setId("");
            }
            String comment = doc.get((IndexField)CDStubIndexField.COMMENT);
            if (this.isNotNoValue(comment)) {
                cdstub.setComment(comment);
            }
            if ((barcode = doc.get((IndexField)CDStubIndexField.BARCODE)) != null) {
                cdstub.setBarcode(barcode);
            }
            if ((numTracks = doc.get((IndexField)CDStubIndexField.NUM_TRACKS)) != null) {
                Cdstub.TrackList trackList = of.createCdstubTrackList();
                trackList.setCount(new BigInteger(numTracks));
                cdstub.setTrackList(trackList);
            }
            result.setNormalizedScore(results.getMaxScore());
            cdstub.setScore(String.valueOf(result.getNormalizedScore()));
            cdstubList.getCdstub().add(cdstub);
        }
        cdstubList.setCount(BigInteger.valueOf(results.getTotalHits()));
        cdstubList.setOffset(BigInteger.valueOf(results.getOffset()));
        metadata.setCdstubList(cdstubList);
    }
}

