/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.musicbrainz.search.index.PlaceIndexField;

public class PlaceQueryParser
extends MultiFieldQueryParser {
    public PlaceQueryParser(String[] strings, Analyzer analyzer) {
        super(strings, analyzer);
    }

    protected Query newTermQuery(Term term) {
        if (term.field().equals(PlaceIndexField.LAT.getName()) || term.field().equals(PlaceIndexField.LONG.getName())) {
            try {
                float floatnumber = Float.parseFloat(term.text());
                BytesRefBuilder bytes = new BytesRefBuilder();
                NumericUtils.intToPrefixCoded((int)NumericUtils.floatToSortableInt((float)floatnumber), (int)0, (BytesRefBuilder)bytes);
                TermQuery tq = new TermQuery(new Term(term.field(), bytes.toBytesRef().utf8ToString()));
                return tq;
            }
            catch (NumberFormatException nfe) {
                return super.newTermQuery(term);
            }
        }
        return super.newTermQuery(term);
    }

    public Query newRangeQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) {
        if (field.equals(PlaceIndexField.LONG.getName()) || field.equals(PlaceIndexField.LAT.getName())) {
            BytesRefBuilder bytes1 = new BytesRefBuilder();
            BytesRefBuilder bytes2 = new BytesRefBuilder();
            NumericUtils.intToPrefixCoded((int)NumericUtils.floatToSortableInt((float)Float.parseFloat(part1)), (int)0, (BytesRefBuilder)bytes1);
            NumericUtils.intToPrefixCoded((int)NumericUtils.floatToSortableInt((float)Float.parseFloat(part2)), (int)0, (BytesRefBuilder)bytes2);
            part1 = bytes1.toBytesRef().utf8ToString();
            part2 = bytes2.toBytesRef().utf8ToString();
        }
        TermRangeQuery query = (TermRangeQuery)super.newRangeQuery(field, part1, part2, startInclusive, endInclusive);
        return query;
    }
}

