/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.util;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.WordlistLoader;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;

public abstract class StopwordAnalyzerBase
extends Analyzer {
    protected final CharArraySet stopwords;

    public CharArraySet getStopwordSet() {
        return this.stopwords;
    }

    protected StopwordAnalyzerBase(CharArraySet stopwords) {
        this.stopwords = stopwords == null ? CharArraySet.EMPTY_SET : CharArraySet.unmodifiableSet(CharArraySet.copy(stopwords));
    }

    @Deprecated
    protected StopwordAnalyzerBase(Version version, CharArraySet stopwords) {
        this.stopwords = stopwords == null ? CharArraySet.EMPTY_SET : CharArraySet.unmodifiableSet(CharArraySet.copy(version, stopwords));
        this.setVersion(version);
    }

    protected StopwordAnalyzerBase() {
        this((CharArraySet)null);
    }

    @Deprecated
    protected StopwordAnalyzerBase(Version version) {
        this(version, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static CharArraySet loadStopwordSet(boolean ignoreCase, Class<? extends Analyzer> aClass, String resource, String comment) throws IOException {
        CharArraySet charArraySet;
        Reader reader = null;
        try {
            reader = IOUtils.getDecodingReader(aClass.getResourceAsStream(resource), StandardCharsets.UTF_8);
            charArraySet = WordlistLoader.getWordSet(reader, comment, new CharArraySet(16, ignoreCase));
        }
        catch (Throwable throwable) {
            IOUtils.close(reader);
            throw throwable;
        }
        IOUtils.close(reader);
        return charArraySet;
    }

    protected static CharArraySet loadStopwordSet(File stopwords) throws IOException {
        return StopwordAnalyzerBase.loadStopwordSet(stopwords, Version.LATEST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected static CharArraySet loadStopwordSet(File stopwords, Version matchVersion) throws IOException {
        CharArraySet charArraySet;
        Reader reader = null;
        try {
            reader = IOUtils.getDecodingReader(stopwords, StandardCharsets.UTF_8);
            charArraySet = WordlistLoader.getWordSet(reader, matchVersion);
        }
        catch (Throwable throwable) {
            IOUtils.close(reader);
            throw throwable;
        }
        IOUtils.close(reader);
        return charArraySet;
    }

    protected static CharArraySet loadStopwordSet(Reader stopwords) throws IOException {
        return StopwordAnalyzerBase.loadStopwordSet(stopwords, Version.LATEST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected static CharArraySet loadStopwordSet(Reader stopwords, Version matchVersion) throws IOException {
        CharArraySet charArraySet;
        try {
            charArraySet = WordlistLoader.getWordSet(stopwords, matchVersion);
        }
        catch (Throwable throwable) {
            IOUtils.close(stopwords);
            throw throwable;
        }
        IOUtils.close(stopwords);
        return charArraySet;
    }
}

