/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.musicbrainz.search.analysis.MusicbrainzTokenizer;

public class MusicbrainzTokenizerFilter
extends TokenFilter {
    private static final String APOSTROPHE_TYPE = MusicbrainzTokenizer.TOKEN_TYPES[1];
    private static final String ACRONYM_TYPE = MusicbrainzTokenizer.TOKEN_TYPES[2];
    private static final String ALPHANUMANDPUNCTUATION = MusicbrainzTokenizer.TOKEN_TYPES[4];
    private TypeAttribute typeAtt;
    private CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);

    public MusicbrainzTokenizerFilter(TokenStream in) {
        super(in);
        this.typeAtt = this.addAttribute(TypeAttribute.class);
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        char[] buffer = this.termAtt.buffer();
        int bufferLength = this.termAtt.length();
        String type = this.typeAtt.type();
        if (type == MusicbrainzTokenizer.TOKEN_TYPES[7]) {
            this.typeAtt.setType("<IDEOGRAPHIC>");
        }
        if (type == APOSTROPHE_TYPE) {
            int upto = 0;
            for (int i = 0; i < bufferLength; ++i) {
                char c = buffer[i];
                if (c == '\'') continue;
                buffer[upto++] = c;
            }
            this.termAtt.setLength(upto);
        } else if (type == ACRONYM_TYPE) {
            int upto = 0;
            for (int i = 0; i < bufferLength; ++i) {
                char c = buffer[i];
                if (c == '.') continue;
                buffer[upto++] = c;
            }
            this.termAtt.setLength(upto);
        } else if (type == ALPHANUMANDPUNCTUATION) {
            int upto = 0;
            for (int i = 0; i < bufferLength; ++i) {
                int c = buffer[i];
                if (c == 39) continue;
                buffer[upto++] = !Character.isLetterOrDigit((char)c) ? 45 : c;
            }
            this.termAtt.setLength(upto);
        }
        return true;
    }
}

