/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.LongDocValues;
import org.apache.lucene.queries.function.valuesource.DocValuesFieldSource;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

public class DateDocValuesFieldSource
extends DocValuesFieldSource {
    public DateDocValuesFieldSource(String fieldName, boolean direct) {
        super(fieldName, direct);
    }

    @Override
    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        DocValues.Source source = this.getSource(readerContext.reader(), DocValues.Type.FIXED_INTS_64);
        Bits liveDocs = readerContext.reader().getLiveDocs();
        switch (source.getType()) {
            case FIXED_INTS_64: 
            case VAR_INTS: {
                if (source.hasArray() && source.getArray() instanceof long[]) {
                    final long[] values = (long[])source.getArray();
                    return new DVDateValues(this, source, liveDocs){

                        @Override
                        public long longVal(int doc) {
                            return values[doc];
                        }
                    };
                }
                return new DVDateValues(this, source, liveDocs);
            }
        }
        throw new IllegalStateException(this.getClass().getSimpleName() + " only works with 64-bits integer types, not " + (Object)((Object)source.getType()));
    }

    protected String dateToString(Date date) {
        return date.toString();
    }

    private class DVDateValues
    extends LongDocValues {
        private final Bits liveDocs;
        private final DocValues.Source source;

        public DVDateValues(ValueSource vs, DocValues.Source source, Bits liveDocs) {
            super(vs);
            this.liveDocs = liveDocs;
            this.source = source;
        }

        @Override
        public boolean exists(int doc) {
            return this.liveDocs == null || this.liveDocs.get(doc);
        }

        @Override
        public long longVal(int doc) {
            return this.source.getInt(doc);
        }

        @Override
        public boolean bytesVal(int doc, BytesRef target) {
            this.source.getBytes(doc, target);
            return true;
        }

        @Override
        public Date objectVal(int doc) {
            return new Date(this.longVal(doc));
        }

        @Override
        public String strVal(int doc) {
            return DateDocValuesFieldSource.this.dateToString(this.objectVal(doc));
        }
    }
}

