/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.icu.segmentation;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.DictionaryBasedBreakIterator;
import com.ibm.icu.text.RuleBasedBreakIterator;
import com.ibm.icu.text.UTF16;
import java.text.CharacterIterator;
import org.apache.lucene.analysis.icu.segmentation.CharArrayIterator;

abstract class BreakIteratorWrapper {
    protected final CharArrayIterator textIterator = new CharArrayIterator();
    protected char[] text;
    protected int start;
    protected int length;

    BreakIteratorWrapper() {
    }

    abstract int next();

    abstract int current();

    abstract int getRuleStatus();

    abstract void setText(CharacterIterator var1);

    void setText(char[] text, int start, int length) {
        this.text = text;
        this.start = start;
        this.length = length;
        this.textIterator.setText(text, start, length);
        this.setText(this.textIterator);
    }

    static BreakIteratorWrapper wrap(BreakIterator breakIterator) {
        if (breakIterator instanceof RuleBasedBreakIterator && !(breakIterator instanceof DictionaryBasedBreakIterator)) {
            return new RBBIWrapper((RuleBasedBreakIterator)breakIterator);
        }
        return new BIWrapper(breakIterator);
    }

    static final class BIWrapper
    extends BreakIteratorWrapper {
        private final BreakIterator bi;
        private int status;

        BIWrapper(BreakIterator bi) {
            this.bi = bi;
        }

        @Override
        int current() {
            return this.bi.current();
        }

        @Override
        int getRuleStatus() {
            return this.status;
        }

        @Override
        int next() {
            int current = this.bi.current();
            int next = this.bi.next();
            this.status = this.calcStatus(current, next);
            return next;
        }

        private int calcStatus(int current, int next) {
            int codepoint;
            if (current == -1 || next == -1) {
                return 0;
            }
            int begin = this.start + current;
            int end = this.start + next;
            for (int i = begin; i < end; i += UTF16.getCharCount(codepoint)) {
                codepoint = UTF16.charAt(this.text, 0, end, begin);
                if (UCharacter.isDigit(codepoint)) {
                    return 100;
                }
                if (!UCharacter.isLetter(codepoint)) continue;
                return 200;
            }
            return 0;
        }

        @Override
        void setText(CharacterIterator text) {
            this.bi.setText(text);
            this.status = 0;
        }
    }

    static final class RBBIWrapper
    extends BreakIteratorWrapper {
        private final RuleBasedBreakIterator rbbi;

        RBBIWrapper(RuleBasedBreakIterator rbbi) {
            this.rbbi = rbbi;
        }

        @Override
        int current() {
            return this.rbbi.current();
        }

        @Override
        int getRuleStatus() {
            return this.rbbi.getRuleStatus();
        }

        @Override
        int next() {
            return this.rbbi.next();
        }

        @Override
        void setText(CharacterIterator text) {
            this.rbbi.setText(text);
        }
    }
}

