/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.icu;

import com.ibm.icu.text.Transliterator;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.icu.ICUTransformFilter;
import org.apache.lucene.analysis.util.AbstractAnalysisFactory;
import org.apache.lucene.analysis.util.MultiTermAwareComponent;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class ICUTransformFilterFactory
extends TokenFilterFactory
implements MultiTermAwareComponent {
    private Transliterator transliterator;

    @Override
    public void init(Map<String, String> args) {
        int dir;
        super.init(args);
        String id = args.get("id");
        if (id == null) {
            throw new IllegalArgumentException("id is required.");
        }
        String direction = args.get("direction");
        if (direction == null || direction.equalsIgnoreCase("forward")) {
            dir = 0;
        } else if (direction.equalsIgnoreCase("reverse")) {
            dir = 1;
        } else {
            throw new IllegalArgumentException("invalid direction: " + direction);
        }
        this.transliterator = Transliterator.getInstance(id, dir);
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new ICUTransformFilter(input, this.transliterator);
    }

    @Override
    public AbstractAnalysisFactory getMultiTermComponent() {
        return this;
    }
}

