/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.index;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.similarities.Similarity;
import org.musicbrainz.mmd2.Tag;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.analysis.ReleaseGroupSimilarity;
import org.musicbrainz.search.helper.ArtistCreditHelper;
import org.musicbrainz.search.helper.ArtistCreditWrapper;
import org.musicbrainz.search.helper.ReleaseGroupHelper;
import org.musicbrainz.search.helper.ReleaseWrapper;
import org.musicbrainz.search.helper.TagHelper;
import org.musicbrainz.search.index.DatabaseIndex;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.ReleaseGroupIndexField;

public class ReleaseGroupIndex
extends DatabaseIndex {
    public static final String INDEX_NAME = "releasegroup";

    public ReleaseGroupIndex(Connection dbConnection) {
        super(dbConnection);
    }

    public ReleaseGroupIndex() {
    }

    @Override
    public String getName() {
        return INDEX_NAME;
    }

    @Override
    public Analyzer getAnalyzer() {
        return DatabaseIndex.getAnalyzer(ReleaseGroupIndexField.class);
    }

    @Override
    public IndexField getIdentifierField() {
        return ReleaseGroupIndexField.ID;
    }

    @Override
    public int getMaxId() throws SQLException {
        Statement st = this.dbConnection.createStatement();
        ResultSet rs = st.executeQuery("SELECT MAX(id) FROM release_group");
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public int getNoOfRows(int maxId) throws SQLException {
        Statement st = this.dbConnection.createStatement();
        ResultSet rs = st.executeQuery("SELECT count(*) FROM release_group WHERE id<=" + maxId);
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public Similarity getSimilarity() {
        return new ReleaseGroupSimilarity();
    }

    @Override
    public void init(IndexWriter indexWriter, boolean isUpdater) throws SQLException {
        this.addPreparedStatement("TAGS", TagHelper.constructTagQuery("release_group_tag", "release_group"));
        this.addPreparedStatement("RELEASES", "SELECT DISTINCT release_group, release.gid as gid, release.name, rs.name as status  FROM release   LEFT JOIN release_status rs ON release.status = rs.id  WHERE release_group BETWEEN ? AND ?");
        this.addPreparedStatement("ARTISTCREDITS", "SELECT r.id as releaseGroupId,   a.artist_credit,   a.pos,   a.joinphrase,   a.artistId,    a.comment,   a.artistName,   a.artistCreditName,   a.artistSortName  FROM release_group AS r   INNER JOIN tmp_artistcredit a ON r.artist_credit=a.artist_credit  WHERE r.id BETWEEN ? AND ?   ORDER BY r.id, a.pos");
        this.addPreparedStatement("ARTISTCREDITALIASES", "SELECT r.id as releaseGroupId, a.artist_credit,  a.pos,  aa.name, aa.sort_name, aa.primary_for_locale, aa.locale, aa.begin_date_year, aa.begin_date_month, aa.begin_date_day, aa.end_date_year, aa.end_date_month, aa.end_date_day, att.name as type FROM release_group AS r   INNER JOIN tmp_artistcredit a ON r.artist_credit=a.artist_credit   INNER JOIN artist_alias aa ON a.id=aa.artist  LEFT  JOIN artist_alias_type att on (aa.type=att.id) WHERE r.id BETWEEN ? AND ?   AND a.artistId!='89ad4ac3-39f7-470e-963a-56509c546377' AND a.artistId!='125ec42a-7229-4250-afc5-e057484327fe' ORDER BY r.id, a.pos, aa.name");
        this.addPreparedStatement("SECONDARYTYPES", "SELECT rg.name as type, rgj.release_group as release_group  FROM release_group_secondary_type_join rgj  INNER JOIN release_group_secondary_type rg ON rgj.secondary_type = rg.id  WHERE rgj.release_group BETWEEN ? AND ?");
        this.addPreparedStatement("RELEASEGROUPS", "SELECT rg.id, rg.gid, rg.name as name, release_group_primary_type.name as type, rg.comment  FROM release_group AS rg   LEFT JOIN release_group_primary_type ON rg.type = release_group_primary_type.id  WHERE rg.id BETWEEN ? AND ? ORDER BY rg.id");
    }

    @Override
    public void indexData(IndexWriter indexWriter, int min, int max) throws SQLException, IOException {
        Map<Integer, List<Tag>> tags = TagHelper.loadTags(min, max, this.getPreparedStatement("TAGS"), "release_group");
        Map<Integer, List<ReleaseWrapper>> releases = this.loadReleases(min, max);
        Map<Integer, ArtistCreditWrapper> artistCredits = this.updateArtistCreditWithAliases(this.loadArtistCredits(min, max), min, max);
        Map<Integer, List<String>> secondaryTypes = this.loadSecondaryTypes(min, max);
        PreparedStatement st = this.getPreparedStatement("RELEASEGROUPS");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            indexWriter.addDocument(this.documentFromResultSet(rs, secondaryTypes, tags, releases, artistCredits));
        }
        rs.close();
    }

    private Map<Integer, List<ReleaseWrapper>> loadReleases(int min, int max) throws SQLException, IOException {
        HashMap<Integer, List<ReleaseWrapper>> releases = new HashMap<Integer, List<ReleaseWrapper>>();
        PreparedStatement st = this.getPreparedStatement("RELEASES");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            List<ReleaseWrapper> list;
            int rgId = rs.getInt("release_group");
            if (!releases.containsKey(rgId)) {
                list = new LinkedList();
                releases.put(rgId, list);
            } else {
                list = (List)releases.get(rgId);
            }
            ReleaseWrapper rw = new ReleaseWrapper();
            rw.setReleaseId(rs.getString("gid"));
            rw.setReleaseName(rs.getString("name"));
            rw.setStatus(rs.getString("status"));
            list.add(rw);
        }
        rs.close();
        return releases;
    }

    private Map<Integer, ArtistCreditWrapper> loadArtistCredits(int min, int max) throws SQLException, IOException {
        PreparedStatement st = this.getPreparedStatement("ARTISTCREDITS");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        Map<Integer, ArtistCreditWrapper> artistCredits = ArtistCreditHelper.completeArtistCreditFromDbResults(rs, "releaseGroupId", "artist_Credit", "artistId", "artistName", "artistSortName", "comment", "joinphrase", "artistCreditName");
        rs.close();
        return artistCredits;
    }

    private Map<Integer, ArtistCreditWrapper> updateArtistCreditWithAliases(Map<Integer, ArtistCreditWrapper> artistCredits, int min, int max) throws SQLException, IOException {
        PreparedStatement st = this.getPreparedStatement("ARTISTCREDITALIASES");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        return ArtistCreditHelper.updateArtistCreditWithAliases(artistCredits, "releaseGroupId", rs);
    }

    private Map<Integer, List<String>> loadSecondaryTypes(int min, int max) throws SQLException, IOException {
        HashMap<Integer, List<String>> secondaryTypes = new HashMap<Integer, List<String>>();
        PreparedStatement st = this.getPreparedStatement("SECONDARYTYPES");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            List<String> list;
            int rgId = rs.getInt("release_group");
            if (!secondaryTypes.containsKey(rgId)) {
                list = new LinkedList();
                secondaryTypes.put(rgId, list);
            } else {
                list = (List)secondaryTypes.get(rgId);
            }
            list.add(rs.getString("type"));
        }
        rs.close();
        return secondaryTypes;
    }

    public Document documentFromResultSet(ResultSet rs, Map<Integer, List<String>> secondaryTypes, Map<Integer, List<Tag>> tags, Map<Integer, List<ReleaseWrapper>> releases, Map<Integer, ArtistCreditWrapper> artistCredits) throws SQLException {
        MbDocument doc = new MbDocument();
        int id = rs.getInt("id");
        doc.addField((IndexField)ReleaseGroupIndexField.ID, id);
        doc.addField((IndexField)ReleaseGroupIndexField.RELEASEGROUP_ID, rs.getString("gid"));
        String name = rs.getString("name");
        doc.addField((IndexField)ReleaseGroupIndexField.RELEASEGROUP, name);
        doc.addField((IndexField)ReleaseGroupIndexField.RELEASEGROUP_ACCENT, name);
        String primaryType = rs.getString("type");
        doc.addFieldOrUnknown(ReleaseGroupIndexField.PRIMARY_TYPE, primaryType);
        if (secondaryTypes.containsKey(id)) {
            for (String secondaryType : secondaryTypes.get(id)) {
                doc.addField((IndexField)ReleaseGroupIndexField.SECONDARY_TYPE, secondaryType);
            }
        }
        String type = ReleaseGroupHelper.calculateOldTypeFromPrimaryType(primaryType, secondaryTypes.get(id));
        doc.addFieldOrUnknown(ReleaseGroupIndexField.TYPE, type);
        doc.addFieldOrNoValue(ReleaseGroupIndexField.COMMENT, rs.getString("comment"));
        if (releases.containsKey(id)) {
            for (ReleaseWrapper release : releases.get(id)) {
                doc.addFieldOrNoValue(ReleaseGroupIndexField.RELEASE, release.getReleaseName());
                doc.addFieldOrNoValue(ReleaseGroupIndexField.RELEASE_ID, release.getReleaseId());
                doc.addFieldOrNoValue(ReleaseGroupIndexField.RELEASESTATUS, release.getStatus());
            }
            doc.addNumericField((IndexField)ReleaseGroupIndexField.NUM_RELEASES, releases.get(id).size());
        } else {
            doc.addNumericField((IndexField)ReleaseGroupIndexField.NUM_RELEASES, 0);
        }
        ArtistCreditWrapper ac = artistCredits.get(id);
        if (ac != null) {
            ArtistCreditHelper.buildIndexFieldsFromArtistCredit(doc, ac.getArtistCredit(), ReleaseGroupIndexField.ARTIST, ReleaseGroupIndexField.ARTIST_NAMECREDIT, ReleaseGroupIndexField.ARTIST_ID, ReleaseGroupIndexField.ARTIST_NAME, ReleaseGroupIndexField.ARTIST_CREDIT);
        } else {
            System.out.println("\nNo artist credit found for releasegroup:" + rs.getString("gid"));
        }
        if (tags.containsKey(id)) {
            for (Tag tag : tags.get(id)) {
                doc.addField((IndexField)ReleaseGroupIndexField.TAG, tag.getName());
                doc.addField((IndexField)ReleaseGroupIndexField.TAGCOUNT, tag.getCount().toString());
            }
        }
        return doc.getLuceneDocument();
    }
}

