/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.index;

import com.google.common.base.Strings;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.time.StopWatch;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.similarities.Similarity;
import org.musicbrainz.mmd2.Artist;
import org.musicbrainz.mmd2.ArtistCredit;
import org.musicbrainz.mmd2.DefAreaElementInner;
import org.musicbrainz.mmd2.DefTrackData;
import org.musicbrainz.mmd2.Format;
import org.musicbrainz.mmd2.Iso31661CodeList;
import org.musicbrainz.mmd2.Isrc;
import org.musicbrainz.mmd2.IsrcList;
import org.musicbrainz.mmd2.Medium;
import org.musicbrainz.mmd2.MediumList;
import org.musicbrainz.mmd2.NameCredit;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.mmd2.PrimaryType;
import org.musicbrainz.mmd2.Recording;
import org.musicbrainz.mmd2.Release;
import org.musicbrainz.mmd2.ReleaseEvent;
import org.musicbrainz.mmd2.ReleaseGroup;
import org.musicbrainz.mmd2.ReleaseList;
import org.musicbrainz.mmd2.SecondaryType;
import org.musicbrainz.mmd2.Status;
import org.musicbrainz.mmd2.Tag;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.analysis.RecordingSimilarity;
import org.musicbrainz.search.helper.ArtistCreditHelper;
import org.musicbrainz.search.helper.ArtistCreditWrapper;
import org.musicbrainz.search.helper.ReleaseGroupHelper;
import org.musicbrainz.search.helper.TagHelper;
import org.musicbrainz.search.helper.TrackWrapper;
import org.musicbrainz.search.index.DatabaseIndex;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.MMDSerializer;
import org.musicbrainz.search.index.RecordingIndexField;
import org.musicbrainz.search.index.ReleaseEventComparator;
import org.musicbrainz.search.index.Utils;

public class RecordingIndex
extends DatabaseIndex {
    private static final String VARIOUS_ARTISTS_GUID = "89ad4ac3-39f7-470e-963a-56509c546377";
    private static final String VARIOUS_ARTISTS_NAME = "Various Artists";
    private static final int VARIOUS_ARTIST_CREDIT_ID = 1;
    public static final String INDEX_NAME = "recording";
    private StopWatch trackClock = new StopWatch();
    private StopWatch isrcClock = new StopWatch();
    private StopWatch artistClock = new StopWatch();
    private StopWatch trackArtistClock = new StopWatch();
    private StopWatch releaseClock = new StopWatch();
    private StopWatch recordingClock = new StopWatch();
    private StopWatch buildClock = new StopWatch();
    private StopWatch storeClock = new StopWatch();
    private static final int QUANTIZED_DURATION = 2000;
    String releases;
    String releaseArtistCredits;
    String releaseEvents;
    String releaseSecondaryTypes;

    public RecordingIndex(Connection dbConnection) {
        super(dbConnection);
        this.trackClock.start();
        this.isrcClock.start();
        this.artistClock.start();
        this.trackArtistClock.start();
        this.releaseClock.start();
        this.recordingClock.start();
        this.buildClock.start();
        this.storeClock.start();
        this.trackClock.suspend();
        this.isrcClock.suspend();
        this.artistClock.suspend();
        this.releaseClock.suspend();
        this.recordingClock.suspend();
        this.trackArtistClock.suspend();
        this.buildClock.suspend();
        this.storeClock.suspend();
    }

    public RecordingIndex() {
    }

    @Override
    public String getName() {
        return INDEX_NAME;
    }

    @Override
    public Analyzer getAnalyzer() {
        return DatabaseIndex.getAnalyzer(RecordingIndexField.class);
    }

    @Override
    public IndexField getIdentifierField() {
        return RecordingIndexField.ID;
    }

    @Override
    public int getMaxId() throws SQLException {
        Statement st = this.dbConnection.createStatement();
        ResultSet rs = st.executeQuery("SELECT MAX(id) FROM recording");
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public int getNoOfRows(int maxId) throws SQLException {
        Statement st = this.dbConnection.createStatement();
        ResultSet rs = st.executeQuery("SELECT count(*) FROM recording WHERE id<=" + maxId);
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public Similarity getSimilarity() {
        return new RecordingSimilarity();
    }

    @Override
    public void init(IndexWriter indexWriter, boolean isUpdater) throws SQLException {
        if (!isUpdater) {
            this.addPreparedStatement("TRACKS", "SELECT id, gid, track_name, length as duration, recording, track_position, track_number, track_count,   release_id, medium_position, format  FROM tmp_track  WHERE recording between ? AND ?");
        } else {
            this.addPreparedStatement("TRACKS", "SELECT t.id, t.gid, t.name as track_name, t.length as duration, t.recording, t.position as track_position, t.number as track_number, m.track_count,   m.release as release_id, m.position as medium_position,mf.name as format  FROM track t   INNER JOIN medium m ON t.medium=m.id   LEFT JOIN  medium_format mf ON m.format=mf.id  WHERE t.recording BETWEEN ? AND ?");
        }
        this.addPreparedStatement("TAGS", TagHelper.constructTagQuery("recording_tag", INDEX_NAME));
        this.addPreparedStatement("ISRCS", "SELECT recording as recordingId, isrc  FROM isrc  WHERE recording BETWEEN ? AND ?   ORDER BY recording, id");
        this.addPreparedStatement("ARTISTCREDITS", "SELECT r.id as recordingId,   a.artist_credit,   a.pos,   a.joinphrase,   a.artistId,    a.comment,   a.artistName,   a.artistCreditName,   a.artistSortName  FROM recording AS r   INNER JOIN tmp_artistcredit a ON r.artist_credit=a.artist_credit  WHERE r.id BETWEEN ? AND ?   ORDER BY r.id, a.pos");
        this.addPreparedStatement("ARTISTCREDITALIASES", "SELECT r.id as recordingId, a.artist_credit,  a.pos,  aa.name, aa.sort_name, aa.primary_for_locale, aa.locale, aa.begin_date_year, aa.begin_date_month, aa.begin_date_day, aa.end_date_year, aa.end_date_month, aa.end_date_day, att.name as type FROM recording AS r   INNER JOIN tmp_artistcredit a ON r.artist_credit=a.artist_credit   INNER JOIN artist_alias aa ON a.id=aa.artist  LEFT  JOIN artist_alias_type att on (aa.type=att.id) WHERE r.id BETWEEN ? AND ?   AND a.artistId!='89ad4ac3-39f7-470e-963a-56509c546377' AND a.artistId!='125ec42a-7229-4250-afc5-e057484327fe' ORDER BY r.id, a.pos, aa.name");
        this.addPreparedStatement("TRACKARTISTCREDITS", "SELECT t.id as id,   a.artist_credit,   a.pos,   a.joinphrase,   a.artistId,    a.comment,   a.artistName,   a.artistCreditName,   a.artistSortName  FROM track AS t   INNER JOIN tmp_artistcredit a ON t.artist_credit=a.artist_credit  WHERE t.recording BETWEEN ? AND ?   ORDER BY t.recording, a.pos");
        this.addPreparedStatement("TRACKARTISTCREDITALIASES", "SELECT r.id as recordingId, a.artist_credit,  a.pos,  aa.name, aa.sort_name, aa.primary_for_locale, aa.locale, aa.begin_date_year, aa.begin_date_month, aa.begin_date_day, aa.end_date_year, aa.end_date_month, aa.end_date_day, att.name as type FROM track AS r   INNER JOIN tmp_artistcredit a ON r.artist_credit=a.artist_credit   INNER JOIN artist_alias aa ON a.id=aa.artist  LEFT  JOIN artist_alias_type att on (aa.type=att.id) WHERE r.recording BETWEEN ? AND ?   AND a.artistId!='89ad4ac3-39f7-470e-963a-56509c546377' AND a.artistId!='125ec42a-7229-4250-afc5-e057484327fe' ORDER BY r.id, a.pos, aa.name");
        this.releaseArtistCredits = "SELECT r.id as releaseKey,   a.artist_credit,   a.pos,   a.joinphrase,   a.artistId,    a.comment,   a.artistName,   a.artistCreditName,   a.artistSortName  FROM release AS r   INNER JOIN tmp_artistcredit a ON r.artist_credit=a.artist_credit  WHERE a.artistId!='89ad4ac3-39f7-470e-963a-56509c546377' AND r.id in ";
        this.releases = "SELECT   id as releaseKey, gid as releaseid, name as releasename, type,   status, tracks,artist_credit, rg_gid  FROM tmp_release r1  WHERE r1.id in ";
        this.releaseEvents = " SELECT release, country,    date_year, date_month, date_day, name, gid FROM tmp_release_event r  WHERE r.release in ";
        this.releaseSecondaryTypes = "SELECT rg.name as type, r.id as releaseKey FROM tmp_release r  INNER JOIN release_group_secondary_type_join  rgj  ON r.rg_id=rgj.release_group  INNER JOIN release_group_secondary_type rg   ON rgj.secondary_type = rg.id  WHERE r.id in ";
        this.addPreparedStatement("RECORDINGS", "SELECT re.id as recordingId, re.gid as trackid, re.length as duration, re.name as trackname, re.comment, re.video  FROM recording re  WHERE re.id BETWEEN ? AND ?");
    }

    @Override
    public void destroy() throws SQLException {
        super.destroy();
        System.out.println(this.getName() + ":Isrcs Queries " + Utils.formatClock(this.isrcClock));
        System.out.println(this.getName() + ":Track Queries " + Utils.formatClock(this.trackClock));
        System.out.println(this.getName() + ":Artists Queries " + Utils.formatClock(this.artistClock));
        System.out.println(this.getName() + ":Track Artists Queries " + Utils.formatClock(this.trackArtistClock));
        System.out.println(this.getName() + ":Releases Queries " + Utils.formatClock(this.releaseClock));
        System.out.println(this.getName() + ":Recording Queries " + Utils.formatClock(this.recordingClock));
        System.out.println(this.getName() + ":Build Index " + Utils.formatClock(this.buildClock));
        System.out.println(this.getName() + ":Build Store " + Utils.formatClock(this.storeClock));
    }

    private Map<Integer, List<Tag>> loadTags(int min, int max) throws SQLException, IOException {
        PreparedStatement st = this.getPreparedStatement("TAGS");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        Map<Integer, List<Tag>> tags = TagHelper.completeTagsFromDbResults(rs, INDEX_NAME);
        rs.close();
        return tags;
    }

    private Map<Integer, List<String>> loadISRCs(int min, int max) throws SQLException, IOException {
        this.isrcClock.resume();
        HashMap<Integer, List<String>> isrcWrapper = new HashMap<Integer, List<String>>();
        PreparedStatement st = this.getPreparedStatement("ISRCS");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            List<String> list;
            int recordingId = rs.getInt("recordingId");
            if (!isrcWrapper.containsKey(recordingId)) {
                list = new LinkedList();
                isrcWrapper.put(recordingId, list);
            } else {
                list = (List)isrcWrapper.get(recordingId);
            }
            String isrc = new String(rs.getString("isrc"));
            list.add(isrc);
        }
        rs.close();
        this.isrcClock.suspend();
        return isrcWrapper;
    }

    private Map<Integer, ArtistCreditWrapper> loadArtists(int min, int max) throws SQLException, IOException {
        this.artistClock.resume();
        PreparedStatement st = this.getPreparedStatement("ARTISTCREDITS");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        Map<Integer, ArtistCreditWrapper> artistCredits = ArtistCreditHelper.completeArtistCreditFromDbResults(rs, "recordingId", "artist_Credit", "artistId", "artistName", "artistSortName", "comment", "joinphrase", "artistCreditName");
        rs.close();
        this.artistClock.suspend();
        return artistCredits;
    }

    private Map<Integer, ArtistCreditWrapper> updateArtistCreditWithAliases(Map<Integer, ArtistCreditWrapper> artistCredits, int min, int max) throws SQLException, IOException {
        PreparedStatement st = this.getPreparedStatement("ARTISTCREDITALIASES");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        return ArtistCreditHelper.updateArtistCreditWithAliases(artistCredits, "recordingId", rs);
    }

    private Map<Integer, ArtistCreditWrapper> updateTrackArtistCreditWithAliases(Map<Integer, ArtistCreditWrapper> artistCredits, int min, int max) throws SQLException, IOException {
        PreparedStatement st = this.getPreparedStatement("TRACKARTISTCREDITALIASES");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        return ArtistCreditHelper.updateArtistCreditWithAliases(artistCredits, "recordingId", rs);
    }

    private Map<Integer, ArtistCreditWrapper> loadTrackArtists(int min, int max) throws SQLException, IOException {
        this.trackArtistClock.resume();
        PreparedStatement st = this.getPreparedStatement("TRACKARTISTCREDITS");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        Map<Integer, ArtistCreditWrapper> artistCredits = ArtistCreditHelper.completeArtistCreditFromDbResults(rs, "id", "artist_Credit", "artistId", "artistName", "artistSortName", "comment", "joinphrase", "artistCreditName");
        rs.close();
        this.trackArtistClock.suspend();
        return artistCredits;
    }

    private Map<Integer, ArtistCreditWrapper> loadReleaseArtists(Map<Integer, Release> releases, int min, int max) throws SQLException, IOException {
        PreparedStatement stmt = this.createReleaseArtistCreditsStatement(releases.size());
        int count = 1;
        for (Integer key : releases.keySet()) {
            stmt.setInt(count, key);
            ++count;
        }
        ResultSet rs = stmt.executeQuery();
        Map<Integer, ArtistCreditWrapper> releaseArtistCredits = ArtistCreditHelper.completeArtistCreditFromDbResults(rs, "releaseKey", "artist_Credit", "artistId", "artistName", "artistSortName", "comment", "joinphrase", "artistCreditName");
        rs.close();
        return releaseArtistCredits;
    }

    private Map<Integer, List<TrackWrapper>> loadTracks(int min, int max) throws SQLException, IOException {
        this.trackClock.resume();
        HashMap<Integer, List<TrackWrapper>> tracks = new HashMap<Integer, List<TrackWrapper>>();
        PreparedStatement st = this.getPreparedStatement("TRACKS");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            List<TrackWrapper> list;
            int recordingId = rs.getInt(INDEX_NAME);
            if (!tracks.containsKey(recordingId)) {
                list = new LinkedList();
                tracks.put(recordingId, list);
            } else {
                list = (List)tracks.get(recordingId);
            }
            TrackWrapper tw = new TrackWrapper();
            tw.setTrackId(rs.getInt("id"));
            tw.setTrackGuid(rs.getString("gid"));
            tw.setReleaseId(rs.getInt("release_id"));
            tw.setTrackCount(rs.getInt("track_count"));
            tw.setTrackPosition(rs.getInt("track_position"));
            tw.setTrackName(rs.getString("track_name"));
            tw.setMediumPosition(rs.getInt("medium_position"));
            tw.setMediumFormat(rs.getString("format"));
            tw.setDuration(rs.getInt("duration"));
            tw.setTrackNumber(rs.getString("track_number"));
            list.add(tw);
        }
        rs.close();
        this.trackClock.suspend();
        return tracks;
    }

    private PreparedStatement createReleaseStatement(int noOfElements) throws SQLException {
        StringBuilder inClause = new StringBuilder();
        boolean firstValue = true;
        for (int i = 0; i < noOfElements; ++i) {
            if (firstValue) {
                firstValue = false;
            } else {
                inClause.append(',');
            }
            inClause.append('?');
        }
        PreparedStatement stmt = this.dbConnection.prepareStatement(this.releases + "(" + inClause.toString() + ')');
        return stmt;
    }

    private PreparedStatement createReleaseEventStatement(int noOfElements) throws SQLException {
        StringBuilder inClause = new StringBuilder();
        boolean firstValue = true;
        for (int i = 0; i < noOfElements; ++i) {
            if (firstValue) {
                firstValue = false;
            } else {
                inClause.append(',');
            }
            inClause.append('?');
        }
        PreparedStatement stmt = this.dbConnection.prepareStatement(this.releaseEvents + "(" + inClause.toString() + ')');
        return stmt;
    }

    private PreparedStatement createReleaseSecondaryTypesStatement(int noOfElements) throws SQLException {
        StringBuilder inClause = new StringBuilder();
        boolean firstValue = true;
        for (int i = 0; i < noOfElements; ++i) {
            if (firstValue) {
                firstValue = false;
            } else {
                inClause.append(',');
            }
            inClause.append('?');
        }
        PreparedStatement stmt = this.dbConnection.prepareStatement(this.releaseSecondaryTypes + "(" + inClause.toString() + ')');
        return stmt;
    }

    private PreparedStatement createReleaseArtistCreditsStatement(int noOfElements) throws SQLException {
        StringBuilder inClause = new StringBuilder();
        boolean firstValue = true;
        for (int i = 0; i < noOfElements; ++i) {
            if (firstValue) {
                firstValue = false;
            } else {
                inClause.append(',');
            }
            inClause.append('?');
        }
        PreparedStatement stmt = this.dbConnection.prepareStatement(this.releaseArtistCredits + "(" + inClause.toString() + ')');
        return stmt;
    }

    private Map<Integer, Release> loadReleases(Map<Integer, List<TrackWrapper>> tracks) throws SQLException, IOException {
        Release release;
        HashMap<Integer, Release> releases = new HashMap<Integer, Release>();
        ObjectFactory of = new ObjectFactory();
        try {
            this.releaseClock.resume();
        }
        catch (IllegalStateException e) {
            System.out.println("Warning: IllegalStateException during StopWatch.resume");
        }
        HashSet<Integer> releaseKeys = new HashSet<Integer>();
        for (List<TrackWrapper> recording : tracks.values()) {
            for (TrackWrapper track : recording) {
                releaseKeys.add(track.getReleaseId());
            }
        }
        if (releaseKeys.isEmpty()) {
            return releases;
        }
        PreparedStatement stmt = this.createReleaseStatement(releaseKeys.size());
        int count = 1;
        for (Integer key : releaseKeys) {
            stmt.setInt(count, key);
            ++count;
        }
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            int releaseKey = rs.getInt("releaseKey");
            if (!releases.containsKey(releaseKey)) {
                release = of.createRelease();
                releases.put(releaseKey, release);
            } else {
                release = (Release)releases.get(releaseKey);
            }
            MediumList ml = of.createMediumList();
            ReleaseGroup rg = of.createReleaseGroup();
            release.setId(rs.getString("releaseId"));
            release.setTitle(rs.getString("releasename"));
            PrimaryType pt = new PrimaryType();
            pt.setContent(rs.getString("type"));
            rg.setPrimaryType(pt);
            rg.setId(rs.getString("rg_gid"));
            release.setReleaseGroup(rg);
            Status status = new Status();
            status.setContent(rs.getString("status"));
            release.setStatus(status);
            ml.setTrackCount(BigInteger.valueOf(rs.getInt("tracks")));
            release.setReleaseGroup(rg);
            release.setMediumList(ml);
            if (rs.getInt("artist_credit") != 1) continue;
            ArtistCredit ac = this.createVariousArtistsCredit();
            release.setArtistCredit(ac);
        }
        rs.close();
        stmt = this.createReleaseEventStatement(releaseKeys.size());
        count = 1;
        for (Integer key : releaseKeys) {
            stmt.setInt(count, key);
            ++count;
        }
        rs = stmt.executeQuery();
        while (rs.next()) {
            String name;
            int releaseKey = rs.getInt("release");
            release = (Release)releases.get(releaseKey);
            if (release == null) continue;
            if (release.getReleaseEventList() == null) {
                release.setReleaseEventList(of.createReleaseEventList());
            }
            ReleaseEvent re = of.createReleaseEvent();
            re.setDate(Strings.emptyToNull(Utils.formatDate(rs.getInt("date_year"), rs.getInt("date_month"), rs.getInt("date_day"))));
            String iso_code = rs.getString("country");
            String gid = rs.getString("gid");
            String sort_name = name = rs.getString("name");
            if (iso_code != null) {
                Iso31661CodeList isoList = of.createIso31661CodeList();
                isoList.getIso31661Code().add(iso_code);
                DefAreaElementInner area = of.createDefAreaElementInner();
                area.setIso31661CodeList(isoList);
                re.setArea(area);
                area.setId(gid);
                area.setName(name);
                area.setSortName(sort_name);
            }
            release.getReleaseEventList().getReleaseEvent().add(re);
        }
        stmt = this.createReleaseSecondaryTypesStatement(releaseKeys.size());
        count = 1;
        for (Integer key : releaseKeys) {
            stmt.setInt(count, key);
            ++count;
        }
        rs = stmt.executeQuery();
        while (rs.next()) {
            int releaseKey = rs.getInt("releaseKey");
            release = (Release)releases.get(releaseKey);
            ReleaseGroup rg = release.getReleaseGroup();
            if (rg.getSecondaryTypeList() == null) {
                rg.setSecondaryTypeList(of.createSecondaryTypeList());
            }
            SecondaryType st = new SecondaryType();
            st.setContent(rs.getString("type"));
            rg.getSecondaryTypeList().getSecondaryType().add(st);
        }
        try {
            this.releaseClock.suspend();
        }
        catch (IllegalStateException e) {
            System.out.println("Warning: IllegalStateException during StopWatch.resume");
        }
        return releases;
    }

    @Override
    public void indexData(IndexWriter indexWriter, int min, int max) throws SQLException, IOException {
        Map<Integer, List<Tag>> tags = this.loadTags(min, max);
        Map<Integer, List<String>> isrcs = this.loadISRCs(min, max);
        Map<Integer, ArtistCreditWrapper> artistCredits = this.updateArtistCreditWithAliases(this.loadArtists(min, max), min, max);
        Map<Integer, ArtistCreditWrapper> trackArtistCredits = this.updateTrackArtistCreditWithAliases(this.loadTrackArtists(min, max), min, max);
        Map<Integer, List<TrackWrapper>> tracks = this.loadTracks(min, max);
        Map<Integer, Release> releases = this.loadReleases(tracks);
        Map<Integer, ArtistCreditWrapper> releaseArtists = this.loadReleaseArtists(releases, min, max);
        PreparedStatement st = this.getPreparedStatement("RECORDINGS");
        st.setInt(1, min);
        st.setInt(2, max);
        this.recordingClock.resume();
        ResultSet rs = st.executeQuery();
        this.recordingClock.suspend();
        while (rs.next()) {
            indexWriter.addDocument(this.documentFromResultSet(rs, tags, isrcs, artistCredits, trackArtistCredits, tracks, releases, releaseArtists));
        }
        rs.close();
    }

    public Document documentFromResultSet(ResultSet rs, Map<Integer, List<Tag>> tags, Map<Integer, List<String>> isrcs, Map<Integer, ArtistCreditWrapper> artistCredits, Map<Integer, ArtistCreditWrapper> trackArtistCredits, Map<Integer, List<TrackWrapper>> tracks, Map<Integer, Release> releases, Map<Integer, ArtistCreditWrapper> releaseArtists) throws SQLException {
        boolean video;
        this.buildClock.resume();
        HashSet<Integer> durations = new HashSet<Integer>();
        HashSet<Integer> qdurs = new HashSet<Integer>();
        HashSet<String> trackNames = new HashSet<String>();
        int id = rs.getInt("recordingId");
        MbDocument doc = new MbDocument();
        ObjectFactory of = new ObjectFactory();
        Recording recording = of.createRecording();
        doc.addField((IndexField)RecordingIndexField.ID, id);
        String guid = rs.getString("trackid");
        doc.addField((IndexField)RecordingIndexField.RECORDING_ID, guid);
        recording.setId(guid);
        String recordingName = rs.getString("trackname");
        doc.addField((IndexField)RecordingIndexField.RECORDING_ACCENT, recordingName);
        recording.setTitle(recordingName);
        trackNames.add(recordingName.toLowerCase(Locale.UK));
        int recordingDuration = rs.getInt("duration");
        if (recordingDuration > 0) {
            durations.add(recordingDuration);
            recording.setLength(BigInteger.valueOf(recordingDuration));
        }
        String comment = rs.getString("comment");
        doc.addFieldOrNoValue(RecordingIndexField.COMMENT, comment);
        if (!Strings.isNullOrEmpty(comment)) {
            recording.setDisambiguation(comment);
        }
        if (video = rs.getBoolean("video")) {
            doc.addField((IndexField)RecordingIndexField.VIDEO, Boolean.toString(video));
            recording.setVideo("true");
        }
        if (isrcs.containsKey(id)) {
            IsrcList isrcList = of.createIsrcList();
            for (String nextIsrc : isrcs.get(id)) {
                doc.addField((IndexField)RecordingIndexField.ISRC, nextIsrc);
                Isrc isrc = of.createIsrc();
                isrc.setId(nextIsrc);
                isrcList.getIsrc().add(isrc);
            }
            recording.setIsrcList(isrcList);
        } else {
            doc.addFieldOrNoValue(RecordingIndexField.ISRC, null);
        }
        ArtistCreditWrapper ac = artistCredits.get(id);
        if (ac != null) {
            ArtistCreditHelper.buildIndexFieldsOnlyFromArtistCredit(doc, ac.getArtistCredit(), RecordingIndexField.ARTIST, RecordingIndexField.ARTIST_NAMECREDIT, RecordingIndexField.ARTIST_ID, RecordingIndexField.ARTIST_NAME);
            recording.setArtistCredit(ac.getArtistCredit());
        } else {
            System.out.println("\nNo artist credit found for recording:" + rs.getString("trackid"));
        }
        if (tracks.containsKey(id)) {
            ReleaseList releaseList = of.createReleaseList();
            recording.setReleaseList(releaseList);
            for (TrackWrapper trackWrapper : tracks.get(id)) {
                Release origRelease = releases.get(trackWrapper.getReleaseId());
                if (origRelease == null) continue;
                ArtistCreditWrapper taw = trackArtistCredits.get(trackWrapper.getTrackId());
                Release release = of.createRelease();
                release.setId(origRelease.getId());
                release.setTitle(origRelease.getTitle());
                MediumList ml = of.createMediumList();
                release.setReleaseGroup(origRelease.getReleaseGroup());
                release.setStatus(origRelease.getStatus());
                if (origRelease.getArtistCredit() != null) {
                    release.setArtistCredit(origRelease.getArtistCredit());
                } else {
                    ArtistCreditWrapper racWrapper = releaseArtists.get(trackWrapper.getReleaseId());
                    if (racWrapper != null) {
                        if (taw != null) {
                            if (taw.getArtistCreditId() != racWrapper.getArtistCreditId()) {
                                release.setArtistCredit(racWrapper.getArtistCredit());
                            }
                        } else if (ac != null && ac.getArtistCreditId() != racWrapper.getArtistCreditId()) {
                            release.setArtistCredit(racWrapper.getArtistCredit());
                        }
                    }
                }
                ml.setTrackCount(origRelease.getMediumList().getTrackCount());
                release.setMediumList(ml);
                release.setReleaseEventList(origRelease.getReleaseEventList());
                releaseList.getRelease().add(release);
                ReleaseGroup rg = release.getReleaseGroup();
                String trackGuid = trackWrapper.getTrackGuid();
                doc.addNonEmptyField(RecordingIndexField.TRACK_ID, trackGuid);
                String primaryType = "";
                if (rg.getPrimaryType() != null) {
                    primaryType = rg.getPrimaryType().getContent();
                }
                doc.addFieldOrUnknown(RecordingIndexField.RELEASEGROUP_ID, rg.getId());
                doc.addFieldOrUnknown(RecordingIndexField.RELEASE_PRIMARY_TYPE, primaryType);
                if (rg.getSecondaryTypeList() != null && rg.getSecondaryTypeList().getSecondaryType() != null) {
                    ArrayList<String> secondaryTypeStringList = new ArrayList<String>();
                    for (SecondaryType secondaryType : rg.getSecondaryTypeList().getSecondaryType()) {
                        String st = "";
                        if (secondaryType != null) {
                            st = secondaryType.getContent();
                        }
                        doc.addField((IndexField)RecordingIndexField.RELEASE_SECONDARY_TYPE, st);
                        secondaryTypeStringList.add(st);
                    }
                    String type = ReleaseGroupHelper.calculateOldTypeFromPrimaryType(primaryType, secondaryTypeStringList);
                    doc.addFieldOrNoValue(RecordingIndexField.RELEASE_TYPE, type);
                    rg.setType(type);
                } else {
                    String pt = "";
                    if (release.getReleaseGroup().getPrimaryType() != null) {
                        pt = release.getReleaseGroup().getPrimaryType().getContent();
                    }
                    doc.addFieldOrNoValue(RecordingIndexField.RELEASE_TYPE, pt);
                    rg.setType(pt);
                }
                doc.addNumericField((IndexField)RecordingIndexField.NUM_TRACKS, trackWrapper.getTrackCount());
                doc.addNumericField((IndexField)RecordingIndexField.TRACKNUM, trackWrapper.getTrackPosition());
                doc.addFieldOrNoValue(RecordingIndexField.NUMBER, trackWrapper.getTrackNumber());
                DefTrackData track = of.createDefTrackData();
                track.setId(trackGuid);
                track.setTitle(trackWrapper.getTrackName());
                track.setLength(BigInteger.valueOf(trackWrapper.getDuration()));
                track.setNumber(trackWrapper.getTrackNumber());
                Medium medium = of.createMedium();
                medium.setPosition(BigInteger.valueOf(trackWrapper.getMediumPosition()));
                Format format = new Format();
                format.setContent(trackWrapper.getMediumFormat());
                medium.setFormat(format);
                Medium.TrackList tl = of.createMediumTrackList();
                tl.setCount(BigInteger.valueOf(trackWrapper.getTrackCount()));
                tl.setOffset(BigInteger.valueOf(trackWrapper.getTrackPosition() - 1));
                release.getMediumList().getMedium().add(medium);
                medium.setTrackList(tl);
                tl.getDefTrack().add(track);
                String st = "";
                if (release.getStatus() != null) {
                    st = release.getStatus().getContent();
                }
                doc.addFieldOrNoValue(RecordingIndexField.RELEASE_STATUS, st);
                if (release.getReleaseEventList() != null && release.getReleaseEventList().getReleaseEvent().size() > 0) {
                    for (ReleaseEvent re : release.getReleaseEventList().getReleaseEvent()) {
                        doc.addNonEmptyField(RecordingIndexField.RELEASE_DATE, re.getDate());
                        if (re.getArea() == null || re.getArea().getIso31661CodeList() == null) continue;
                        doc.addNonEmptyField(RecordingIndexField.COUNTRY, re.getArea().getIso31661CodeList().getIso31661Code().get(0));
                    }
                    Collections.sort(release.getReleaseEventList().getReleaseEvent(), new ReleaseEventComparator());
                    ReleaseEvent firstReleaseEvent = release.getReleaseEventList().getReleaseEvent().get(0);
                    if (!Strings.isNullOrEmpty(firstReleaseEvent.getDate())) {
                        release.setDate(firstReleaseEvent.getDate());
                    }
                    if (firstReleaseEvent.getArea() != null && firstReleaseEvent.getArea().getIso31661CodeList() != null) {
                        release.setCountry(firstReleaseEvent.getArea().getIso31661CodeList().getIso31661Code().get(0));
                    }
                } else {
                    doc.addFieldOrNoValue(RecordingIndexField.RELEASE_DATE, null);
                    doc.addFieldOrNoValue(RecordingIndexField.COUNTRY, null);
                }
                doc.addField((IndexField)RecordingIndexField.RELEASE_ID, release.getId());
                doc.addField((IndexField)RecordingIndexField.RELEASE, release.getTitle());
                doc.addNumericField((IndexField)RecordingIndexField.NUM_TRACKS_RELEASE, release.getMediumList().getTrackCount().intValue());
                trackNames.add(trackWrapper.getTrackName().toLowerCase(Locale.UK));
                doc.addField((IndexField)RecordingIndexField.POSITION, String.valueOf(trackWrapper.getMediumPosition()));
                doc.addFieldOrNoValue(RecordingIndexField.FORMAT, trackWrapper.getMediumFormat());
                if (taw == null || ac != null && taw.getArtistCreditId() == ac.getArtistCreditId()) continue;
                ArtistCreditHelper.buildIndexFieldsOnlyFromArtistCredit(doc, taw.getArtistCredit(), RecordingIndexField.ARTIST, RecordingIndexField.ARTIST_NAMECREDIT, RecordingIndexField.ARTIST_ID, RecordingIndexField.ARTIST_NAME);
                track.setArtistCredit(taw.getArtistCredit());
            }
        } else {
            doc.addFieldOrNoValue(RecordingIndexField.RELEASE_TYPE, "standalone");
        }
        if (tags.containsKey(id)) {
            recording.setTagList(TagHelper.addTagsToDocAndConstructTagList(of, doc, tags, id, RecordingIndexField.TAG));
        }
        if (durations.size() == 0) {
            doc.addField((IndexField)RecordingIndexField.DURATION, "-");
            doc.addField((IndexField)RecordingIndexField.QUANTIZED_DURATION, "-");
        } else {
            for (Integer dur : durations) {
                doc.addNumericField((IndexField)RecordingIndexField.DURATION, dur);
                qdurs.add(dur / 2000);
            }
            for (Integer qdur : qdurs) {
                doc.addNumericField((IndexField)RecordingIndexField.QUANTIZED_DURATION, qdur);
            }
        }
        for (String next : trackNames) {
            doc.addNonEmptyField(RecordingIndexField.RECORDING, next);
        }
        this.buildClock.suspend();
        this.storeClock.resume();
        doc.addField((IndexField)RecordingIndexField.RECORDING_STORE, MMDSerializer.serialize(recording));
        this.storeClock.suspend();
        return doc.getLuceneDocument();
    }

    private ArtistCredit createVariousArtistsCredit() {
        ObjectFactory of = new ObjectFactory();
        Artist artist = of.createArtist();
        artist.setId(VARIOUS_ARTISTS_GUID);
        artist.setName(VARIOUS_ARTISTS_NAME);
        artist.setSortName(VARIOUS_ARTISTS_NAME);
        NameCredit naCredit = of.createNameCredit();
        naCredit.setArtist(artist);
        ArtistCredit vaCredit = of.createArtistCredit();
        vaCredit.getNameCredit().add(naCredit);
        return vaCredit;
    }
}

