/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.analysis;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.charfilter.NormalizeCharMap;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.musicbrainz.search.analysis.AmpersandToAndMappingHelper;
import org.musicbrainz.search.analysis.CharEquivToCharHelper;
import org.musicbrainz.search.analysis.HebrewCharMappingHelper;
import org.musicbrainz.search.analysis.LowercaseFilter;

public class NewMusicbrainzAnalyzer
extends Analyzer {
    protected NormalizeCharMap charConvertMap;

    protected void setCharConvertMap() {
        NormalizeCharMap.Builder builder = new NormalizeCharMap.Builder();
        AmpersandToAndMappingHelper.addToMap(builder);
        CharEquivToCharHelper.addToMap(builder);
        HebrewCharMappingHelper.addToMap(builder);
        this.charConvertMap = builder.build();
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter filter = new StandardFilter(source);
        filter = new LowercaseFilter(filter);
        return new Analyzer.TokenStreamComponents(source, filter);
    }
}

