/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.index;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.musicbrainz.mmd2.Artist;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.mmd2.Relation;
import org.musicbrainz.mmd2.RelationList;
import org.musicbrainz.mmd2.Target;
import org.musicbrainz.mmd2.Url;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.index.DatabaseIndex;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.MMDSerializer;
import org.musicbrainz.search.index.TagIndexField;
import org.musicbrainz.search.index.UrlIndexField;

public class UrlIndex
extends DatabaseIndex {
    private static final String ARTIST_RELATION_TYPE = "artist";
    public static final String INDEX_NAME = "url";

    public UrlIndex(Connection dbConnection) {
        super(dbConnection);
    }

    public UrlIndex() {
    }

    @Override
    public String getName() {
        return INDEX_NAME;
    }

    @Override
    public IndexField getIdentifierField() {
        return TagIndexField.ID;
    }

    @Override
    public Analyzer getAnalyzer() {
        return DatabaseIndex.getAnalyzer(TagIndexField.class);
    }

    @Override
    public int getMaxId() throws SQLException {
        Statement st = this.dbConnection.createStatement();
        ResultSet rs = st.executeQuery("SELECT MAX(id) FROM url");
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public int getNoOfRows(int maxId) throws SQLException {
        Statement st = this.dbConnection.createStatement();
        ResultSet rs = st.executeQuery("SELECT count(*) FROM url WHERE id<=" + maxId);
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public void init(IndexWriter indexWriter, boolean isUpdater) throws SQLException {
        this.addPreparedStatement("ARTIST_URL", "SELECT u.id,  u.gid, u.url, a.gid as aid, a.name as artist_name, a.sort_name as artist_sortname, lt.name as link FROM l_artist_url lau INNER JOIN url u        ON u.id       = lau.entity1 INNER JOIN artist a     ON a.id       = lau.entity0 INNER JOIN link l       ON lau.link   = l.id  INNER JOIN link_type lt ON l.link_type=lt.id WHERE u.id BETWEEN ? AND ?  ORDER BY u.id");
    }

    @Override
    public void indexData(IndexWriter indexWriter, int min, int max) throws SQLException, IOException {
        PreparedStatement st = this.getPreparedStatement("ARTIST_URL");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            indexWriter.addDocument(this.documentFromResultSet(rs));
        }
        rs.close();
    }

    public Document documentFromResultSet(ResultSet rs) throws SQLException {
        MbDocument doc = new MbDocument();
        ObjectFactory of = new ObjectFactory();
        Url url = of.createUrl();
        doc.addField((IndexField)UrlIndexField.ID, rs.getString("id"));
        String guid = rs.getString("gid");
        doc.addField((IndexField)UrlIndexField.URL_ID, guid);
        url.setId(guid);
        String title = rs.getString(INDEX_NAME);
        doc.addField((IndexField)UrlIndexField.URL, title);
        url.setResource(title);
        String artistId = rs.getString("aid");
        Artist artist = new ObjectFactory().createArtist();
        artist.setId(artistId);
        artist.setName(rs.getString("artist_name"));
        artist.setSortName(rs.getString("artist_sortname"));
        Relation relation = of.createRelation();
        relation.setArtist(artist);
        String relationType = rs.getString("link");
        relation.setType(relationType);
        doc.addField((IndexField)UrlIndexField.RELATION_TYPE, relationType);
        Target target = of.createTarget();
        target.setValue(artistId);
        doc.addField((IndexField)UrlIndexField.TARGET_ID, artistId);
        relation.setTarget(target);
        RelationList relationList = of.createRelationList();
        relationList.setTargetType(ARTIST_RELATION_TYPE);
        doc.addField((IndexField)UrlIndexField.TARGET_TYPE, ARTIST_RELATION_TYPE);
        relationList.getRelation().add(relation);
        url.getRelationList().add(relationList);
        String store = MMDSerializer.serialize(url);
        doc.addField((IndexField)UrlIndexField.URL_STORE, store);
        return doc.getLuceneDocument();
    }
}

