/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.index;

import com.google.common.base.Strings;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.similarities.Similarity;
import org.musicbrainz.mmd2.Alias;
import org.musicbrainz.mmd2.AliasList;
import org.musicbrainz.mmd2.DefAreaElementInner;
import org.musicbrainz.mmd2.IpiList;
import org.musicbrainz.mmd2.Label;
import org.musicbrainz.mmd2.LifeSpan;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.mmd2.Tag;
import org.musicbrainz.mmd2.TagList;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.analysis.MusicbrainzSimilarity;
import org.musicbrainz.search.index.ArtistIndexField;
import org.musicbrainz.search.index.DatabaseIndex;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.LabelBoostDoc;
import org.musicbrainz.search.index.LabelIndexField;
import org.musicbrainz.search.index.MMDSerializer;
import org.musicbrainz.search.index.TagHelper;
import org.musicbrainz.search.index.Utils;

public class LabelIndex
extends DatabaseIndex {
    public static final String INDEX_NAME = "label";
    private static final String DELETED_LABEL_MBID = "f43e252d-9ebf-4e8e-bba8-36d080756cc1";

    public LabelIndex(Connection dbConnection) {
        super(dbConnection);
    }

    public LabelIndex() {
    }

    @Override
    public String getName() {
        return INDEX_NAME;
    }

    @Override
    public Analyzer getAnalyzer() {
        return DatabaseIndex.getAnalyzer(LabelIndexField.class);
    }

    @Override
    public IndexField getIdentifierField() {
        return LabelIndexField.ID;
    }

    @Override
    public int getMaxId() throws SQLException {
        Statement st = this.dbConnection.createStatement();
        ResultSet rs = st.executeQuery("SELECT MAX(id) FROM label");
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public int getNoOfRows(int maxId) throws SQLException {
        PreparedStatement st = this.dbConnection.prepareStatement("SELECT count(*) FROM label WHERE id <= ? AND gid <> ?::uuid");
        st.setInt(1, maxId);
        st.setString(2, DELETED_LABEL_MBID);
        ResultSet rs = st.executeQuery();
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public Similarity getSimilarity() {
        return new MusicbrainzSimilarity();
    }

    @Override
    public void init(IndexWriter indexWriter, boolean isUpdater) throws SQLException {
        this.addPreparedStatement("TAGS", "SELECT label_tag.label, tag.name as tag, label_tag.count as count  FROM label_tag   INNER JOIN tag ON tag=id  WHERE label between ? AND ?");
        this.addPreparedStatement("ALIASES", "SELECT a.label as label, a.name as alias, a.sort_name as alias_sortname, a.primary_for_locale, a.locale, att.name as type,a.begin_date_year, a.begin_date_month, a.begin_date_day, a.end_date_year, a.end_date_month, a.end_date_day FROM label_alias a  LEFT JOIN label_alias_type att on (a.type=att.id) WHERE label BETWEEN ? AND ? ORDER BY label, alias, alias_sortname");
        this.addPreparedStatement("LABELS", "SELECT label.id, label.gid, label.name as name,  label_type.name as type, label.begin_date_year, label.begin_date_month, label.begin_date_day,   label.end_date_year, label.end_date_month, label.end_date_day, label.ended,  label.comment, label_code, lower(i.code) as country,   a1.gid as area_gid, a1.name as area_name  FROM label   LEFT JOIN label_type ON label.type = label_type.id   LEFT JOIN iso_3166_1 i on label.area=i.area  LEFT JOIN area a1 on label.area = a1.id WHERE label.id BETWEEN ? AND ?");
        this.addPreparedStatement("IPICODES", "SELECT ipi, label  FROM label_ipi   WHERE label between ? AND ?");
    }

    private Map<Integer, List<String>> loadIpiCodes(int min, int max) throws SQLException, IOException {
        HashMap<Integer, List<String>> ipiCodes = new HashMap<Integer, List<String>>();
        PreparedStatement st = this.getPreparedStatement("IPICODES");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            List<String> list;
            int artistId = rs.getInt(INDEX_NAME);
            if (!ipiCodes.containsKey(artistId)) {
                list = new LinkedList();
                ipiCodes.put(artistId, list);
            } else {
                list = (List)ipiCodes.get(artistId);
            }
            list.add(rs.getString("ipi"));
        }
        rs.close();
        return ipiCodes;
    }

    @Override
    public void indexData(IndexWriter indexWriter, int min, int max) throws SQLException, IOException {
        ObjectFactory of = new ObjectFactory();
        PreparedStatement st = this.getPreparedStatement("TAGS");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        Map<Integer, List<Tag>> tags = TagHelper.completeTagsFromDbResults(rs, INDEX_NAME);
        rs.close();
        Map<Integer, List<String>> ipiCodes = this.loadIpiCodes(min, max);
        HashMap<Integer, Set<Alias>> aliases = new HashMap<Integer, Set<Alias>>();
        st = this.getPreparedStatement("ALIASES");
        st.setInt(1, min);
        st.setInt(2, max);
        rs = st.executeQuery();
        while (rs.next()) {
            String end;
            String begin;
            String type;
            String locale;
            Set<Alias> list;
            int artistId = rs.getInt(INDEX_NAME);
            if (!aliases.containsKey(artistId)) {
                list = new LinkedHashSet();
                aliases.put(artistId, list);
            } else {
                list = (Set)aliases.get(artistId);
            }
            Alias alias = of.createAlias();
            alias.setContent(rs.getString("alias"));
            alias.setSortName(rs.getString("alias_sortname"));
            boolean isPrimary = rs.getBoolean("primary_for_locale");
            if (isPrimary) {
                alias.setPrimary("primary");
            }
            if ((locale = rs.getString("locale")) != null) {
                alias.setLocale(locale);
            }
            if ((type = rs.getString("type")) != null) {
                alias.setType(type);
            }
            if (!Strings.isNullOrEmpty(begin = Utils.formatDate(rs.getInt("begin_date_year"), rs.getInt("begin_date_month"), rs.getInt("begin_date_day")))) {
                alias.setBeginDate(begin);
            }
            if (!Strings.isNullOrEmpty(end = Utils.formatDate(rs.getInt("end_date_year"), rs.getInt("end_date_month"), rs.getInt("end_date_day")))) {
                alias.setEndDate(end);
            }
            list.add(alias);
        }
        rs.close();
        st = this.getPreparedStatement("LABELS");
        st.setInt(1, min);
        st.setInt(2, max);
        rs = st.executeQuery();
        while (rs.next()) {
            if (rs.getString("gid").equals(DELETED_LABEL_MBID)) continue;
            indexWriter.addDocument(this.documentFromResultSet(rs, tags, ipiCodes, aliases));
        }
        rs.close();
    }

    public Document documentFromResultSet(ResultSet rs, Map<Integer, List<Tag>> tags, Map<Integer, List<String>> ipiCodes, Map<Integer, Set<Alias>> aliases) throws SQLException {
        String areaId;
        MbDocument doc = new MbDocument();
        ObjectFactory of = new ObjectFactory();
        Label label = of.createLabel();
        int labelId = rs.getInt("id");
        doc.addField((IndexField)LabelIndexField.ID, labelId);
        String labelGuid = rs.getString("gid");
        doc.addField((IndexField)LabelIndexField.LABEL_ID, labelGuid);
        label.setId(labelGuid);
        String name = rs.getString("name");
        doc.addField((IndexField)LabelIndexField.LABEL, name);
        label.setName(name);
        doc.addField((IndexField)LabelIndexField.SORTNAME, name);
        label.setSortName(name);
        doc.addField((IndexField)LabelIndexField.LABEL_ACCENT, name);
        String type = rs.getString("type");
        doc.addFieldOrUnknown(LabelIndexField.TYPE, type);
        if (!Strings.isNullOrEmpty(type)) {
            label.setType(type);
        }
        String comment = rs.getString("comment");
        doc.addFieldOrNoValue(LabelIndexField.COMMENT, comment);
        if (!Strings.isNullOrEmpty(comment)) {
            label.setDisambiguation(comment);
        }
        String country = rs.getString("country");
        doc.addFieldOrUnknown(LabelIndexField.COUNTRY, country);
        if (!Strings.isNullOrEmpty(country)) {
            label.setCountry(country.toUpperCase(Locale.US));
        }
        if ((areaId = rs.getString("area_gid")) != null) {
            DefAreaElementInner area = of.createDefAreaElementInner();
            area.setId(areaId);
            String areaName = rs.getString("area_name");
            area.setName(areaName);
            doc.addFieldOrNoValue(ArtistIndexField.AREA, areaName);
            area.setSortName(areaName);
            label.setArea(area);
        } else {
            doc.addField((IndexField)ArtistIndexField.AREA, "-");
        }
        boolean ended = rs.getBoolean("ended");
        doc.addFieldOrUnknown(LabelIndexField.ENDED, Boolean.toString(ended));
        String begin = Utils.formatDate(rs.getInt("begin_date_year"), rs.getInt("begin_date_month"), rs.getInt("begin_date_day"));
        doc.addNonEmptyField(LabelIndexField.BEGIN, begin);
        String end = Utils.formatDate(rs.getInt("end_date_year"), rs.getInt("end_date_month"), rs.getInt("end_date_day"));
        doc.addNonEmptyField(LabelIndexField.END, end);
        LifeSpan lifespan = of.createLifeSpan();
        label.setLifeSpan(lifespan);
        if (!Strings.isNullOrEmpty(begin)) {
            lifespan.setBegin(begin);
        }
        if (!Strings.isNullOrEmpty(end)) {
            lifespan.setEnd(end);
        }
        lifespan.setEnded(Boolean.toString(ended));
        int labelcode = rs.getInt("label_code");
        if (labelcode > 0) {
            doc.addField((IndexField)LabelIndexField.CODE, labelcode);
            label.setLabelCode(BigInteger.valueOf(labelcode));
        } else {
            doc.addField((IndexField)LabelIndexField.CODE, "-");
        }
        if (aliases.containsKey(labelId)) {
            AliasList aliasList = of.createAliasList();
            for (Alias nextAlias : aliases.get(labelId)) {
                doc.addField((IndexField)LabelIndexField.ALIAS, nextAlias.getContent());
                if (!Strings.isNullOrEmpty(nextAlias.getSortName()) && !nextAlias.getSortName().equals(nextAlias.getContent())) {
                    doc.addField((IndexField)LabelIndexField.ALIAS, nextAlias.getSortName());
                }
                aliasList.getAlias().add(nextAlias);
            }
            label.setAliasList(aliasList);
        }
        if (tags.containsKey(labelId)) {
            TagList tagList = of.createTagList();
            for (Tag nextTag : tags.get(labelId)) {
                Tag tag = of.createTag();
                doc.addField((IndexField)LabelIndexField.TAG, nextTag.getName());
                tag.setName(nextTag.getName());
                tag.setCount(new BigInteger(nextTag.getCount().toString()));
                tagList.getTag().add(tag);
            }
            label.setTagList(tagList);
        }
        if (ipiCodes.containsKey(labelId)) {
            IpiList ipiList = of.createIpiList();
            for (String ipiCode : ipiCodes.get(labelId)) {
                doc.addField((IndexField)LabelIndexField.IPI, ipiCode);
                ipiList.getIpi().add(ipiCode);
            }
            label.setIpiList(ipiList);
        }
        LabelBoostDoc.boost(labelGuid, doc);
        String store = MMDSerializer.serialize(label);
        doc.addField((IndexField)LabelIndexField.LABEL_STORE, store);
        return doc.getLuceneDocument();
    }
}

