/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.index;

import com.google.common.base.Strings;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.similarities.Similarity;
import org.musicbrainz.mmd2.Alias;
import org.musicbrainz.mmd2.AliasList;
import org.musicbrainz.mmd2.Artist;
import org.musicbrainz.mmd2.DefAreaElementInner;
import org.musicbrainz.mmd2.IpiList;
import org.musicbrainz.mmd2.LifeSpan;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.mmd2.Tag;
import org.musicbrainz.mmd2.TagList;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.analysis.MusicbrainzSimilarity;
import org.musicbrainz.search.index.ArtistBoostDoc;
import org.musicbrainz.search.index.ArtistIndexField;
import org.musicbrainz.search.index.ArtistType;
import org.musicbrainz.search.index.DatabaseIndex;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.MMDSerializer;
import org.musicbrainz.search.index.TagHelper;
import org.musicbrainz.search.index.Utils;

public class ArtistIndex
extends DatabaseIndex {
    public static final String INDEX_NAME = "artist";
    public static final String DELETED_ARTIST_MBID = "c06aa285-520e-40c0-b776-83d2c9e8a6d1";
    public static final String VARIOUS_ARTIST_MBID = "89ad4ac3-39f7-470e-963a-56509c546377";
    public static final String UNKNOWN_ARTIST_MBID = "125ec42a-7229-4250-afc5-e057484327fe";
    private static final String PERSON = "Person";
    private CharsetEncoder latinEncoder;

    private void initDecoders() {
        this.latinEncoder = Charset.forName("ISO-8859-1").newEncoder();
        this.latinEncoder.onMalformedInput(CodingErrorAction.REPORT);
        this.latinEncoder.onUnmappableCharacter(CodingErrorAction.REPORT);
    }

    public ArtistIndex(Connection dbConnection) throws SQLException {
        super(dbConnection);
        this.initDecoders();
    }

    public ArtistIndex() {
        this.initDecoders();
    }

    @Override
    public String getName() {
        return INDEX_NAME;
    }

    @Override
    public Analyzer getAnalyzer() {
        return DatabaseIndex.getAnalyzer(ArtistIndexField.class);
    }

    @Override
    public IndexField getIdentifierField() {
        return ArtistIndexField.ID;
    }

    @Override
    public int getMaxId() throws SQLException {
        Statement st = this.dbConnection.createStatement();
        ResultSet rs = st.executeQuery("SELECT MAX(id) FROM artist");
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public int getNoOfRows(int maxId) throws SQLException {
        PreparedStatement st = this.dbConnection.prepareStatement("SELECT count(*) FROM artist WHERE id <= ? AND gid <> ?::uuid");
        st.setInt(1, maxId);
        st.setString(2, DELETED_ARTIST_MBID);
        ResultSet rs = st.executeQuery();
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public Similarity getSimilarity() {
        return new MusicbrainzSimilarity();
    }

    @Override
    public void init(IndexWriter indexWriter, boolean isUpdater) throws SQLException {
        this.addPreparedStatement("TAGS", "SELECT artist_tag.artist, tag.name as tag, artist_tag.count as count  FROM artist_tag   INNER JOIN tag ON tag=id  WHERE artist between ? AND ?");
        this.addPreparedStatement("ALIASES", "SELECT a.artist as artist, a.name as alias, a.sort_name as alias_sortname, a.primary_for_locale, a.locale, att.name as type,a.begin_date_year, a.begin_date_month, a.begin_date_day, a.end_date_year, a.end_date_month, a.end_date_day FROM artist_alias a  LEFT JOIN artist_alias_type att on (a.type=att.id) WHERE artist BETWEEN ? AND ? ORDER BY artist, alias, alias_sortname");
        this.addPreparedStatement("ARTISTCREDITS", "SELECT artist as artist, name as artistcredit  FROM artist_credit_name  WHERE artist BETWEEN ? AND ? ");
        this.addPreparedStatement("ARTISTS", "SELECT a.id, a.gid as gid, a.name, a.sort_name,   artist_type.name as type, a.begin_date_year, a.begin_date_month, a.begin_date_day,   a.end_date_year, a.end_date_month, a.end_date_day,a.ended,   a.comment, lower(i.code) as country, lower(gender.name) as gender,  a1.gid as area_gid, a1.name as area_name,    a2.gid as beginarea_gid, a2.name as beginarea_name,    a3.gid as endarea_gid, a3.name as endarea_name FROM artist a   LEFT JOIN artist_type ON a.type = artist_type.id   LEFT JOIN iso_3166_1 i on a.area=i.area  LEFT JOIN gender ON a.gender=gender.id   LEFT JOIN area a1 on a.area = a1.id  LEFT JOIN area a2 on a.begin_area = a2.id  LEFT JOIN area a3 on a.end_area = a3.id WHERE a.id BETWEEN ? AND ?");
        this.addPreparedStatement("IPICODES", "SELECT ipi, artist  FROM artist_ipi   WHERE artist between ? AND ?");
    }

    private Map<Integer, List<String>> loadIpiCodes(int min, int max) throws SQLException, IOException {
        HashMap<Integer, List<String>> ipiCodes = new HashMap<Integer, List<String>>();
        PreparedStatement st = this.getPreparedStatement("IPICODES");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            List<String> list;
            int artistId = rs.getInt(INDEX_NAME);
            if (!ipiCodes.containsKey(artistId)) {
                list = new LinkedList();
                ipiCodes.put(artistId, list);
            } else {
                list = (List)ipiCodes.get(artistId);
            }
            list.add(rs.getString("ipi"));
        }
        rs.close();
        return ipiCodes;
    }

    @Override
    public void indexData(IndexWriter indexWriter, int min, int max) throws SQLException, IOException {
        ObjectFactory of = new ObjectFactory();
        PreparedStatement st = this.getPreparedStatement("TAGS");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        Map<Integer, List<Tag>> tags = TagHelper.completeTagsFromDbResults(rs, INDEX_NAME);
        rs.close();
        Map<Integer, List<String>> ipiCodes = this.loadIpiCodes(min, max);
        HashMap<Integer, Set<Alias>> aliases = new HashMap<Integer, Set<Alias>>();
        st = this.getPreparedStatement("ALIASES");
        st.setInt(1, min);
        st.setInt(2, max);
        rs = st.executeQuery();
        while (rs.next()) {
            String end;
            String begin;
            String type;
            String locale;
            Set<Alias> list;
            int artistId = rs.getInt(INDEX_NAME);
            if (!aliases.containsKey(artistId)) {
                list = new LinkedHashSet();
                aliases.put(artistId, list);
            } else {
                list = (Set)aliases.get(artistId);
            }
            Alias alias = of.createAlias();
            alias.setContent(rs.getString("alias"));
            alias.setSortName(rs.getString("alias_sortname"));
            boolean isPrimary = rs.getBoolean("primary_for_locale");
            if (isPrimary) {
                alias.setPrimary("primary");
            }
            if ((locale = rs.getString("locale")) != null) {
                alias.setLocale(locale);
            }
            if ((type = rs.getString("type")) != null) {
                alias.setType(type);
            }
            if (!Strings.isNullOrEmpty(begin = Utils.formatDate(rs.getInt("begin_date_year"), rs.getInt("begin_date_month"), rs.getInt("begin_date_day")))) {
                alias.setBeginDate(begin);
            }
            if (!Strings.isNullOrEmpty(end = Utils.formatDate(rs.getInt("end_date_year"), rs.getInt("end_date_month"), rs.getInt("end_date_day")))) {
                alias.setEndDate(end);
            }
            list.add(alias);
        }
        rs.close();
        HashMap<Integer, Set<String>> artistCredits = new HashMap<Integer, Set<String>>();
        st = this.getPreparedStatement("ARTISTCREDITS");
        st.setInt(1, min);
        st.setInt(2, max);
        rs = st.executeQuery();
        while (rs.next()) {
            Set<String> list;
            int artistId = rs.getInt(INDEX_NAME);
            if (!artistCredits.containsKey(artistId)) {
                list = new HashSet();
                artistCredits.put(artistId, list);
            } else {
                list = (Set)artistCredits.get(artistId);
            }
            list.add(rs.getString("artistcredit"));
        }
        rs.close();
        st = this.getPreparedStatement("ARTISTS");
        st.setInt(1, min);
        st.setInt(2, max);
        rs = st.executeQuery();
        while (rs.next()) {
            if (rs.getString("gid").equals(DELETED_ARTIST_MBID)) continue;
            indexWriter.addDocument(this.documentFromResultSet(rs, tags, ipiCodes, aliases, artistCredits));
        }
        rs.close();
    }

    public Document documentFromResultSet(ResultSet rs, Map<Integer, List<Tag>> tags, Map<Integer, List<String>> ipiCodes, Map<Integer, Set<Alias>> aliases, Map<Integer, Set<String>> artistCredits) throws SQLException {
        String areaId;
        MbDocument doc = new MbDocument();
        ObjectFactory of = new ObjectFactory();
        Artist artist = of.createArtist();
        int artistId = rs.getInt("id");
        String artistGuid = rs.getString("gid");
        doc.addField((IndexField)ArtistIndexField.ID, artistId);
        doc.addField((IndexField)ArtistIndexField.ARTIST_ID, artistGuid);
        artist.setId(artistGuid);
        String artistName = rs.getString("name");
        doc.addField((IndexField)ArtistIndexField.ARTIST, artistName);
        artist.setName(artistName);
        doc.addField((IndexField)ArtistIndexField.ARTIST_ACCENT, artistName);
        String sortName = rs.getString("sort_name");
        doc.addField((IndexField)ArtistIndexField.SORTNAME, sortName);
        artist.setSortName(sortName);
        String type = rs.getString("type");
        doc.addFieldOrUnknown(ArtistIndexField.TYPE, type);
        if (!Strings.isNullOrEmpty(type)) {
            artist.setType(type);
        }
        boolean ended = rs.getBoolean("ended");
        doc.addFieldOrUnknown(ArtistIndexField.ENDED, Boolean.toString(ended));
        String begin = Utils.formatDate(rs.getInt("begin_date_year"), rs.getInt("begin_date_month"), rs.getInt("begin_date_day"));
        doc.addNonEmptyField(ArtistIndexField.BEGIN, begin);
        String end = Utils.formatDate(rs.getInt("end_date_year"), rs.getInt("end_date_month"), rs.getInt("end_date_day"));
        doc.addNonEmptyField(ArtistIndexField.END, end);
        LifeSpan lifespan = of.createLifeSpan();
        artist.setLifeSpan(lifespan);
        if (!Strings.isNullOrEmpty(begin)) {
            lifespan.setBegin(begin);
        }
        if (!Strings.isNullOrEmpty(end)) {
            lifespan.setEnd(end);
        }
        lifespan.setEnded(Boolean.toString(ended));
        String comment = rs.getString("comment");
        doc.addFieldOrNoValue(ArtistIndexField.COMMENT, comment);
        if (!Strings.isNullOrEmpty(comment)) {
            artist.setDisambiguation(comment);
        }
        String country = rs.getString("country");
        doc.addFieldOrUnknown(ArtistIndexField.COUNTRY, country);
        if (!Strings.isNullOrEmpty(country)) {
            artist.setCountry(country.toUpperCase(Locale.US));
        }
        if ((areaId = rs.getString("area_gid")) != null) {
            DefAreaElementInner area = of.createDefAreaElementInner();
            area.setId(areaId);
            String areaName = rs.getString("area_name");
            doc.addFieldOrNoValue(ArtistIndexField.AREA, areaName);
            area.setName(areaName);
            area.setSortName(areaName);
            artist.setArea(area);
        } else {
            doc.addField((IndexField)ArtistIndexField.AREA, "-");
        }
        String beginAreaId = rs.getString("beginarea_gid");
        if (beginAreaId != null) {
            DefAreaElementInner area = of.createDefAreaElementInner();
            area.setId(beginAreaId);
            String areaName = rs.getString("beginarea_name");
            doc.addFieldOrNoValue(ArtistIndexField.BEGIN_AREA, areaName);
            area.setName(areaName);
            String areaSortName = rs.getString("beginarea_name");
            area.setSortName(areaSortName);
            artist.setBeginArea(area);
        } else {
            doc.addField((IndexField)ArtistIndexField.BEGIN_AREA, "-");
        }
        String endAreaId = rs.getString("endarea_gid");
        if (endAreaId != null) {
            DefAreaElementInner area = of.createDefAreaElementInner();
            area.setId(endAreaId);
            String areaName = rs.getString("endarea_name");
            doc.addFieldOrNoValue(ArtistIndexField.END_AREA, areaName);
            area.setName(areaName);
            String areaSortName = rs.getString("endarea_name");
            area.setSortName(areaSortName);
            artist.setEndArea(area);
        } else {
            doc.addField((IndexField)ArtistIndexField.END_AREA, "-");
        }
        String gender = rs.getString("gender");
        if (gender != null) {
            doc.addField((IndexField)ArtistIndexField.GENDER, gender);
            artist.setGender(gender);
        } else if (type != null && type.equalsIgnoreCase(ArtistType.PERSON.getName())) {
            doc.addField((IndexField)ArtistIndexField.GENDER, "unknown");
        }
        if (aliases.containsKey(artistId)) {
            AliasList aliasList = of.createAliasList();
            for (Alias nextAlias : aliases.get(artistId)) {
                doc.addField((IndexField)ArtistIndexField.ALIAS, nextAlias.getContent());
                if (!Strings.isNullOrEmpty(nextAlias.getSortName()) && !nextAlias.getSortName().equals(nextAlias.getContent())) {
                    doc.addField((IndexField)ArtistIndexField.ALIAS, nextAlias.getSortName());
                }
                aliasList.getAlias().add(nextAlias);
            }
            artist.setAliasList(aliasList);
        }
        if (artistCredits.containsKey(artistId)) {
            for (String artistCredit : artistCredits.get(artistId)) {
                doc.addField((IndexField)ArtistIndexField.ALIAS, artistCredit);
            }
        }
        this.addArtistInitialized(type, artistName, sortName, doc);
        if (tags.containsKey(artistId)) {
            TagList tagList = of.createTagList();
            for (Tag nextTag : tags.get(artistId)) {
                Tag tag = of.createTag();
                doc.addField((IndexField)ArtistIndexField.TAG, nextTag.getName());
                tag.setName(nextTag.getName());
                tag.setCount(new BigInteger(nextTag.getCount().toString()));
                tagList.getTag().add(tag);
            }
            artist.setTagList(tagList);
        }
        if (ipiCodes.containsKey(artistId)) {
            IpiList ipiList = of.createIpiList();
            for (String ipiCode : ipiCodes.get(artistId)) {
                doc.addField((IndexField)ArtistIndexField.IPI, ipiCode);
                ipiList.getIpi().add(ipiCode);
            }
            artist.setIpiList(ipiList);
        }
        ArtistBoostDoc.boost(artistGuid, doc);
        String store = MMDSerializer.serialize(artist);
        doc.addField((IndexField)ArtistIndexField.ARTIST_STORE, store);
        return doc.getLuceneDocument();
    }

    private void addArtistInitialized(String type, String artistName, String sortName, MbDocument doc) {
        String[] names;
        if (type == null || !type.equals(PERSON)) {
            return;
        }
        try {
            this.latinEncoder.encode(CharBuffer.wrap(artistName));
        }
        catch (CharacterCodingException cdd) {
            return;
        }
        if (sortName.contains(",") && (names = artistName.split(" ")).length >= 2) {
            doc.addField((IndexField)ArtistIndexField.ALIAS, names[0].substring(0, 1) + ' ' + names[names.length - 1]);
        }
    }
}

