/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.queries.function.ValueSource;

public abstract class DocValuesFieldSource
extends ValueSource {
    protected final String fieldName;
    protected final boolean direct;

    protected DocValuesFieldSource(String fieldName, boolean direct) {
        this.fieldName = fieldName;
        this.direct = direct;
    }

    protected final DocValues.Source getSource(AtomicReader reader, DocValues.Type defaultType) throws IOException {
        DocValues vals = reader.docValues(this.fieldName);
        if (vals == null) {
            switch (defaultType) {
                case BYTES_FIXED_SORTED: 
                case BYTES_VAR_SORTED: {
                    return DocValues.getDefaultSortedSource(defaultType, reader.maxDoc());
                }
            }
            return DocValues.getDefaultSource(defaultType);
        }
        return this.direct ? vals.getDirectSource() : vals.getSource();
    }

    public boolean isDirect() {
        return this.direct;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !this.getClass().isInstance(o)) {
            return false;
        }
        DocValuesFieldSource other = (DocValuesFieldSource)o;
        return this.fieldName.equals(other.fieldName) && this.direct == other.direct;
    }

    @Override
    public int hashCode() {
        int h = this.getClass().hashCode();
        h = 31 * h + this.fieldName.hashCode();
        h = 31 * h + (this.direct ? 1 : 0);
        return h;
    }

    @Override
    public String description() {
        return this.fieldName;
    }
}

